
package org.lsst.ccs.subsystems.fcs.ui;

import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.BoxLayout;

import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.AF0;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.AF0B;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.AF1;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.AF1B;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.AF3;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.AF3B;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.AP1;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.AP1B;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.AP2;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.AP2B;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.AP3;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.AP3B;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.FixedSizePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalTextComponent;

/**
 * A panel to display autochanger status : AP1, AP2, AP3, AF0, AF1, AF2
 *
 * @author virieux
 */
public class AutochangerStatusPanel extends JPanel {
    private static final long serialVersionUID = 1L;

    private final DigitalSwitch ap1Switch = new DigitalSwitch(AP1, AP1B);
    private final DigitalSwitch ap2Switch = new DigitalSwitch(AP2, AP2B);
    private final DigitalSwitch ap3Switch = new DigitalSwitch(AP3, AP3B);
    private final DigitalSwitch af0Switch = new DigitalSwitch(AF0, AF0B);
    private final DigitalSwitch af1Switch = new DigitalSwitch(AF1, AF1B);
    private final DigitalSwitch af3Switch = new DigitalSwitch(AF3, AF3B);

    private final DigitalSwitch[] digitalList = new DigitalSwitch[]{
        ap1Switch, ap2Switch, ap3Switch, af0Switch, af1Switch, af3Switch
    };

    public AutochangerStatusPanel() {
        initComponents();
    }


    /**
     * To update this panel from a map of sensors : name, value.
     */
    private class UpdateFromSensorList implements Runnable {

        private final Map<String, Serializable> sensorMap;

        public UpdateFromSensorList(Map<String, Serializable> sensorMap) {
            this.sensorMap = sensorMap;
        }

        @Override
        public void run() {
            for (DigitalSwitch ds: digitalList) {
                ds.updateColorComplementary(sensorMap);
            }
        }
    }

    /**
     * To update the Panel from a map of sensors.
     * status.
     *
     * @param sMap
     */
    public void updateFromSensorList(Map<String, Serializable> sMap) {
        SwingUtilities.invokeLater(new UpdateFromSensorList(sMap));
    }

    /**
     * To initialize all the components of this Panel.
     */
    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        // CameraProtectionPanel with status coming from autochanger
        JPanel statusPane = new JPanel();
        statusPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(VerticalTextComponent.getSubsystemColor("Autochanger"), 2), "Read on acPlutoGateway"));
        statusPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.insets = insets_std;
        statusPane.add(new JLabel("AP1 (at standby)"), gbc);
        gbc.gridy++;
        statusPane.add(new JLabel("AP2 (at handoff)"), gbc);
        gbc.gridy++;
        statusPane.add(new JLabel("AP3 (at online)"), gbc);
        gbc.gridy++;
        statusPane.add(new JLabel("AF0 (latches opened)"), gbc);
        gbc.gridy++;
        statusPane.add(new JLabel("AF1 (filter detected)"), gbc);
        gbc.gridy++;
        statusPane.add(new FixedSizePanel(new JLabel("AF3 (filter locked)"), Tools.getPlaceHolder("autochanger"), false), gbc);

        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.EAST;
        statusPane.add(ap1Switch, gbc);
        gbc.gridy++;
        statusPane.add(ap2Switch, gbc);
        gbc.gridy++;
        statusPane.add(ap3Switch, gbc);
        gbc.gridy++;
        statusPane.add(af0Switch, gbc);
        gbc.gridy++;
        statusPane.add(af1Switch, gbc);
        gbc.gridy++;
        statusPane.add(af3Switch, gbc);

        JPanel acStatusPane = new JPanel();
        acStatusPane.setLayout(new BoxLayout(acStatusPane, BoxLayout.X_AXIS));
        acStatusPane.add(new VerticalTextComponent("Autochanger"));
        acStatusPane.add(statusPane);

        setLayout(new CardLayout());
        add(acStatusPane);
        add(Tools.getPanelPlaceHolder("autochanger_pane"));
        setDefaultValues();
    }

    protected void setDefaultValues() {
        for (DigitalSwitch ds: digitalList) {
            ds.setColor(Color.gray);
        }
    }

    /**
     * Reset components to default values.
     */
    public void resetPanel() {
        setDefaultValues();
    }

    /**
     * To be displayed on the GUI.
     *
     * @return
     */
    @Override
    public String toString() {
        return "Autochanger Protection Status";
    }

    /**
     * Just for tests.
     *
     * @param args
     */
    public static void main(String[] args) {
        AutochangerStatusPanel d = new AutochangerStatusPanel();
        JFrame frame = new JFrame("AutochangerProtectionStatusPanel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

}
