/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.ui.ControllersViewPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalTextComponent;

public class SingleControllerPanel
extends JPanel {
    private static final Logger FCSLOG = Logger.getLogger(EPOSControllerPanel.class.getName());
    private static final String UNDEFINED = "UNDEFINED";
    private static final String NO_ERROR = "no error";
    private static final String ACTIVATED = "Activated";
    private static final String RELEASED = "Released";
    private final String fullPathControllerName;
    private final String controllerName;
    private final ControllersViewPanel controllersView;
    private final InterfaceGeneralGUI subs;
    private final boolean hasBrakeAttached;
    private final Set<Integer> errorCodeTracker = new HashSet<Integer>();
    private JTextField eposMode;
    private JTextField eposState;
    private JLabel brakeState;
    private JTextField errorStatus;
    private JTextField errorCount;
    private DigitalSwitch eposStateIcon;
    private DigitalSwitch errorIcon;
    private JButton enable;
    private JButton disable;
    private JButton reset;
    private boolean isControllerEnabled;

    public SingleControllerPanel(String controllerName, String systemName, String fullPathControllerName, InterfaceGeneralGUI subs, ControllersViewPanel controllersView, boolean hasBrakesAttached) {
        this.controllerName = controllerName;
        this.fullPathControllerName = fullPathControllerName;
        this.subs = subs;
        this.controllersView = controllersView;
        this.hasBrakeAttached = hasBrakesAttached;
        this.isControllerEnabled = true;
        this.initComponents(systemName);
    }

    private void resetActionPerformed() {
        FCSLOG.info("[SingleControllerPanel] reset from " + this.fullPathControllerName);
        this.subs.sendCommandSwingWorker("faultReset", 1000L, this.fullPathControllerName);
    }

    private void deactivateActionPerformed() {
        FCSLOG.info("[SingleControllerPanel] deactivate from " + this.fullPathControllerName);
        this.subs.sendCommandSwingWorker("goToSwitchOnDisabled", 1000L, this.fullPathControllerName);
    }

    private void activateActionPerformed() {
        FCSLOG.info("[SingleControllerPanel] activate from " + this.fullPathControllerName);
        this.subs.sendCommandSwingWorker("goToOperationEnable", 1000L, this.fullPathControllerName);
    }

    public void updateController(StatusDataPublishedByEPOSController status) {
        if (this.isControllerEnabled) {
            SwingUtilities.invokeLater(new UpdateController(status));
        }
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.isControllerEnabled != b) {
            this.enableButtons(b);
            this.isControllerEnabled = b;
        }
    }

    private void enableButtons(boolean b) {
        this.enable.setEnabled(b);
        this.disable.setEnabled(b);
        this.reset.setEnabled(b);
    }

    private VerticalTextComponent createSystemTag(String name) {
        return new VerticalTextComponent(name);
    }

    private JPanel createEposModePanel() {
        JPanel pane = new JPanel();
        pane.setLayout(new FlowLayout(0, 0, 0));
        pane.add(new JLabel("EPOS mode:"));
        this.eposMode = new JTextField(UNDEFINED);
        this.eposMode.setEditable(false);
        pane.add(this.eposMode);
        return pane;
    }

    private JPanel createEposStatePanel() {
        JPanel pane = new JPanel();
        pane.setLayout(new FlowLayout(0, 0, 0));
        this.eposStateIcon = new DigitalSwitch();
        this.eposState = new JTextField(UNDEFINED);
        this.eposState.setEditable(false);
        pane.add(this.eposStateIcon);
        pane.add(this.eposState);
        return pane;
    }

    private JPanel createBrakeStatePanel(boolean attachedToController) {
        CardLayout cl = new CardLayout();
        JPanel pane = new JPanel(cl);
        JPanel cardWithBrakes = new JPanel();
        JPanel cardWithoutBrakes = new JPanel();
        cardWithBrakes.setLayout(new FlowLayout(0, 0, 0));
        cardWithBrakes.add(new JLabel("Brake:"));
        this.brakeState = new JLabel(UNDEFINED);
        cardWithBrakes.add(this.brakeState);
        cardWithBrakes.setAlignmentX(1.0f);
        pane.add(cardWithBrakes);
        pane.add(cardWithoutBrakes);
        if (attachedToController) {
            cl.first(pane);
        } else {
            cl.last(pane);
        }
        return pane;
    }

    private JPanel createErrorStatusPanel() {
        JPanel pane = new JPanel();
        pane.setLayout(new FlowLayout(0, 0, 0));
        this.errorIcon = new DigitalSwitch();
        this.errorStatus = new JTextField(NO_ERROR);
        this.errorStatus.setEditable(false);
        pane.add(this.errorIcon);
        pane.add(this.errorStatus);
        return pane;
    }

    private JPanel createErrorCountPanel() {
        JPanel pane = new JPanel();
        pane.setLayout(new FlowLayout(0, 0, 0));
        this.errorCount = new JTextField("0");
        this.errorCount.setEditable(false);
        pane.add(new JLabel("Number of errors:"));
        pane.add(this.errorCount);
        this.reset = new JButton("Reset");
        pane.add(this.reset);
        this.reset.setToolTipText("Command: faultReset");
        this.reset.addActionListener(evt -> this.resetActionPerformed());
        return pane;
    }

    private JPanel createCommandPanel() {
        JPanel pane = new JPanel();
        this.enable = new JButton(Tools.formatButtonLabelWhenLinkedWithATooltip("Enable"));
        pane.add(this.enable);
        this.disable = new JButton(Tools.formatButtonLabelWhenLinkedWithATooltip("Disable"));
        pane.add(this.disable);
        this.enable.setToolTipText(Tools.formatTooltipText("goToOperationEnable", "Enable Controller"));
        this.disable.setToolTipText(Tools.formatTooltipText("goToSwitchOnDisabled", "Disable Controller (should be the default state)"));
        this.enable.addActionListener(evt -> this.activateActionPerformed());
        this.disable.addActionListener(evt -> this.deactivateActionPerformed());
        return pane;
    }

    private void initComponents(String subsystem) {
        JPanel controllerPanel = new JPanel();
        controllerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(VerticalTextComponent.getSubsystemColor(subsystem), 2), this.controllerName));
        controllerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 23;
        controllerPanel.add((Component)this.createEposModePanel(), gbc);
        ++gbc.gridy;
        controllerPanel.add((Component)this.createEposStatePanel(), gbc);
        ++gbc.gridy;
        gbc.anchor = 22;
        controllerPanel.add((Component)this.createCommandPanel(), gbc);
        ++gbc.gridy;
        gbc.anchor = 10;
        JSeparator sep = new JSeparator(0);
        sep.setPreferredSize(new Dimension(25, 10));
        sep.setVisible(true);
        gbc.fill = 2;
        controllerPanel.add((Component)sep, gbc);
        ++gbc.gridy;
        gbc.anchor = 21;
        controllerPanel.add((Component)this.createErrorStatusPanel(), gbc);
        ++gbc.gridy;
        controllerPanel.add((Component)this.createErrorCountPanel(), gbc);
        ++gbc.gridy;
        controllerPanel.add((Component)this.createBrakeStatePanel(this.hasBrakeAttached), gbc);
        this.setLayout(new BoxLayout(this, 0));
        this.add((Component)this.createSystemTag(subsystem), "Before");
        this.add((Component)controllerPanel, "Center");
    }

    private class UpdateController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        public UpdateController(StatusDataPublishedByEPOSController status) {
            this.s = status;
        }

        public boolean processErrorCode(int errorCode) {
            if (!SingleControllerPanel.this.errorCodeTracker.contains(errorCode)) {
                SingleControllerPanel.this.errorCodeTracker.add(errorCode);
                return true;
            }
            return false;
        }

        public void clearErrors() {
            SingleControllerPanel.this.errorCodeTracker.clear();
        }

        @Override
        public void run() {
            if (this.s.getMode() != null) {
                SingleControllerPanel.this.eposMode.setText(this.s.getMode().toString());
            }
            if (this.s.isInitialized()) {
                SingleControllerPanel.this.errorIcon.setColor(this.s.isInError() ? Color.RED : Tools.greenColor);
                SingleControllerPanel.this.errorStatus.setText(this.s.getErrorRegister());
                SingleControllerPanel.this.errorCount.setText(String.valueOf(this.s.getErrorHistoryNB()));
                if (this.s.getErrorHistoryNB() > 0) {
                    if (this.processErrorCode(this.s.getLastErrorCode())) {
                        SingleControllerPanel.this.controllersView.updateErrorListing(SingleControllerPanel.this.controllerName, this.s.getLastErrorCode(), this.s.getLastErrorName());
                    }
                } else {
                    this.clearErrors();
                    SingleControllerPanel.this.controllersView.clearErrorListing(SingleControllerPanel.this.controllerName);
                }
            } else if (this.s.isBooted()) {
                SingleControllerPanel.this.errorIcon.setColor(Color.ORANGE);
                SingleControllerPanel.this.errorStatus.setText("Not initialized");
                SingleControllerPanel.this.setEnabled(true);
            } else {
                SingleControllerPanel.this.errorIcon.setColor(Color.RED);
                SingleControllerPanel.this.errorStatus.setText("Not booted");
                SingleControllerPanel.this.setEnabled(false);
            }
            if (this.s.isBooted() && this.s.getState() != null) {
                SingleControllerPanel.this.eposState.setText(this.s.getState().name());
                SingleControllerPanel.this.eposStateIcon.setColor(this.s.getState().getColor());
            } else if (!this.s.isBooted()) {
                SingleControllerPanel.this.eposState.setText("Not booted");
                SingleControllerPanel.this.eposStateIcon.setColor(Color.RED);
            }
            if (this.s.isBooted() && this.s.isControllerWithBrake() && this.s.isBrakeActivated()) {
                SingleControllerPanel.this.brakeState.setText(SingleControllerPanel.ACTIVATED);
            } else if (this.s.isControllerWithBrake() && !this.s.isBrakeActivated()) {
                SingleControllerPanel.this.brakeState.setText(SingleControllerPanel.RELEASED);
            } else if (SingleControllerPanel.this.hasBrakeAttached) {
                SingleControllerPanel.this.brakeState.setText("");
            }
        }
    }
}

