
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.*;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterPresenceStatus;

/**
 *
 * @author virieux
 */
public class Tools {
    private static final Logger FCSLOG = Logger.getLogger(Tools.class.getName());

    public static final Color greenColor = new Color(0, 165, 0);
    public static final Color NICE_PINK = new Color(255, 0, 255);
    private static final Color CONFIG_COLOR = new Color(17, 102, 117);
    public static final String fcsFontInString = "Lucida Grande";
    public static final Font BIG_FONT = new Font(fcsFontInString, 1, 14);
    public static final Font HUGE_FONT = new Font(fcsFontInString, 1, 20);
    public static final Font VERY_BIG_FONT = new Font("Tahoma", 1, 18);
    public static final Font defaultFont =  UIManager.getDefaults().getFont("Label.font");

    public static final Insets insets_std = new Insets(4, 4, 4, 4);
    public static final Insets insets_big = new Insets(14, 4, 6, 4);
    public static final Insets insets_small = new Insets(1, 1, 1, 1);

    public static final String ZERO_VALUE = "0.0";
    public static final String UNKNOWN_VALUE = "999.99";
    public static final String UNKNOWN_STATE = "UNKNOWN STATE";
    public static final String UNKNOWN_ERROR = "UNKNOWN ERROR";

    public static final String NONE = "None";
    public static final String TIRETS = "--";

    /* for PLC panels */
    /* height of vertical lines at start and end of subpanels for PLC panels */
    public static final int SP_V_LINE_HEIGHT = 75;

    /* starting Y point for vertical lines at start and end of subpanels for PLC panels */
    public static final int SP_V_LINE_STARTINGY = 22;

    public static final Dimension preferedPanelSize = new Dimension(1200, 600);

    public static final String AP1_EXP = "<HTML><b>AP1</b>: autochanger at STANDBY position</HTML>";
    public static final String AP2_EXP = "<HTML><b>AP2</b>: autochanger at HANDOFF position</HTML>";
    public static final String AP3_EXP = "<HTML><b>AP3</b>: autochanger at ONLINE position</HTML>";
    public static final String AF0_EXP = "<HTML><b>AF0</b>: autochanger latches opened</HTML>";
    public static final String AF1_EXP = "<HTML><b>AF1</b>: filter engaged on autochanger</HTML>";
    public static final String AF3_EXP = "<HTML><b>AF3</b>: filter engaged and latches closed on autochanger  &nbsp</HTML>"; 
    public static final String CS_EXP = "<HTML><b>CS</b>: carousel stopped at STANDBY position</HTML>";
    public static final String CFC_EXP = "<HTML><b>CFC</b>: filter LOCKED on carousel</HTML>";
    public static final String CF0_EXP = "<HTML><b>CF0</b>: no filter on carousel at STANDBY</HTML>";
    public static final String CF1_EXP = "<HTML><b>CF1</b>: filter on carousel at STANDBY</HTML>";
    public static final String NO_LOCKOUT = "<B>NOT</B><BR>Lock Out Bay L</BR>";

    /**
     *
     * @param filterPresenceStatus
     * @return
     */
    public static Color getFilterPresenceColor(String filterPresenceStatus) {
        if (filterPresenceStatus.equals(FilterPresenceStatus.ERROR.toString())) {
            return Color.red;
        } else if (filterPresenceStatus.equals(FilterPresenceStatus.LOCKABLE.toString())) {
            return greenColor;
        } else if (filterPresenceStatus.equals(FilterPresenceStatus.NOT_LOCKABLE.toString())) {
            return Color.orange;
        } else if (filterPresenceStatus.equals(FilterPresenceStatus.NOFILTER.toString())) {
            return Color.gray;
        } else {
            FCSLOG.severe("Unknown Filter Presence Status " + filterPresenceStatus);
            return Color.gray;
        }
    }


    /**
     * Return value of parameterName found in map config if it exits.
     * If config doesn't contain parameterName, returns 0 and log and ERROR.
     * @param config
     * @param parameterName
     * @return
     */
    public static int toInt(Map<String, String> config, String parameterName) {
        if (config.containsKey(parameterName)) {
            return Integer.parseInt(config.get(parameterName));
        } else {
            FCSLOG.severe("no such parameter in ConfigurationInfo:" + parameterName);
            return 0;
        }
    }

    /**
     * reset a table : remove all rows.
     *
     * @param table
     */
    public static void resetTable(JTable table) {
        FCSLOG.fine(() -> " resetting table " + table.getName());
        DefaultTableModel tableModel = (DefaultTableModel) table.getModel();
        tableModel.getDataVector().removeAllElements();
        tableModel.fireTableDataChanged();
    }

    /**
     *
     * @param fullPathName
     * @return return shortName of a component given a full path name.
     */
    public static String getShortComponentName(String fullPathName) {
        int ind = fullPathName.lastIndexOf("/");
        return ind >= 0 ? fullPathName.substring(ind + 1) : fullPathName;
    }

        /**
     * Create a Panel with a component name to display above the component and a
     * component.
     *
     * @param componentName
     * @param component
     * @param drawHLineBefore if true an horizontal line is drawn before the
     * component
     * @param drawHLineAfter if false an horizontal line is drawn after the
     * component
     * @return
     */
    public static JPanel createPanelWithComponent(String componentName, JComponent component, boolean drawHLineBefore, boolean drawHLineAfter) {
        int length = 30;
        return createPanelWithComponent(componentName, component, drawHLineBefore, drawHLineAfter, length);
    }

    /**
     * Create a Panel with a component name to display above the component and a
     * component.
     *
     * @param componentName
     * @param component
     * @param drawHLineBefore if true an horizontal line is drawn before the
     * component
     * @param drawHLineAfter if false an horizontal line is drawn after the
     * component
     * @param length of the lines
     * @return
     */
    public static JPanel createPanelWithComponent(String componentName, JComponent component, boolean drawHLineBefore, boolean drawHLineAfter,
            int length) {
        int hlStartingY;
        if (component instanceof DigitalSwitch) {
            hlStartingY = 10;
        } else if (component instanceof DiamondSwitch) {
            hlStartingY = 25;
        } else {
            hlStartingY = 5;
        }
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        if (drawHLineBefore) {
            gbcp.gridy++;
            panel.add(new HorizontalLine(length, hlStartingY), gbcp);
            gbcp.gridx++;
        }
        /* label line*/
        gbcp.gridy = 0;
        panel.add(new JLabel("<HTML><CENTER>" + componentName + "</CENTER></HTML>"), gbcp);
        /* component line */
        gbcp.gridy++;
        panel.add(component, gbcp);
        if (drawHLineAfter) {
            gbcp.gridx++;
            panel.add(new HorizontalLine(length, hlStartingY), gbcp);
        }
        return panel;
    }

    /**
     * to add a component to the right on a horizontal line
     *
     * @param panel
     * @param gbcl
     * @param componentName
     * @param component
     * @param drawLine if true draw an HorizontalLine after the component
     */
    public static void addToHorizontalLine(JPanel panel, GridBagConstraints gbcl, String componentName, JComponent component, boolean drawLine) {
        int hlStartingY = 15;
        /* label line */
        panel.add(new JLabel("<HTML><CENTER>" + componentName + "</CENTER></HTML>"), gbcl);
        /* component line */
        gbcl.gridy++;
        panel.add(component, gbcl);
        if (drawLine) {
            gbcl.gridx++;
            panel.add(new HorizontalLine(hlStartingY), gbcl);
        }
        gbcl.gridy--;
        if (drawLine) {
            gbcl.gridx++;
        }
    }

    public static JPanel create_subPanelWith2Switch(String name1, JComponent switch1, String name2, JComponent switch2) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);
        /* upper line */
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        panel.add(createPanelWithComponent(name1, switch1, true, true), gbcp);
        gbcp.gridx++;
        /* lower line */
        gbcp.gridy++;
        gbcp.gridx = 1;
        panel.add(createPanelWithComponent(name2, switch2, true, true), gbcp);
        /* last vertical line*/
        gbcp.gridy = 0;
        gbcp.gridx = 5;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);
        return panel;
    }

    public static TitledBorder getConfigurationTitle() {
            return BorderFactory.createTitledBorder(
                BorderFactory.createLineBorder(CONFIG_COLOR, 2),
                "Configuration", TitledBorder.TRAILING, TitledBorder.BOTTOM,
                defaultFont.deriveFont(Font.ITALIC), CONFIG_COLOR);

    }

}
