/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByPlutoGateway;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGatherPanel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselGatherPanel;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderGatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.FcsGUI;
import org.lsst.ccs.subsystems.fcs.ui.FcsGeneralViewPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenDevicePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.HYTTC580Panel;
import org.lsst.ccs.subsystems.fcs.ui.commons.PlutoGatewayPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class FcsGatherPanel
extends GatherPanel {
    private static final long serialVersionUID = 2279646593279606470L;
    private FcsGUI subs;
    private FcsGeneralViewPanel generalViewPanel;
    private CarouselGatherPanel carouselGatherPanel;
    private AutochangerGatherPanel autochangerGatherPanel;
    private LoaderGatherPanel loaderGatherPanel;

    public FcsGatherPanel(String tcpProxyName) {
        super(tcpProxyName);
    }

    public FcsGatherPanel(FcsGUI subs) {
        super("canbus0");
        this.subs = subs;
        this.generalViewPanel = new FcsGeneralViewPanel();
        this.generalViewPanel.setSubs(subs);
        this.carouselGatherPanel = new CarouselGatherPanel(subs, "canbus0");
        this.autochangerGatherPanel = new AutochangerGatherPanel(subs, "canbus0");
        this.loaderGatherPanel = new LoaderGatherPanel(subs, "canbus1");
    }

    public FcsGeneralViewPanel getGeneralViewPanel() {
        return this.generalViewPanel;
    }

    public CarouselGatherPanel getCarouselGatherPanel() {
        return this.carouselGatherPanel;
    }

    public AutochangerGatherPanel getAutochangerGatherPanel() {
        return this.autochangerGatherPanel;
    }

    public LoaderGatherPanel getLoaderGatherPanel() {
        return this.loaderGatherPanel;
    }

    public EPOSControllerPanel getClampXminusControllerPanel() {
        return this.carouselGatherPanel.getClampXminusControllerPanel();
    }

    public EPOSControllerPanel getClampXplusControllerPanel() {
        return this.carouselGatherPanel.getClampXplusControllerPanel();
    }

    public EPOSControllerPanel getCarouselControllerPanel() {
        return this.carouselGatherPanel.getCarouselControllerPanel();
    }

    public HYTTC580Panel getHyTTCPanel() {
        return this.carouselGatherPanel.getHyTTCPanel();
    }

    public CanOpenDevicePanel getCancbxAI814Panel() {
        return this.carouselGatherPanel.getCancbxAI814Panel();
    }

    public CanOpenDevicePanel getCancbxPT100Panel() {
        return this.carouselGatherPanel.getCancbxPT100Panel();
    }

    public PlutoGatewayPanel getPlutoGatewayPanel() {
        return this.autochangerGatherPanel.getPlutoGatewayPanel();
    }

    public CanOpenDevicePanel getOnlineStrainGaugePanel() {
        return this.autochangerGatherPanel.getOnlineStrainGaugePanel();
    }

    public EPOSControllerPanel getLatchXminusControllerPanel() {
        return this.autochangerGatherPanel.getLatchXminusControllerPanel();
    }

    public EPOSControllerPanel getLatchXplusControllerPanel() {
        return this.autochangerGatherPanel.getLatchXplusControllerPanel();
    }

    public EPOSControllerPanel getAcTruckXminusControllerPanel() {
        return this.autochangerGatherPanel.getAcTruckXminusControllerPanel();
    }

    public EPOSControllerPanel getAcTruckXplusControllerPanel() {
        return this.autochangerGatherPanel.getAcTruckXplusControllerPanel();
    }

    public EPOSControllerPanel getOnlineClampXminusControllerPanel() {
        return this.autochangerGatherPanel.getOnlineClampXminusControllerPanel();
    }

    public EPOSControllerPanel getOnlineClampXplusControllerPanel() {
        return this.autochangerGatherPanel.getOnlineClampXplusControllerPanel();
    }

    public EPOSControllerPanel getOnlineClampYminusControllerPanel() {
        return this.autochangerGatherPanel.getOnlineClampYminusControllerPanel();
    }

    @Override
    public void updateFromStatusData(KeyValueData data) {
        if ("canbus0".equals(data.getKey())) {
            this.updateCanOpenHardwarePanel((Integer)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByEPOSController) {
            this.updateCanOpenHardwarePanel(Tools.getShortComponentName(data.getKey()), (StatusDataPublishedByHardware)data.getValue());
            if ("carouselController".equals(data.getKey())) {
                this.generalViewPanel.updateController((StatusDataPublishedByEPOSController)data.getValue());
            } else if ("carrierController".equals(Tools.getShortComponentName(data.getKey()))) {
                this.generalViewPanel.updateCarrierController((StatusDataPublishedByEPOSController)data.getValue());
            } else if ("hooksController".equals(Tools.getShortComponentName(data.getKey()))) {
                this.generalViewPanel.updateClampController((StatusDataPublishedByEPOSController)data.getValue());
            }
        } else if (data.getValue() instanceof StatusDataPublishedByPlutoGateway) {
            this.updateCanOpenHardwarePanel(Tools.getShortComponentName(data.getKey()), (StatusDataPublishedByHardware)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByHardware) {
            this.updateCanOpenHardwarePanel(Tools.getShortComponentName(data.getKey()), (StatusDataPublishedByHardware)data.getValue());
        }
        this.carouselGatherPanel.updateFromStatusData(data);
        this.autochangerGatherPanel.updateFromStatusData(data);
        this.loaderGatherPanel.updateFromStatusData(data);
        this.generalViewPanel.updateFromStatusData(data);
    }

    @Override
    public void updateFromConfigurationInfo(ConfigurationInfo configInfo) {
        this.carouselGatherPanel.updateFromConfigurationInfo(configInfo);
        this.autochangerGatherPanel.updateFromConfigurationInfo(configInfo);
        this.loaderGatherPanel.updateFromConfigurationInfo(configInfo);
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) {
        super.initializeGUIWithConfigInfo(configInfo, hardwareNames);
        this.carouselGatherPanel.initializeGUIWithConfigInfo(configInfo, hardwareNames);
        this.autochangerGatherPanel.initializeGUIWithConfigInfo(configInfo, hardwareNames);
    }

    @Override
    public void initializeGUIWithLoaderConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) {
        this.loaderGatherPanel.initializeGUIWithConfigInfo(configInfo, hardwareNames);
    }

    @Override
    public void initializeGuiWithAutochangerSensorsList(ConfigurationInfo configInfo, List<String> sensorsList) {
        FCSLOG.info("initializeGuiWithSensorsList: " + sensorsList.toString());
        this.autochangerGatherPanel.initializeGuiWithAutochangerSensorsList(configInfo, sensorsList);
    }

    @Override
    public void initializeGuiWithLoaderSensorsList(ConfigurationInfo configInfo, List<String> sensorsList) {
        FCSLOG.info("initializeGuiWithLoaderSensorsList: " + sensorsList.toString());
        this.loaderGatherPanel.initializeGuiWithLoaderSensorsList(configInfo, sensorsList);
    }

    @Override
    public void initializeGUIWithControllersMap(Map<String, String> controllersMap) {
        this.autochangerGatherPanel.initializeGUIWithControllersMap(controllersMap);
    }

    @Override
    public void initializeGUIWithFiltersInfo(ConfigurationInfo configInfo, List<String> filterNamesList) throws InterruptedException, InvocationTargetException {
        this.carouselGatherPanel.initializeGUIWithFiltersInfo(configInfo, filterNamesList);
    }

    @Override
    public void resetPanel() {
        super.resetPanel();
        this.carouselGatherPanel.resetPanel();
        this.autochangerGatherPanel.resetPanel();
        this.loaderGatherPanel.resetPanel();
    }
}

