/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.ui.InterfaceLoaderGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.DiamondSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class LoaderGeneralViewPanel
extends JPanel {
    private static final long serialVersionUID = 8834267363875256916L;
    private InterfaceLoaderGUI subs;
    private final JLabel loaderDockedLabel = new JLabel("LOADER DOCKED");
    private final JPanel fakeSensorsPanel = new JPanel();
    private final JPanel controlPanel = new JPanel();
    private final String fullPathCarrierName = "loader/carrier";
    public static final String AF1 = "acAF1s";
    public static final String AF1B = "acAF1b";
    private final JPanel cpsPanel = new JPanel();
    private final JPanel keysPanel = new JPanel();
    private static final DigitalSwitch DOCKEDSWITCH = new DigitalSwitch("loaderOnCameraSensor0", "loaderOnCameraSensor1");
    private static final DigitalSwitch AP2SWITCH = new DigitalSwitch("acAP2s", "acAP2b");
    private static final DigitalSwitch AF0SWITCH = new DigitalSwitch("acAF0s", "acAF0b");
    private static final DigitalSwitch AF1SWITCH = new DigitalSwitch("acAF1s", "acAF1b");
    private static final DigitalSwitch AF3SWITCH = new DigitalSwitch("acAF3s", "acAF3b");
    private static final DigitalSwitch NOLOCKOUTSWITCH = new DigitalSwitch("keyLockb", "keyLock");
    private static final DigitalSwitch ENGINEERINGSWITCH = new DigitalSwitch("keyEng", "keyEngb");
    private final DiamondSwitch carrierRelaySwitch = new DiamondSwitch("loaderCarrierRelayStatus");
    private final DiamondSwitch hooksRelaySwitch = new DiamondSwitch("loaderHooksRelayStatus");
    private final DiamondSwitch safetyBeltPresenceSwitch = new DiamondSwitch("loaderChainPresenceSensor");
    private final DiamondSwitch noDefaultStatusSwitch = new DiamondSwitch("loaderDefaultStatus");
    private final JPanel clampPanel = new JPanel();
    private static final DigitalSwitch FILTERPRESENCESWITCH = new DigitalSwitch("loaderFilterPresenceSensor0", "loaderFilterPresenceSensor1");
    private final JLabel clampHomingLabel = new JLabel();
    private final JLabel clampStateLabel = new JLabel();
    private final JLabel clampPositionLabel = new JLabel();
    private final JLabel forceStatusLabel = new JLabel();
    private final DigitalSwitch clampControllerSwitch = new DigitalSwitch();
    private final JPanel carrierPanel = new JPanel();
    private final JLabel carrierPositionLabel = new JLabel();
    private final JLabel carrierStatusLabel = new JLabel();
    private final JLabel carrierSpeedLabel = new JLabel();
    private final JProgressBar carrierPositionProgressBar = new JProgressBar(1, 0, 100);
    private final DigitalSwitch carrierControllerSwitch = new DigitalSwitch();
    private final JButton loadFilterButton = new JButton("loadFilterIntoBenchOrStorageBox");
    private final JButton unloadFilterButton = new JButton("unloadFilterFromBenchOrStorageBox");
    private final JButton moveFilterStoHButton = new JButton("moveFilterToHandoff");
    private final JButton moveFilterHtoSButton = new JButton("moveFilterToStorage");
    private final JButton openClampAndMoveEmptyToSButton = new JButton("openClampAndMoveEmptyToStorage");
    private final JButton moveEmptyToHandCloseButton = new JButton("moveEmptyToHandoffAndClose");
    private final DigitalSwitch[] complementarySwitches = new DigitalSwitch[]{AF0SWITCH, AF3SWITCH, AP2SWITCH, AF1SWITCH, ENGINEERINGSWITCH, NOLOCKOUTSWITCH};
    private final DigitalSwitch[] redondantSwitches = new DigitalSwitch[]{DOCKEDSWITCH, FILTERPRESENCESWITCH};
    private final DiamondSwitch[] diamondSwitchesGreenGray = new DiamondSwitch[]{this.carrierRelaySwitch, this.hooksRelaySwitch, this.safetyBeltPresenceSwitch};

    public LoaderGeneralViewPanel() {
        this.initComponents();
    }

    public LoaderGeneralViewPanel(InterfaceLoaderGUI subs) {
        this.subs = subs;
        this.initComponents();
    }

    public void setSubsystem(InterfaceLoaderGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateCarrier(StatusDataPublishedByLoaderCarrier status) {
        SwingUtilities.invokeLater(new UpdateCarrier(status));
    }

    public void updateFromSensorList(Map<String, Serializable> sensorMap) {
        SwingUtilities.invokeLater(new UpdateFromSensorList(sensorMap));
    }

    public void updateCarrierController(StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateCarrierController(status));
    }

    public void updateClampController(StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateClampController(status));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), "LOADER"));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        JPanel clampControllerPanel = new JPanel();
        clampControllerPanel.setBorder(BorderFactory.createEtchedBorder());
        clampControllerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        clampControllerPanel.add((Component)new JLabel("Controller Status"), gbc);
        ++gbc.gridy;
        clampControllerPanel.add((Component)this.clampControllerSwitch, gbc);
        this.clampControllerSwitch.setSize(40);
        JPanel filterPresencePanel = new JPanel();
        filterPresencePanel.setBorder(BorderFactory.createEtchedBorder());
        filterPresencePanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        filterPresencePanel.add((Component)new JLabel("Filter Presence"), gbc);
        ++gbc.gridy;
        filterPresencePanel.add((Component)FILTERPRESENCESWITCH, gbc);
        FILTERPRESENCESWITCH.setSize(40);
        this.clampPanel.setBorder(BorderFactory.createTitledBorder("Loader Hooks"));
        this.clampPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        this.clampPanel.add((Component)new JLabel("Homing:"), gbc);
        ++gbc.gridx;
        gbc.anchor = 22;
        this.clampPanel.add((Component)this.clampHomingLabel, gbc);
        --gbc.gridx;
        ++gbc.gridy;
        gbc.anchor = 21;
        this.clampPanel.add((Component)clampControllerPanel, gbc);
        ++gbc.gridx;
        this.clampPanel.add((Component)filterPresencePanel, gbc);
        --gbc.gridx;
        ++gbc.gridy;
        gbc.anchor = 21;
        int y = gbc.gridy++;
        this.clampPanel.add((Component)new JLabel("Hooks Status"), gbc);
        this.clampPanel.add((Component)new JLabel("Hooks Position"), gbc);
        ++gbc.gridy;
        this.clampPanel.add((Component)new JLabel("Clamped Force Status"), gbc);
        gbc.gridy = y;
        ++gbc.gridx;
        gbc.anchor = 10;
        this.clampPanel.add((Component)this.clampStateLabel, gbc);
        ++gbc.gridy;
        gbc.anchor = 22;
        this.clampPanel.add((Component)this.clampPositionLabel, gbc);
        ++gbc.gridy;
        gbc.anchor = 10;
        this.clampPanel.add((Component)this.forceStatusLabel, gbc);
        JPanel controllerPanel = new JPanel();
        controllerPanel.setBorder(BorderFactory.createEtchedBorder());
        controllerPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        controllerPanel.add((Component)new JLabel("Controller Status"), gbc);
        ++gbc.gridy;
        controllerPanel.add((Component)this.carrierControllerSwitch, gbc);
        this.carrierControllerSwitch.setSize(50);
        this.carrierPanel.setBorder(BorderFactory.createTitledBorder("Loader Carrier"));
        this.carrierPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        this.carrierPanel.add((Component)new JLabel("Carrier Position"), gbc);
        ++gbc.gridy;
        this.carrierPanel.add((Component)new JLabel("Carrier Status"), gbc);
        ++gbc.gridy;
        this.carrierPanel.add((Component)new JLabel("Carrier Speed"), gbc);
        ++gbc.gridy;
        int y2 = gbc.gridy;
        this.carrierPanel.add((Component)controllerPanel, gbc);
        gbc.gridy = 0;
        ++gbc.gridx;
        gbc.anchor = 22;
        this.carrierPanel.add((Component)this.carrierPositionLabel, gbc);
        ++gbc.gridy;
        this.carrierPanel.add((Component)this.carrierStatusLabel, gbc);
        ++gbc.gridy;
        this.carrierPanel.add((Component)this.carrierSpeedLabel, gbc);
        gbc.gridy = y2;
        gbc.gridx = 1;
        gbc.gridheight = 2;
        gbc.anchor = 10;
        this.carrierPositionProgressBar.setBorderPainted(true);
        this.carrierPositionProgressBar.setBackground(Tools.greenColor);
        this.carrierPositionProgressBar.setStringPainted(true);
        this.carrierPanel.add((Component)this.carrierPositionProgressBar, gbc);
        this.loadFilterButton.addActionListener(evt -> this.loadFilterActionPerformed(evt));
        this.unloadFilterButton.addActionListener(evt -> this.unloadFilterActionPerformed(evt));
        this.moveFilterStoHButton.addActionListener(evt -> this.moveFilterStoHActionPerformed(evt));
        this.moveFilterHtoSButton.addActionListener(evt -> this.moveFilterHtoSActionPerformed(evt));
        this.openClampAndMoveEmptyToSButton.addActionListener(evt -> this.openClampAndMoveEmptyToStoSActionPerformed(evt));
        this.moveEmptyToHandCloseButton.addActionListener(evt -> this.moveEmptyToHandCloseActionPerformed(evt));
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.insets = Tools.insets_std;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.fill = 2;
        this.controlPanel.add((Component)this.loadFilterButton, gbc0);
        ++gbc0.gridy;
        this.controlPanel.add((Component)this.unloadFilterButton, gbc0);
        ++gbc0.gridy;
        this.controlPanel.add((Component)this.moveFilterStoHButton, gbc0);
        ++gbc0.gridy;
        this.controlPanel.add((Component)this.moveFilterHtoSButton, gbc0);
        ++gbc0.gridy;
        this.controlPanel.add((Component)this.openClampAndMoveEmptyToSButton, gbc0);
        ++gbc0.gridy;
        this.controlPanel.add((Component)this.moveEmptyToHandCloseButton, gbc0);
        this.fakeSensorsPanel.setBorder(BorderFactory.createLineBorder(Color.BLUE, 6));
        this.fakeSensorsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.fill = 2;
        this.fakeSensorsPanel.add((Component)this.loaderDockedLabel, gbc1);
        ++gbc1.gridx;
        this.fakeSensorsPanel.add((Component)DOCKEDSWITCH, gbc1);
        this.cpsPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA, 6));
        this.cpsPanel.setLayout(new GridBagLayout());
        gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.anchor = 17;
        gbc0.insets = Tools.insets_std;
        this.cpsPanel.add((Component)new JLabel("AP2 (AC at handoff)"), gbc0);
        ++gbc0.gridy;
        this.cpsPanel.add((Component)new JLabel("AF0 (AC latches opened)"), gbc0);
        ++gbc0.gridy;
        this.cpsPanel.add((Component)new JLabel("AF1 (filter detected in AC)"), gbc0);
        ++gbc0.gridy;
        this.cpsPanel.add((Component)new JLabel("AF3 (filter locked in AC)"), gbc0);
        gbc0.gridx = 1;
        gbc0.gridy = 0;
        gbc0.anchor = 13;
        this.cpsPanel.add((Component)AP2SWITCH, gbc0);
        ++gbc0.gridy;
        this.cpsPanel.add((Component)AF0SWITCH, gbc0);
        ++gbc0.gridy;
        this.cpsPanel.add((Component)AF1SWITCH, gbc0);
        ++gbc0.gridy;
        this.cpsPanel.add((Component)AF3SWITCH, gbc0);
        this.keysPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA, 6));
        this.keysPanel.setLayout(new GridBagLayout());
        gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.anchor = 17;
        gbc0.insets = Tools.insets_std;
        this.keysPanel.add((Component)new JLabel("No Lockout"), gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)new JLabel("Engineering key"), gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)new JLabel("Carrier relay"), gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)new JLabel("Hooks relay"), gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)new JLabel("Safety belt presence"), gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)new JLabel("No Default Status"), gbc0);
        gbc0.gridx = 1;
        ++gbc0.gridy;
        gbc0.gridy = 0;
        gbc0.anchor = 13;
        this.keysPanel.add((Component)NOLOCKOUTSWITCH, gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)ENGINEERINGSWITCH, gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)this.carrierRelaySwitch, gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)this.hooksRelaySwitch, gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)this.safetyBeltPresenceSwitch, gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)this.noDefaultStatusSwitch, gbc0);
        gbc = new GridBagConstraints();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), "LOADER General View"));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        gbc.anchor = 512;
        gbc.insets = Tools.insets_big;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.fakeSensorsPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.cpsPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.keysPanel, gbc);
        --gbc.gridx;
        ++gbc.gridy;
        this.add((Component)this.clampPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.carrierPanel, gbc);
        --gbc.gridx;
        ++gbc.gridy;
        this.add((Component)this.controlPanel, gbc);
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        DOCKEDSWITCH.setColor(Color.gray);
        AP2SWITCH.setColor(Color.gray);
        AF0SWITCH.setColor(Color.gray);
        AF1SWITCH.setColor(Color.gray);
        AF3SWITCH.setColor(Color.gray);
        NOLOCKOUTSWITCH.setColor(Color.gray);
        ENGINEERINGSWITCH.setColor(Color.gray);
        this.carrierRelaySwitch.setColor(Color.gray);
        this.hooksRelaySwitch.setColor(Color.gray);
        this.safetyBeltPresenceSwitch.setColor(Color.gray);
        this.noDefaultStatusSwitch.setColor(Color.gray);
        this.clampHomingLabel.setText("NOT DONE");
        this.clampHomingLabel.setForeground(Tools.greenColor);
        FILTERPRESENCESWITCH.setColor(Color.gray);
        this.clampControllerSwitch.setColor(Color.gray);
        this.clampStateLabel.setText("UNKNOWN");
        this.clampPositionLabel.setText("0.0");
        this.forceStatusLabel.setText("UNKNOWN");
        this.carrierPositionLabel.setText("0.0");
        this.carrierStatusLabel.setText("UNKNOWN");
        this.carrierControllerSwitch.setColor(Color.gray);
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    private void loadFilterActionPerformed(ActionEvent evt) {
        this.subs.loLoadFilterIntoBenchOrStorageBox();
    }

    private void unloadFilterActionPerformed(ActionEvent evt) {
        this.subs.loUnloadFilterFromBenchOrStorageBox();
    }

    private void moveFilterStoHActionPerformed(ActionEvent evt) {
        this.subs.loMoveFilterStoH();
    }

    private void moveFilterHtoSActionPerformed(ActionEvent evt) {
        this.subs.loMoveFilterHtoS();
    }

    private void moveEmptyToHandCloseActionPerformed(ActionEvent evt) {
        this.subs.loMoveEmptyToHandClose();
    }

    private void openClampAndMoveEmptyToStoSActionPerformed(ActionEvent evt) {
        this.subs.loOpenClampAndMoveEmptyToS();
    }

    @Override
    public String toString() {
        return "Loader General View Panel";
    }

    public static void main(String[] args) {
        LoaderGeneralViewPanel d = new LoaderGeneralViewPanel();
        JFrame frame = new JFrame("LoaderGeneralViewPanel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            Map configForCarrier = this.configInfo.getCurrentValuesFor("loader/carrier");
            int handoffPosition = Tools.toInt(configForCarrier, "handoffPosition");
            int storagePosition = Tools.toInt(configForCarrier, "storagePosition");
            LoaderGeneralViewPanel.this.carrierPositionProgressBar.setMinimum(-handoffPosition);
            LoaderGeneralViewPanel.this.carrierPositionProgressBar.setMaximum(-storagePosition);
            LoaderGeneralViewPanel.this.carrierPositionProgressBar.setValue(0);
        }
    }

    private class UpdateClamp
    implements Runnable {
        private final StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        @Override
        public void run() {
            if (this.s.isHomingDone()) {
                LoaderGeneralViewPanel.this.clampHomingLabel.setText("DONE");
            } else {
                LoaderGeneralViewPanel.this.clampHomingLabel.setText("--");
            }
            Color clampStateColor = this.s.getClampState().getColor();
            LoaderGeneralViewPanel.this.clampStateLabel.setText(this.s.getClampState().getText());
            LoaderGeneralViewPanel.this.clampStateLabel.setForeground(clampStateColor);
            LoaderGeneralViewPanel.this.forceStatusLabel.setText(this.s.getForceStatus().toString());
            LoaderGeneralViewPanel.this.clampControllerSwitch.setColor(this.s.isControllerInError() ? Color.RED : Tools.greenColor);
        }
    }

    private class UpdateCarrier
    implements Runnable {
        private final StatusDataPublishedByLoaderCarrier s;

        public UpdateCarrier(StatusDataPublishedByLoaderCarrier s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isAtStorage()) {
                LoaderGeneralViewPanel.this.carrierStatusLabel.setText("STORAGE");
            } else if (this.s.isAtEngaged()) {
                LoaderGeneralViewPanel.this.carrierStatusLabel.setText("ENGAGED");
            } else if (this.s.isAtHandoff()) {
                LoaderGeneralViewPanel.this.carrierStatusLabel.setText("HANDOFF");
            } else {
                LoaderGeneralViewPanel.this.carrierStatusLabel.setText("IN_TRAVEL");
            }
            LoaderGeneralViewPanel.this.carrierControllerSwitch.setColor(this.s.isControllerInError() ? Color.RED : Tools.greenColor);
        }
    }

    private class UpdateFromSensorList
    implements Runnable {
        private final Map<String, Serializable> sensorMap;

        public UpdateFromSensorList(Map<String, Serializable> sensorMap) {
            this.sensorMap = sensorMap;
        }

        @Override
        public void run() {
            for (DigitalSwitch digitalSwitch : LoaderGeneralViewPanel.this.redondantSwitches) {
                digitalSwitch.updateColorRedondantSensor(this.sensorMap);
            }
            for (DigitalSwitch digitalSwitch : LoaderGeneralViewPanel.this.complementarySwitches) {
                digitalSwitch.updateColorComplementary(this.sensorMap);
            }
            for (JComponent jComponent : LoaderGeneralViewPanel.this.diamondSwitchesGreenGray) {
                ((DiamondSwitch)jComponent).updateColorGreenGray(this.sensorMap);
            }
            LoaderGeneralViewPanel.this.noDefaultStatusSwitch.updateColorDefaultRedGreen(this.sensorMap);
        }
    }

    public class UpdateCarrierController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        private UpdateCarrierController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isBooted() && this.s.getState() != null) {
                LoaderGeneralViewPanel.this.carrierPositionLabel.setText(Integer.toString(this.s.getPosition()));
                LoaderGeneralViewPanel.this.carrierSpeedLabel.setText(Integer.toString(this.s.getVelocity()));
                LoaderGeneralViewPanel.this.carrierPositionProgressBar.setValue(-this.s.getPosition());
                LoaderGeneralViewPanel.this.carrierPositionProgressBar.setForeground(Color.PINK);
            }
        }
    }

    public class UpdateClampController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        private UpdateClampController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isBooted() && this.s.getState() != null) {
                LoaderGeneralViewPanel.this.clampPositionLabel.setText(Integer.toString(this.s.getPosition()));
            }
        }
    }
}

