
package org.lsst.ccs.subsystems.fcs.loader.ui;

import javax.swing.tree.DefaultMutableTreeNode;
import static org.lsst.ccs.subsystems.fcs.FCSCst.LOADER_TCPPROXY_NAME;
import org.lsst.ccs.subsystems.fcs.ui.commons.BottomPanel;

/**
 * This is the bottom Panel for the loader standalone subsystem.
 * It extends BottomPanel, so at the left there is a tree of Panels.
 * @author virieux
 */
public class LoaderBottomPanel extends BottomPanel {
    private static final long serialVersionUID = -5960023260043468064L;

    /**
     * A constructor with a LoaderGatherPanel and a title.
     * The title is displayed on the border of the Panel.
     * @param gatherPanel
     * @param title
     */
    public LoaderBottomPanel(LoaderGatherPanel gatherPanel, String title) {
        super(gatherPanel, title);
    }

    /**
     * Creates the nodes of the TreePanel.
     * This tree is displayed on the left part of this Panel.
     * @param top
     */
    @Override
    public void createNodes(DefaultMutableTreeNode top) {

        if (gatherPanel == null) {
            gatherPanel = new LoaderGatherPanel(LOADER_TCPPROXY_NAME);
        }

        /** CANopen devices panels*/
        DefaultMutableTreeNode devicesNode = new DefaultMutableTreeNode("CANopen devices");
        devicesNode.add(new DefaultMutableTreeNode(gatherPanel.getCanOpenHardwareListPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((LoaderGatherPanel) gatherPanel).getHooksControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((LoaderGatherPanel) gatherPanel).getCarrierControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((LoaderGatherPanel) gatherPanel).getPlutoGatewayPanel()));
        top.add(devicesNode);

        /** Loader General view Panel*/
        top.add(new DefaultMutableTreeNode(((LoaderGatherPanel) gatherPanel).getLoaderGeneralViewPanel()));

        /** Clamp Panel*/
        top.add(new DefaultMutableTreeNode(((LoaderGatherPanel) gatherPanel).getLoaderClampPanel()));

        /** Carrier Panel*/
        top.add(new DefaultMutableTreeNode(((LoaderGatherPanel) gatherPanel).getLoaderCarrierPanel()));

        /**
         * PLC debug Panel *
         */
        top.add(new DefaultMutableTreeNode(((LoaderGatherPanel) gatherPanel).getPLCLoaderPanel()));

    }

}
