/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.ui.FcsCameraProtectionPanel;
import org.lsst.ccs.subsystems.fcs.ui.InterfaceFcsGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class FcsGeneralViewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger FCSLOG = Logger.getLogger(FcsGeneralViewPanel.class.getName());
    private static final String NONE = "NONE";
    private InterfaceFcsGUI subs;
    private final String title = "FCS OVERVIEW";
    private JPanel autochangerPanel;
    private JPanel carouselPanel;
    private JPanel loaderPanel;
    private JPanel loaderControlPanel;
    private JPanel controlPanel;
    private JPanel subCommandsPanel;
    private JPanel rotatePanel;
    private final JLabel filterONLINELabel = new JLabel("NONE");
    private final JLabel filterOnTrucksLabel = new JLabel("NONE");
    private final JLabel onlineClampsStateLabel = new JLabel("UNKNOWN");
    private final JLabel latchesStateLabel = new JLabel("UNKNOWN");
    private final JLabel trucksPositionLabel = new JLabel("UNKNOWN");
    private final JLabel trucksPositionNameLabel = new JLabel("UNKNOWN");
    private final JLabel actualPositionLabel = new JLabel();
    private final JLabel actualSpeedLabel = new JLabel();
    private final JLabel actualCurrentLabel = new JLabel();
    private final JLabel standbyLabel = new JLabel();
    private final DigitalSwitch standbySwitch = new DigitalSwitch();
    private final JLabel socketAtStandbyLabel = new JLabel();
    private final JLabel ioModuleStatusLabel = new JLabel();
    private final JLabel filterAtStandbyLabel = new JLabel();
    private final JLabel caClampsStateLabel = new JLabel();
    private final JLabel deltaPositionLabel = new JLabel();
    private final JLabel loaderClampHomingLabel = new JLabel();
    private final JLabel filterOnLoaderLabel = new JLabel();
    private final JLabel loaderClampStateLabel = new JLabel();
    private final JLabel loaderClampPositionLabel = new JLabel();
    private final JLabel loaderCarrierPositionLabel = new JLabel();
    private final JLabel loaderCarrierPositionNameLabel = new JLabel();
    private final FcsCameraProtectionPanel cameraStatusPanel = new FcsCameraProtectionPanel();
    private final JButton setFilterButton = new JButton("SetFilter");
    private final JButton loadFilterButton = new JButton("Load filter into camera");
    private final JButton unloadFilterButton = new JButton("Unload filter from camera");
    private final JButton connectLoaderButton = new JButton("Connect loader");
    private final JButton disconnectLoaderButton = new JButton("Disconnect loader");
    private final JTextField filterField = new JTextField(2);
    private final JLabel filterLabel = new JLabel("Filter ID to set:");
    private final JButton setFilterAtHandoffForLoaderButton = new JButton("SetFilterAtHandoffForLoader");
    private final JButton storeFilterOnCarouselButton = new JButton("StoreFilterOnCarousel");
    private final JButton grabFilterAtStandbyButton = new JButton("GrabFilterAtStandby");
    private final JButton disengageFilterFromCarouselButton = new JButton("DisengageFilterFromCarousel");
    private final JButton moveAndClampFilterOnlineButton = new JButton("MoveAndClampFilterOnline");
    private final JButton rotateSocketToStandbyButton = new JButton("RotateSocketToStandby");
    private final String[] socketList = new String[]{"        ", "Socket 1", "Socket 2", "Socket 3", "Socket 4", "Socket 5"};
    private final JComboBox<String> socketMenu = new JComboBox<String>(this.socketList);
    private final JLabel socketLabel = new JLabel("Choose destination socket: ");
    private int socketID;
    private int filterID;

    public FcsGeneralViewPanel() {
        this.initComponents();
    }

    public void setSubs(InterfaceFcsGUI subs) {
        this.subs = subs;
    }

    void updateFromStatusData(KeyValueData data) {
        if (data.getValue() instanceof StatusDataPublishedByAutochangerThreeClamps) {
            this.updateClamps((StatusDataPublishedByAutochangerThreeClamps)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutochangerTwoLatches) {
            this.updateLatches((StatusDataPublishedByAutochangerTwoLatches)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutoChangerTrucks) {
            this.updateTrucks((StatusDataPublishedByAutoChangerTrucks)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByCarousel) {
            this.updateCarousel((StatusDataPublishedByCarousel)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByLoaderClamp) {
            this.updateLoaderClamp((StatusDataPublishedByLoaderClamp)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByLoaderCarrier) {
            this.updateLoaderCarrier((StatusDataPublishedByLoaderCarrier)data.getValue());
        } else if (data.getValue() instanceof KeyValueDataList && "canbus1/loaderPlutoGateway".equals(data.getKey())) {
            this.cameraStatusPanel.updateLoaderFromSensorList((KeyValueDataList)data.getValue());
            this.updateFromSensorList((KeyValueDataList)data.getValue());
        } else if (data.getValue() instanceof KeyValueDataList && "canbus0/acSensorsGateway".equals(data.getKey())) {
            this.cameraStatusPanel.updateAutochangerFromSensorList((KeyValueDataList)data.getValue());
        } else if (data.getValue() instanceof KeyValueDataList && "canbus0/hyttc580/plc".equals(data.getKey())) {
            this.cameraStatusPanel.updateCarouselFromSensorList((KeyValueDataList)data.getValue());
        }
    }

    void updateCarousel(StatusDataPublishedByCarousel s) {
        FCSLOG.finer(() -> this.getName() + " updating from carousel data:");
        SwingUtilities.invokeLater(new UpdateCarousel(s));
    }

    void updateController(StatusDataPublishedByEPOSController s) {
        FCSLOG.finer(() -> this.getName() + " updating from carousel controller data:");
        SwingUtilities.invokeLater(new UpdateController(s));
    }

    void updateCarrierController(StatusDataPublishedByEPOSController s) {
        FCSLOG.finer(() -> this.getName() + " updating from loader carrier controller data:");
        SwingUtilities.invokeLater(new UpdateCarrierController(s));
    }

    void updateClampController(StatusDataPublishedByEPOSController s) {
        FCSLOG.finer(this.getName() + " updating from loader clamp controller data:");
        SwingUtilities.invokeLater(new UpdateClampController(s));
    }

    void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        SwingUtilities.invokeLater(new UpdateTrucks(s));
    }

    void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        SwingUtilities.invokeLater(new UpdateLatches(s));
    }

    void updateClamps(StatusDataPublishedByAutochangerThreeClamps s) {
        SwingUtilities.invokeLater(new UpdateOnlineClamps(s));
    }

    void updateLoaderClamp(StatusDataPublishedByLoaderClamp s) {
        SwingUtilities.invokeLater(new UpdateLoaderClamp(s));
    }

    void updateLoaderCarrier(StatusDataPublishedByLoaderCarrier s) {
        SwingUtilities.invokeLater(new UpdateLoaderCarrier(s));
    }

    void updateFromSensorList(KeyValueDataList kvdl) {
        SwingUtilities.invokeLater(new UpdateFromSensorList(kvdl));
    }

    private void initComponents() {
        this.setFilterButton.addActionListener(evt -> this.setFilterButtonActionPerformed(evt));
        this.setFilterAtHandoffForLoaderButton.addActionListener(evt -> this.setFilterAtHandoffForLoaderButtonActionPerformed(evt));
        this.loadFilterButton.addActionListener(evt -> this.loadFilterButtonActionPerformed(evt));
        this.unloadFilterButton.addActionListener(evt -> this.unloadFilterButtonActionPerformed(evt));
        this.connectLoaderButton.addActionListener(evt -> this.connectLoaderButtonActionPerformed(evt));
        this.disconnectLoaderButton.addActionListener(evt -> this.disconnectLoaderButtonActionPerformed(evt));
        this.storeFilterOnCarouselButton.addActionListener(evt -> this.storeFilterOnCarouselActionPerformed(evt));
        this.rotateSocketToStandbyButton.addActionListener(evt -> this.rotateSocketToStandbyActionPerformed(evt));
        this.grabFilterAtStandbyButton.addActionListener(evt -> this.grabFilterAtStandbyActionPerformed(evt));
        this.disengageFilterFromCarouselButton.addActionListener(evt -> this.disengageFilterFromCarouselActionPerformed(evt));
        this.moveAndClampFilterOnlineButton.addActionListener(evt -> this.moveAndClampFilterOnlineActionPerformed(evt));
        this.autochangerPanel = new JPanel();
        this.autochangerPanel.setBorder(BorderFactory.createTitledBorder("autochanger"));
        this.autochangerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 21;
        this.autochangerPanel.add((Component)new JLabel("Filter ONLINE: "), gbc1);
        ++gbc1.gridy;
        this.autochangerPanel.add((Component)new JLabel("Filter on trucks: "), gbc1);
        ++gbc1.gridy;
        this.autochangerPanel.add((Component)new JLabel("ONLINE clamps state: "), gbc1);
        ++gbc1.gridy;
        this.autochangerPanel.add((Component)new JLabel("Latches state: "), gbc1);
        ++gbc1.gridy;
        this.autochangerPanel.add((Component)new JLabel("Trucks Position: "), gbc1);
        ++gbc1.gridx;
        gbc1.gridy = 0;
        gbc1.anchor = 22;
        this.autochangerPanel.add((Component)this.filterONLINELabel, gbc1);
        ++gbc1.gridy;
        this.autochangerPanel.add((Component)this.filterOnTrucksLabel, gbc1);
        ++gbc1.gridy;
        this.autochangerPanel.add((Component)this.onlineClampsStateLabel, gbc1);
        ++gbc1.gridy;
        this.autochangerPanel.add((Component)this.latchesStateLabel, gbc1);
        ++gbc1.gridy;
        this.autochangerPanel.add((Component)this.trucksPositionNameLabel, gbc1);
        ++gbc1.gridx;
        this.autochangerPanel.add((Component)this.trucksPositionLabel, gbc1);
        this.carouselPanel = new JPanel();
        this.carouselPanel.setBorder(BorderFactory.createLineBorder(Color.yellow));
        this.carouselPanel.setBorder(BorderFactory.createTitledBorder("carousel"));
        this.carouselPanel.setLayout(new GridBagLayout());
        gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 21;
        this.carouselPanel.add((Component)new JLabel("Position: "), gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)new JLabel("Delta Position: "), gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)new JLabel("Speed: "), gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)new JLabel("Current: "), gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)this.standbyLabel, gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)new JLabel("Socket at STANDBY: "), gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)new JLabel("Filter at STANDBY: "), gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)new JLabel("IO Status: "), gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)new JLabel("Clamps Status: "), gbc1);
        ++gbc1.gridx;
        gbc1.gridy = 0;
        gbc1.anchor = 22;
        this.carouselPanel.add((Component)this.actualPositionLabel, gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)this.deltaPositionLabel, gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)this.actualSpeedLabel, gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)this.actualCurrentLabel, gbc1);
        ++gbc1.gridy;
        this.standbySwitch.setColor(Color.gray);
        this.carouselPanel.add((Component)this.standbySwitch, gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)this.socketAtStandbyLabel, gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)this.filterAtStandbyLabel, gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)this.ioModuleStatusLabel, gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)this.caClampsStateLabel, gbc1);
        this.loaderPanel = new JPanel();
        this.loaderPanel.setBorder(BorderFactory.createTitledBorder("loader"));
        this.loaderPanel.setLayout(new GridBagLayout());
        gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 21;
        this.loaderPanel.add((Component)new JLabel("Clamp Homing: "), gbc1);
        ++gbc1.gridy;
        this.loaderPanel.add((Component)new JLabel("Filter on loader: "), gbc1);
        ++gbc1.gridy;
        this.loaderPanel.add((Component)new JLabel("Clamp state: "), gbc1);
        ++gbc1.gridy;
        this.loaderPanel.add((Component)new JLabel("Clamp position: "), gbc1);
        ++gbc1.gridy;
        this.loaderPanel.add((Component)new JLabel("Carrier position: "), gbc1);
        ++gbc1.gridx;
        gbc1.gridy = 0;
        gbc1.anchor = 22;
        this.loaderPanel.add((Component)this.loaderClampHomingLabel, gbc1);
        ++gbc1.gridy;
        this.loaderPanel.add((Component)this.filterOnLoaderLabel, gbc1);
        ++gbc1.gridy;
        this.loaderPanel.add((Component)this.loaderClampStateLabel, gbc1);
        ++gbc1.gridy;
        this.loaderPanel.add((Component)this.loaderClampPositionLabel, gbc1);
        ++gbc1.gridy;
        this.loaderPanel.add((Component)this.loaderCarrierPositionNameLabel, gbc1);
        ++gbc1.gridx;
        this.loaderPanel.add((Component)this.loaderCarrierPositionLabel, gbc1);
        this.loaderControlPanel = new JPanel();
        this.loaderControlPanel.setBorder(BorderFactory.createTitledBorder("loader commands"));
        this.loaderControlPanel.setLayout(new GridBagLayout());
        gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        this.loaderControlPanel.add((Component)this.connectLoaderButton, gbc1);
        ++gbc1.gridy;
        this.loaderControlPanel.add((Component)this.disconnectLoaderButton, gbc1);
        gbc1.gridy = 0;
        ++gbc1.gridx;
        this.loaderControlPanel.add((Component)this.loadFilterButton, gbc1);
        ++gbc1.gridy;
        this.loaderControlPanel.add((Component)this.unloadFilterButton, gbc1);
        this.controlPanel = new JPanel();
        this.controlPanel.setBorder(BorderFactory.createTitledBorder("setFilter command"));
        this.controlPanel.setLayout(new GridBagLayout());
        gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        this.controlPanel.add((Component)this.filterLabel, gbc1);
        ++gbc1.gridx;
        gbc1.anchor = 17;
        gbc1.fill = 0;
        this.controlPanel.add((Component)this.filterField, gbc1);
        ++gbc1.gridy;
        gbc1.gridx = 0;
        gbc1.gridwidth = 2;
        gbc1.fill = 2;
        this.controlPanel.add((Component)this.setFilterButton, gbc1);
        ++gbc1.gridy;
        this.controlPanel.add((Component)this.setFilterAtHandoffForLoaderButton, gbc1);
        this.rotatePanel = new JPanel();
        this.rotatePanel.setBorder(BorderFactory.createLineBorder(Color.BLUE));
        this.rotatePanel.setLayout(new GridBagLayout());
        gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 17;
        gbc1.fill = 2;
        gbc1.gridwidth = 2;
        this.rotatePanel.add((Component)this.rotateSocketToStandbyButton, gbc1);
        ++gbc1.gridy;
        gbc1.gridwidth = 1;
        gbc1.fill = 0;
        this.rotatePanel.add((Component)this.socketLabel, gbc1);
        ++gbc1.gridx;
        this.rotatePanel.add(this.socketMenu, gbc1);
        this.subCommandsPanel = new JPanel();
        this.subCommandsPanel.setBorder(BorderFactory.createTitledBorder("setFilter subcommands"));
        this.subCommandsPanel.setLayout(new GridBagLayout());
        gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 17;
        gbc1.fill = 2;
        this.subCommandsPanel.add((Component)this.storeFilterOnCarouselButton, gbc1);
        ++gbc1.gridy;
        this.subCommandsPanel.add((Component)this.rotatePanel, gbc1);
        ++gbc1.gridy;
        this.subCommandsPanel.add((Component)this.grabFilterAtStandbyButton, gbc1);
        ++gbc1.gridy;
        this.subCommandsPanel.add((Component)this.disengageFilterFromCarouselButton, gbc1);
        ++gbc1.gridy;
        this.subCommandsPanel.add((Component)this.moveAndClampFilterOnlineButton, gbc1);
        this.setBorder(BorderFactory.createTitledBorder("FCS OVERVIEW"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 512;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        this.add((Component)this.cameraStatusPanel, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        this.add((Component)this.carouselPanel, gbc);
        gbc.gridheight = 1;
        ++gbc.gridx;
        this.add((Component)this.autochangerPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.loaderPanel, gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
        this.add((Component)this.controlPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.loaderControlPanel, gbc);
        --gbc.gridx;
        ++gbc.gridy;
        this.add((Component)this.subCommandsPanel, gbc);
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        this.actualPositionLabel.setText("0.0");
        this.actualSpeedLabel.setText("0.0");
        this.actualCurrentLabel.setText("0.0");
        this.standbyLabel.setText("NOT AT STANDBY position");
        this.standbySwitch.setColor(Color.gray);
        this.socketAtStandbyLabel.setText(NONE);
        this.filterAtStandbyLabel.setText("NO FILTER");
        this.caClampsStateLabel.setText("UNKNOWN STATE");
        this.ioModuleStatusLabel.setText("UNKNOWN STATE");
        this.trucksPositionLabel.setText("0.0");
        this.trucksPositionNameLabel.setText("UNKNOWN STATE");
        this.onlineClampsStateLabel.setText("UNKNOWN STATE");
        this.latchesStateLabel.setText("UNKNOWN STATE");
        this.loaderClampHomingLabel.setText("UNKNOWN");
        this.filterOnLoaderLabel.setText("UNKNOWN");
        this.loaderClampStateLabel.setText("UNKNOWN");
        this.loaderClampPositionLabel.setText("0.0");
        this.loaderCarrierPositionNameLabel.setText("UNKNOWN");
        this.loaderCarrierPositionLabel.setText("0.0");
    }

    public void resetPanel() {
        this.setDefaultValues();
        this.cameraStatusPanel.resetPanel();
    }

    @Override
    public String toString() {
        return "FCS OVERVIEW";
    }

    private void setFilterButtonActionPerformed(ActionEvent evt) {
        this.filterID = Integer.parseInt(this.filterField.getText());
        this.subs.setFilter(this.filterID);
    }

    private void setFilterAtHandoffForLoaderButtonActionPerformed(ActionEvent evt) {
        this.filterID = Integer.parseInt(this.filterField.getText());
        this.subs.setFilterAtHandoffForLoader(this.filterID);
    }

    private void loadFilterButtonActionPerformed(ActionEvent evt) {
        this.subs.loadFilter();
    }

    private void unloadFilterButtonActionPerformed(ActionEvent evt) {
        this.subs.unloadFilter();
    }

    private void connectLoaderButtonActionPerformed(ActionEvent evt) {
        this.subs.connectLoader();
    }

    private void disconnectLoaderButtonActionPerformed(ActionEvent evt) {
        this.subs.disconnectLoader();
    }

    private void storeFilterOnCarouselActionPerformed(ActionEvent evt) {
        this.subs.storeFilterOnCarousel();
    }

    private void rotateSocketToStandbyActionPerformed(ActionEvent evt) {
        int selectedSocketNb = this.socketMenu.getSelectedIndex();
        if (selectedSocketNb != 0) {
            this.socketID = selectedSocketNb;
            this.subs.rotateSocketToStandby(this.socketID);
            this.socketMenu.setSelectedIndex(0);
        }
    }

    private void grabFilterAtStandbyActionPerformed(ActionEvent evt) {
        this.subs.grabFilterAtStandby();
    }

    private void disengageFilterFromCarouselActionPerformed(ActionEvent evt) {
        this.subs.disengageFilterFromCarousel();
    }

    private void moveAndClampFilterOnlineActionPerformed(ActionEvent evt) {
        this.subs.moveAndClampFilterOnline();
    }

    public static void main(String[] args) {
        FcsGeneralViewPanel d = new FcsGeneralViewPanel();
        JFrame frame = new JFrame("FCS General View Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public class UpdateCarousel
    implements Runnable {
        private final StatusDataPublishedByCarousel s;

        public UpdateCarousel(StatusDataPublishedByCarousel s) {
            this.s = s;
        }

        @Override
        public void run() {
            FcsGeneralViewPanel.this.actualPositionLabel.setText(Integer.toString(this.s.getPosition()));
            if (this.s.isAtStandby() && !this.s.isMoving()) {
                FcsGeneralViewPanel.this.standbyLabel.setText("AT STANDBY position");
                FcsGeneralViewPanel.this.standbySwitch.setColor(Tools.greenColor);
                FcsGeneralViewPanel.this.socketAtStandbyLabel.setText(this.s.getSocketAtStandbyName());
                FcsGeneralViewPanel.this.socketAtStandbyLabel.setFont(Tools.BIG_FONT);
                if (this.s.isEmptyAtStandby()) {
                    FcsGeneralViewPanel.this.filterAtStandbyLabel.setText(this.s.getFilterAtStandbyName());
                } else {
                    FcsGeneralViewPanel.this.filterAtStandbyLabel.setText(this.s.getFilterAtStandbyName() + "/" + this.s.getFilterAtStandbyId());
                }
                FcsGeneralViewPanel.this.filterAtStandbyLabel.setFont(Tools.BIG_FONT);
                FcsGeneralViewPanel.this.caClampsStateLabel.setText(this.s.getClampsStateAtStandby().toString());
                FcsGeneralViewPanel.this.caClampsStateLabel.setForeground(this.s.getClampsStateAtStandby().getColor());
                FcsGeneralViewPanel.this.ioModuleStatusLabel.setText(this.s.getIOStatusAtStandby().toString());
                FcsGeneralViewPanel.this.ioModuleStatusLabel.setForeground(this.s.getIOStatusAtStandby().getColor());
                FcsGeneralViewPanel.this.deltaPositionLabel.setText(Integer.toString(this.s.getDeltaPositionAtStandby()));
            } else {
                FcsGeneralViewPanel.this.standbyLabel.setText("NOT AT STANDBY position");
                FcsGeneralViewPanel.this.standbySwitch.setColor(Color.orange);
                if (this.s.isMoving()) {
                    FcsGeneralViewPanel.this.socketAtStandbyLabel.setText("--");
                } else {
                    FcsGeneralViewPanel.this.socketAtStandbyLabel.setText(this.s.getSocketAtStandbyName());
                }
                FcsGeneralViewPanel.this.filterAtStandbyLabel.setText("--");
                FcsGeneralViewPanel.this.caClampsStateLabel.setText("--");
                FcsGeneralViewPanel.this.ioModuleStatusLabel.setText("--");
            }
        }
    }

    public class UpdateController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        public UpdateController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isBooted() && this.s.getState() != null) {
                FcsGeneralViewPanel.this.actualSpeedLabel.setText(Double.toString(this.s.getVelocity()));
                FcsGeneralViewPanel.this.actualCurrentLabel.setText(Double.toString(this.s.getCurrent()));
            }
        }
    }

    public class UpdateCarrierController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        public UpdateCarrierController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isBooted() && this.s.getState() != null) {
                FcsGeneralViewPanel.this.loaderCarrierPositionLabel.setText(Integer.toString(this.s.getPosition()));
                FcsGeneralViewPanel.this.loaderCarrierPositionNameLabel.setForeground(Tools.greenColor);
            }
        }
    }

    public class UpdateClampController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        public UpdateClampController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isBooted() && this.s.getState() != null) {
                FcsGeneralViewPanel.this.loaderClampPositionLabel.setText(Integer.toString(this.s.getPosition()));
            }
        }
    }

    private class UpdateTrucks
    implements Runnable {
        private StatusDataPublishedByAutoChangerTrucks s;

        public UpdateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
            this.s = status;
        }

        @Override
        public void run() {
            FcsGeneralViewPanel.this.trucksPositionLabel.setText(String.valueOf(this.s.getDriverPosition()));
            FcsGeneralViewPanel.this.trucksPositionNameLabel.setForeground(Tools.greenColor);
            if (this.s.isAtHandoff()) {
                FcsGeneralViewPanel.this.trucksPositionNameLabel.setText("HANDOFF");
            } else if (this.s.isAtOnline()) {
                FcsGeneralViewPanel.this.trucksPositionNameLabel.setText("ONLINE");
                FcsGeneralViewPanel.this.filterONLINELabel.setText(FcsGeneralViewPanel.this.filterOnTrucksLabel.getText());
            } else if (this.s.isAtStandby()) {
                FcsGeneralViewPanel.this.trucksPositionNameLabel.setText("STANDBY");
            } else {
                FcsGeneralViewPanel.this.trucksPositionNameLabel.setText("IN_TRAVEL");
                FcsGeneralViewPanel.this.trucksPositionNameLabel.setForeground(Color.YELLOW);
                FcsGeneralViewPanel.this.filterONLINELabel.setText(FcsGeneralViewPanel.NONE);
            }
        }
    }

    class UpdateLatches
    implements Runnable {
        private StatusDataPublishedByAutochangerTwoLatches s;

        public UpdateLatches(StatusDataPublishedByAutochangerTwoLatches status) {
            this.s = status;
        }

        @Override
        public void run() {
            FcsGeneralViewPanel.this.latchesStateLabel.setText(this.s.getLockStatus().toString());
            FcsGeneralViewPanel.this.latchesStateLabel.setForeground(this.s.getLockStatus().getColor());
            FcsGeneralViewPanel.this.filterOnTrucksLabel.setFont(Tools.BIG_FONT);
            if (this.s.getFilterPresenceStatus().equals(FcsEnumerations.FilterPresenceStatus.ENGAGED)) {
                FcsGeneralViewPanel.this.filterOnTrucksLabel.setText(this.s.getFilterName() + "/" + this.s.getFilterId());
            } else {
                FcsGeneralViewPanel.this.filterOnTrucksLabel.setText("No Filter");
            }
        }
    }

    class UpdateOnlineClamps
    implements Runnable {
        private StatusDataPublishedByAutochangerThreeClamps s;

        public UpdateOnlineClamps(StatusDataPublishedByAutochangerThreeClamps status) {
            this.s = status;
        }

        @Override
        public void run() {
            FcsGeneralViewPanel.this.onlineClampsStateLabel.setText(this.s.getLockStatus().toString());
            FcsGeneralViewPanel.this.onlineClampsStateLabel.setForeground(this.s.getLockStatus().getColor());
        }
    }

    public class UpdateLoaderClamp
    implements Runnable {
        private final StatusDataPublishedByLoaderClamp s;

        public UpdateLoaderClamp(StatusDataPublishedByLoaderClamp s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isHomingDone()) {
                FcsGeneralViewPanel.this.loaderClampHomingLabel.setText("DONE");
                FcsGeneralViewPanel.this.loaderClampHomingLabel.setForeground(Tools.greenColor);
            } else {
                FcsGeneralViewPanel.this.loaderClampHomingLabel.setText("--");
                FcsGeneralViewPanel.this.loaderClampHomingLabel.setForeground(Tools.greenColor);
            }
            FcsGeneralViewPanel.this.loaderClampStateLabel.setText(this.s.getClampState().name());
            FcsGeneralViewPanel.this.loaderClampStateLabel.setForeground(this.s.getClampState().getColor());
        }
    }

    public class UpdateLoaderCarrier
    implements Runnable {
        private final StatusDataPublishedByLoaderCarrier s;

        public UpdateLoaderCarrier(StatusDataPublishedByLoaderCarrier s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isAtStorage()) {
                FcsGeneralViewPanel.this.loaderCarrierPositionNameLabel.setText("STORAGE");
            } else if (this.s.isAtHandoff()) {
                FcsGeneralViewPanel.this.loaderCarrierPositionNameLabel.setText("HANDOFF");
            } else if (this.s.isAtEngaged()) {
                FcsGeneralViewPanel.this.loaderCarrierPositionNameLabel.setText("ENGAGED");
            } else {
                FcsGeneralViewPanel.this.loaderCarrierPositionNameLabel.setText("IN_TRAVEL");
                FcsGeneralViewPanel.this.loaderCarrierPositionNameLabel.setForeground(Color.YELLOW);
            }
        }
    }

    public class UpdateFromSensorList
    implements Runnable {
        private final KeyValueDataList kvdl;

        public UpdateFromSensorList(KeyValueDataList kvdl) {
            this.kvdl = kvdl;
        }

        @Override
        public void run() {
            Map<String, Serializable> sMap = this.kvdl.getListOfKeyValueData().stream().collect(Collectors.toMap(KeyValueData::getKey, KeyValueData::getValue));
            if (1 == (Integer)sMap.get("loaderFilterPresenceSensor0") && 1 == (Integer)sMap.get("loaderFilterPresenceSensor1")) {
                FcsGeneralViewPanel.this.filterOnLoaderLabel.setText("YES");
                FcsGeneralViewPanel.this.filterOnLoaderLabel.setForeground(Tools.greenColor);
            } else {
                FcsGeneralViewPanel.this.filterOnLoaderLabel.setText(FcsGeneralViewPanel.NONE);
                FcsGeneralViewPanel.this.filterOnLoaderLabel.setForeground(Color.gray);
            }
        }
    }
}

