
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.ui.commons.DiamondSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.HorizontalLine;
import org.lsst.ccs.subsystems.fcs.ui.commons.RectangleSwitch;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AF0_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AF1_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AF3_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AP1_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AP2_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AP3_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.CF0_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.CF1_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.CFC_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.CS_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.SP_V_LINE_HEIGHT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.SP_V_LINE_STARTINGY;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.createPanelWithComponent;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.create_subPanelWith2Switch;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.NO_LOCKOUT;

import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalLine;

/**
 *
 * @author virieux
 */
public class PLCAutochangerPanel extends JPanel {

    private final String engineering = "<BR>Autochanger<BR>Engineering<BR>Mode";
    private final String LOCKOUT_SHUNT = "<BR>Autochanger<BR>Lock Out Shunt Standalone Bay";
    private final String enable_clamps = "enable_clamps";
    private final String enable_latches = "enable_latches";
    private final String enable_rails = "enable_linear_rails";

    /**
     * Sensors Name *
     */
    /* Complementary sensors */
    public static final String AF0 = "OUT_AF0";
    public static final String AF0B = "OUT_AF0_C";
    public static final String AF1 = "OUT_AF1";
    public static final String AF1B = "OUT_AF1_C";
    public static final String AF3 = "OUT_AF3";
    public static final String AF3B = "OUT_AF3_C";
    public static final String AP1 = "OUT_AP1";
    public static final String AP1B = "OUT_AP1_C";
    public static final String AP2 = "OUT_AP2";
    public static final String AP2B = "OUT_AP2_C";
    public static final String AP3 = "OUT_AP3";
    public static final String AP3B = "OUT_AP3_C";
    // presenceLoader
    public static final String ALM = "presenceLoader";
    public static final String ALMB = "presenceLoader_C";
    // sensors sent by carousel
    public static final String CFC = "carouselHoldingFilterSensor0";
    public static final String CFCB = "carouselHoldingFilterSensor1";
    public static final String CF0 = "carousel_CF0";
    public static final String CF0B = "carousel_CF0_C";
    public static final String CF1 = "carousel_CF1";
    public static final String CF1B = "carousel_CF1_C";
    public static final String CS = "carouselStoppedAtStandby";
    public static final String CSB = "carouselStoppedAtStandbyC";
    // sensors sent by loader
    public static final String LPS = "loaderConnectedSensor";
    public static final String LPSB = "loaderConnectedSensorC";
    public static final String LRH = "loaderHoldingFilterSensor0";
    public static final String LRHB = "loaderHoldingFilterSensor1";
    // other sensors
    public static final String ENG = "engineeringKey";
    public static final String ENGB = "engineeringKey_C";
    public static final String LOCK = "lockOut";
    public static final String LOCKB = "lockOut_C";
    public static final String RELAYCLAMPS = "lpmOnlineClampsStatus";
    public static final String RELAYLATCHES = "lpmLatchesStatus";
    public static final String RELAYRAIL1 = "lpmLinearRail1Status";
    public static final String RELAYRAIL2 = "lpmLinearRail2Status";

    /* One signal sensors */
    public static final String AIN = "OUT_AIN";
    public static final String AOL = "OUT_AOL";
    public static final String LOCKSHUNT = "lockOutShunt";

    private final DigitalSwitch af0Switch = new DigitalSwitch(AF0, AF0B);
    private final DigitalSwitch af1SwitchL1 = new DigitalSwitch(AF1, AF1B);
    private final DigitalSwitch af1SwitchL2 = new DigitalSwitch(AF1, AF1B);
    private final DigitalSwitch af3SwitchC = new DigitalSwitch(AF3, AF3B);
    private final DigitalSwitch af3SwitchR1 = new DigitalSwitch(AF3, AF3B);
    private final DigitalSwitch af3SwitchR4 = new DigitalSwitch(AF3, AF3B);
    private final DigitalSwitch ap1SwitchC = new DigitalSwitch(AP1, AP1B);
    private final DigitalSwitch ap1SwitchR = new DigitalSwitch(AP1, AP1B);
    private final DigitalSwitch ap2Switch = new DigitalSwitch(AP2, AP2B);
    private final DigitalSwitch ap3SwitchC = new DigitalSwitch(AP3, AP3B);
    private final DigitalSwitch ap3SwitchR = new DigitalSwitch(AP3, AP3B);
    private final DigitalSwitch notAp3Switch = new DigitalSwitch(AP3B, AP3);
    private final DigitalSwitch notAlmSwitch = new DigitalSwitch(ALMB, ALM);

    private final DigitalSwitch cfcSwitch = new DigitalSwitch(CFC, CFCB);
    private final DigitalSwitch cf0Switch1 = new DigitalSwitch(CF0, CF0B);
    private final DigitalSwitch cf0Switch2 = new DigitalSwitch(CF0, CF0B);
    private final DigitalSwitch cf1Switch = new DigitalSwitch(CF1, CF1B);
    private final DigitalSwitch csSwitch1 = new DigitalSwitch(CS, CSB);
    private final DigitalSwitch csSwitch2 = new DigitalSwitch(CS, CSB);
    private final DigitalSwitch csSwitch3 = new DigitalSwitch(CS, CSB);
    private final DigitalSwitch csSwitch4 = new DigitalSwitch(CS, CSB);
    private final DigitalSwitch lpsSwitch = new DigitalSwitch(LPS, LPSB);
    private final DigitalSwitch lrhSwitch = new DigitalSwitch(LRH, LRHB);
    private final DigitalSwitch NoLockoutSwitchC = new DigitalSwitch(LOCKB, LOCK);
    private final DigitalSwitch NoLockoutSwitchL = new DigitalSwitch(LOCKB, LOCK);
    private final DigitalSwitch NoLockoutSwitchR = new DigitalSwitch(LOCKB, LOCK);

    private final DigitalSwitch engineeringSwitchC = new DigitalSwitch(ENG, ENGB);
    private final DigitalSwitch engineeringSwitchL = new DigitalSwitch(ENG, ENGB);
    private final DigitalSwitch engineeringSwitchR = new DigitalSwitch(ENG, ENGB);

    /* DiamondSwitch */
    private final DiamondSwitch ainSwitchC = new DiamondSwitch(AIN);
    private final DiamondSwitch ainSwitchL = new DiamondSwitch(AIN);
    private final DiamondSwitch ainSwitchR = new DiamondSwitch(AIN);
    private final DiamondSwitch aolSwitch = new DiamondSwitch(AOL);
    private final DiamondSwitch lockoutShuntSwitchC = new DiamondSwitch(LOCKSHUNT);
    private final DiamondSwitch lockoutShuntSwitchL = new DiamondSwitch(LOCKSHUNT);
    private final DiamondSwitch lockoutShuntSwitchR = new DiamondSwitch(LOCKSHUNT);

    /* Relays*/
    private final RectangleSwitch clampsRelayRectangle = new RectangleSwitch(RELAYCLAMPS);
    private final RectangleSwitch latchesRelayRectangle = new RectangleSwitch(RELAYLATCHES);
    private final RectangleSwitch railsRelayRectangle = new RectangleSwitch();

    private final DiamondSwitch[] diamondSwitchesGreenGray = new DiamondSwitch[]{
        ainSwitchC, ainSwitchL, ainSwitchR, aolSwitch,
        lockoutShuntSwitchC, lockoutShuntSwitchL, lockoutShuntSwitchR,};

    private final DigitalSwitch[] digitalList = new DigitalSwitch[]{
        af0Switch, af3SwitchC, af3SwitchR1, af3SwitchR4,
        ap1SwitchC, ap1SwitchR, ap2Switch, ap3SwitchC, ap3SwitchR, notAp3Switch, notAlmSwitch,
        cfcSwitch, cf0Switch1, cf0Switch2, cf1Switch, csSwitch1, csSwitch2, csSwitch3, csSwitch4,
        lpsSwitch,lrhSwitch,
        NoLockoutSwitchC, NoLockoutSwitchL, NoLockoutSwitchR,
        engineeringSwitchC, engineeringSwitchL, engineeringSwitchR,
    };


    /**
     * To update this panel from a map of sensors : name, value.
     */
    private class UpdateFromSensorList implements Runnable {

        private final Map<String, Serializable> sensorMap;

        public UpdateFromSensorList(Map<String, Serializable> sensorMap) {
            this.sensorMap = sensorMap;
        }

        @Override
        public void run() {
            for (DiamondSwitch ds : diamondSwitchesGreenGray) {
                ds.updateColorGreenGray(sensorMap);
            }

            for (DigitalSwitch ds: digitalList) {
                ds.updateColorComplementary(sensorMap);
            }

            //AF1 signal doesn't give the right signal  : it gives AF1 and !AF3
            //so we have to display AF1 or AF3 to recover the right AF1
            boolean inError = (int) sensorMap.get(AF1) == (int) sensorMap.get(AF1B);
            boolean rightAF1 = ((int) sensorMap.get(AF1) == 1 && (int) sensorMap.get(AF1B) == 0)
                    || ((int) sensorMap.get(AF3) == 1 && (int) sensorMap.get(AF3B) == 0);

            af1SwitchL1.updateColor(inError, rightAF1);
            af1SwitchL2.updateColor(inError, rightAF1);

            clampsRelayRectangle.updateColorGreenGray(sensorMap);
            latchesRelayRectangle.updateColorGreenGray(sensorMap);

            /* Switch enable_linear_rails is green if both signals RELAYRAIL1 and RELAYRAIL2 are equal to 1*/
            if (sensorMap.containsKey(RELAYRAIL1) && sensorMap.containsKey(RELAYRAIL2)) {
                if ((int) sensorMap.get(RELAYRAIL1) != (int) sensorMap.get(RELAYRAIL2)) {
                    railsRelayRectangle.setColor(Color.RED);
                } else if ((int) sensorMap.get(RELAYRAIL1) == 1) {
                    railsRelayRectangle.setColor(Color.GREEN);
                } else {
                    railsRelayRectangle.setColor(Color.GRAY);
                }
            }
        }
    }

    public PLCAutochangerPanel() {
        initComponents();
    }

    public void updateFromSensorList(Map<String, Serializable> sMap) {
        SwingUtilities.invokeLater(new UpdateFromSensorList(sMap));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     */
    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        /**
         *******************************************************************************
         * Whole panel
         * *******************************************************************************
         */
        setBorder(javax.swing.BorderFactory.createTitledBorder("AUTOCHANGER PROTECTION SYSTEM"));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.WEST;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridy++;
        add(create_explanationsPanel(), gbc);
        gbc.gridy++;
        add(create_clampsPanel(), gbc);
        gbc.gridy++;
        add(create_latchesPanel(), gbc);
        gbc.gridy++;
        add(create_linearRailsPanel(), gbc);

        /* set default values for whole panel*/
        setDefaultValues();
    }

    private JPanel create_explanationsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.WEST;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(new JLabel("<HTML><b>Signals displayed on this panel are read on acSensorsGateway (Autochanger PLC)</b></HTML>"), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(AP1_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(AP2_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(AP3_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel("<HTML><b>AOL</b>: ONLINE clamps all opened &nbsp</HTML>"), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(AF0_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(AF1_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(AF3_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(""), gbcp);

        gbcp.gridy = 1;
        gbcp.gridx = 2;
        panel.add(new JLabel(CS_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(CFC_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(CF0_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(CF1_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel("<HTML><b>LRH</b>: Loader holding filter at HANDOFF position</HTML>"), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel("<HTML><b>LPS</b>: Loader carrier at STORAGE position</HTML>"), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel("<HTML><b>ALM</b>: Loader docked</HTML>"), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel("<HTML><b>AIN</b>: Inclinaison sensor less than 10°</HTML>"), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(""), gbcp);
        return panel;
    }

    private JPanel create_clampsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Online Clamps"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent("AP3", ap3SwitchC, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AF3", af3SwitchC, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AIN", ainSwitchC, false, true), gbcp);
        gbcp.gridx++;

        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);
        gbcp.gridx++;
        panel.add(new HorizontalLine(), gbcp);
        gbcp.gridx++;
        panel.add(create_subPanelWith2Switch(NO_LOCKOUT, NoLockoutSwitchC, LOCKOUT_SHUNT, lockoutShuntSwitchC), gbcp);
        gbcp.gridx++;
        panel.add(new HorizontalLine(), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(enable_clamps, clampsRelayRectangle, false, false), gbcp);


        gbcp.gridheight = 1;
        gbcp.gridwidth = 3;
        gbcp.gridx = 0;
        gbcp.gridy++;
        panel.add(createPanelWithComponent(engineering, engineeringSwitchC, false, true, 100), gbcp);

        return panel;
    }

    private JPanel create_latchesPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Latches"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent("AP2", ap2Switch, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AF1", af1SwitchL1, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("LRH", lrhSwitch, false, true), gbcp);

        gbcp.gridx++;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AIN", ainSwitchL, true, true), gbcp);

        gbcp.gridx++;
        gbcp.gridheight = 3;
        panel.add(new VerticalLine(175, 50), gbcp);

        gbcp.gridx++;
        gbcp.gridheight = 2;
        panel.add(new HorizontalLine(), gbcp);
        gbcp.gridx++;
        panel.add(create_subPanelWith2Switch(NO_LOCKOUT, NoLockoutSwitchL, LOCKOUT_SHUNT, lockoutShuntSwitchL), gbcp);

        gbcp.gridx++;
        panel.add(new HorizontalLine(), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(enable_latches, latchesRelayRectangle, false, false), gbcp);

        /* line2*/
        gbcp.gridheight = 1;
        gbcp.gridx = 0;
        gbcp.gridy++;
        panel.add(createPanelWithComponent("CFC", cfcSwitch, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AP1", ap1SwitchC, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AF1", af1SwitchL2, false, true), gbcp);

        /* line3*/
        gbcp.gridx = 0;
        gbcp.gridy++;
        gbcp.gridwidth = 5;
        panel.add(createPanelWithComponent(engineering, engineeringSwitchL, false, true, 230), gbcp);

        return panel;
    }

    private JPanel create_linearRailsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Linear Rails"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;

        /* line1*/
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent("CS", csSwitch1, false, true), gbcp);
        gbcp.gridx++;
        gbcp.gridwidth = 2;
        panel.add(createPanelWithComponent("CF0", cf0Switch1, false, true, 100), gbcp);
        gbcp.gridwidth = 1;

        gbcp.gridx++;
        gbcp.gridx++;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, 10), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AF3", af3SwitchR1, true, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("NOT AP3", notAp3Switch, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AOL", aolSwitch, false, true), gbcp);
        gbcp.gridx++;
        gbcp.gridheight = 3;
        panel.add(new VerticalLine(130, 45), gbcp);
        gbcp.gridx++;
        gbcp.gridheight = 2;
        panel.add(new HorizontalLine(), gbcp);
        gbcp.gridx++;
        panel.add(create_subPanelWith2Switch("LPS", lpsSwitch, "<BR>NOT ALM</BR>", notAlmSwitch), gbcp);
        gbcp.gridx++;
        panel.add(new HorizontalLine(), gbcp);
        gbcp.gridx++;
        gbcp.gridheight = 4;
        panel.add(new VerticalLine(180, 50), gbcp);
        gbcp.gridx++;
        gbcp.gridheight = 2;

        panel.add(createPanelWithComponent("AIN", ainSwitchR, true, true), gbcp);
        gbcp.gridx++;
        gbcp.gridheight = 5;
        panel.add(new VerticalLine(260, 50), gbcp);
        gbcp.gridx++;
        gbcp.gridheight = 2;
        panel.add(new HorizontalLine(), gbcp);
        gbcp.gridx++;
        panel.add(create_subPanelWith2Switch(NO_LOCKOUT, NoLockoutSwitchR, LOCKOUT_SHUNT, lockoutShuntSwitchR), gbcp);
        gbcp.gridx++;
        panel.add(new HorizontalLine(), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(enable_rails, railsRelayRectangle, false, false), gbcp);

        /* line2*/
        gbcp.gridheight = 1;
        gbcp.gridx = 0;
        gbcp.gridy++;
        panel.add(createPanelWithComponent("CS", csSwitch2, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("CF1", cf1Switch, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AP1", ap1SwitchR, false, true), gbcp);

        /* line3*/
        gbcp.gridx = 0;
        gbcp.gridy++;
        panel.add(createPanelWithComponent("CS", csSwitch3, false, true), gbcp);
        gbcp.gridx++;
        gbcp.gridwidth = 6;
        gbcp.anchor = GridBagConstraints.WEST;
        panel.add(createPanelWithComponent("AF0", af0Switch, false, true, 375), gbcp);
        gbcp.gridwidth = 1;
        gbcp.anchor = GridBagConstraints.CENTER;

        /* line4*/
        gbcp.gridx = 0;
        gbcp.gridy++;
        panel.add(createPanelWithComponent("CS", csSwitch4, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("CF0", cf0Switch2, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AP3", ap3SwitchR, false, true), gbcp);
        gbcp.gridx++;
        gbcp.gridwidth = 8;
        panel.add(createPanelWithComponent("AF3", af3SwitchR4, false, true, 500), gbcp);
        gbcp.gridwidth = 1;

        /* line5*/
        gbcp.gridx = 0;
        gbcp.gridy++;
        gbcp.gridwidth = 13;
        panel.add(createPanelWithComponent(engineering, engineeringSwitchR, false, true, 750), gbcp);

        return panel;
    }

    /**
     * Initialization to be done when Autochanger subsystem is not yet booted or is shutdown.
     */
    private void setDefaultValues() {
        for (DigitalSwitch c : digitalList) {
            c.setColor(Color.gray);
        }
        for (DiamondSwitch c : diamondSwitchesGreenGray) {
            c.setColor(Color.gray);
        }
        clampsRelayRectangle.setColor(Color.gray);
        latchesRelayRectangle.setColor(Color.gray);
        railsRelayRectangle.setColor(Color.gray);
    }

    /**
     * Reset components to default values.
     */
    public void resetPanel() {
        setDefaultValues();
    }
    @Override
    public String toString() {
        return "PLC Autochanger Panel";
    }
}
