
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_TRUCKS_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_TRUCKXMINUS_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_TRUCKXPLUSCONTROLLER_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_TRUCKXPLUS_NAME;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTruck;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.BIG_FONT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_big;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;
import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_TRUCKXMINUSCONTROLLER_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;

/**
 *
 * @author virieux
 */
public class AutochangerTwoTrucksPanel extends JPanel {
    private static final long serialVersionUID = 1545510390830387685L;
    private final String trucksName;
    private InterfaceAutochangerGUI subs;

    /* Homing panel */
    private final JPanel homingPanel = new JPanel();
    private final JLabel homLabel = new JLabel("Homing of the controllers:");
    private final JLabel homingLabel = new JLabel();

    /* State panel*/
    private final JPanel deltaPositionPanel = new JPanel();
    private final JLabel driverPositionLabel = new JLabel();
    private final JLabel followerPositionLabel = new JLabel();
    private final JLabel deltaPositionLabel = new JLabel();
    private final JLabel driverSideLabel = new JLabel();

    /* Trucks panels*/
    private final AutochangerTruckPanel truckXminusPanel;
    private final AutochangerTruckPanel truckXplusPanel;

    //general informations panel
    private final JLabel standbyPositionjLabel = new JLabel();
    private final JLabel standbyPositionEmptyjLabel = new JLabel();
    private final JLabel approachStandbyPositionjLabel = new JLabel();
    private final JLabel handoffPositionjLabel = new JLabel();
    private final JLabel onlinePositionjLabel = new JLabel();
    private final JLabel slowMotionPositionjLabel = new JLabel();
    private final JLabel approachOnlinePositionjLabel = new JLabel();
    private final JLabel speedMaxjLabel = new JLabel();
    private final JLabel currentMaxjLabel = new JLabel();

    //control panel 1
    private final JButton updateStateWithSensorsButton = new JButton("updateStateWithSensors");
    private final JButton updatePositionButton = new JButton("updatePosition");
    private final JButton alignFollowerButton = new JButton("alignFollower");
    private final JButton alignFollowerForLoaderButton = new JButton("alignFollowerForLoader");
    private final JButton moveToApproachStandbyButton = new JButton("moveToApproachStandby");
    private final JButton goToHandoffButton = new JButton("goToHandOff");
    private final JButton goToHandoffForLoaderButton = new JButton("goToHandOffForLoader");
    private final JButton goToOnlineButton = new JButton("goToOnline");
    private final JButton quickStopButton = new JButton("QuickStop");
    private final JButton abortButton = new JButton("Abort");

    //velocity control panel
    private final JPanel velocityControlPanel = new JPanel();
    private final JLabel profileVelocityLabel = new JLabel("0");
    private final JLabel profileAccelerationLabel = new JLabel("0");
    private final JLabel profileDecelerationLabel = new JLabel("0");
    private final JButton slowTrucksProfileButton = new JButton("slowTrucksProfile");
    private final JButton fastTrucksProfileButton = new JButton("fastTrucksProfile");

    // End of variables declaration

    /**
     * A Runnable to  initialize this Panel from configuration data.
     */
    private class GuiInitialization implements Runnable {

        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {

            //Retrieve the configuration data for my name.
            Map<String, String> configForName = configInfo.getCurrentValuesFor(trucksName);
            FCSLOG.fine(trucksName + " configForName="+configForName);

            //trucks
            subs.setTimeoutForTrucksMotion(Long.parseLong(configForName.get("timeoutForTrucksMotion")));
            subs.setTimeoutForAlignFollower(Long.parseLong(configForName.get("timeoutForAlignFollower")));
            //General Informations Panel
            int standbyPosition = Integer.parseInt(configForName.get("standbyPosition"));
            int standbyPositionEmpty = Integer.parseInt(configForName.get("standbyPositionEmpty"));
            int approachStandbyPosition = Integer.parseInt(configForName.get("approachStandbyPosition"));
            int handoffPosition = Integer.parseInt(configForName.get("handoffPosition"));
            int onlinePosition = Integer.parseInt(configForName.get("onlinePosition"));
            int slowMotionPosition = Integer.parseInt(configForName.get("slowMotionPosition"));
            int approachOnlinePosition = Integer.parseInt(configForName.get("approachOnlinePosition"));
            standbyPositionjLabel.setText(Integer.toString(standbyPosition));
            standbyPositionEmptyjLabel.setText(Integer.toString(standbyPositionEmpty));
            approachStandbyPositionjLabel.setText(Integer.toString(approachStandbyPosition));
            handoffPositionjLabel.setText(Integer.toString(handoffPosition));
            onlinePositionjLabel.setText(Integer.toString(onlinePosition));
            slowMotionPositionjLabel.setText(Integer.toString(slowMotionPosition));
            approachOnlinePositionjLabel.setText(Integer.toString(approachOnlinePosition));
            speedMaxjLabel.setText(configForName.get("maxSpeed"));
            currentMaxjLabel.setText(configForName.get("maxCurrent"));
            driverSideLabel.setText(configForName.get("driverSide"));

            //position progress bar for truckXminusPanel and truckXplusPanel
            truckXminusPanel.initializeGui(standbyPosition, onlinePosition);
            truckXplusPanel.initializeGui(standbyPosition, onlinePosition);
        }
    }


    /**
     * A Runnable to update this Panel from data published on the STATUS bus.
     */
    class UpdateTrucks implements Runnable {

        private final StatusDataPublishedByAutoChangerTrucks s;

        public UpdateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
            this.s = status;
        }

        @Override
        public void run() {
            //TODO put the values of the limit switch sensors.
            if (s.isHomingDone()) {
                homingLabel.setText("DONE");
                homingLabel.setForeground(Color.green);
            } else {
                homingLabel.setText("NOT DONE");
                homingLabel.setForeground(Color.red);
            }
            driverPositionLabel.setText(Integer.toString(s.getDriverPosition()));
            followerPositionLabel.setText(Integer.toString(s.getFollowerPosition()));
            deltaPositionLabel.setText(Integer.toString(s.getDriverPosition() - s.getFollowerPosition()));
        }
    }

    /**
     * Creates new form AutochangerTrucksPanel
     * @param trucksName
     */
    public AutochangerTwoTrucksPanel(String trucksName) {
        this.trucksName = trucksName;
        truckXminusPanel = new AutochangerTruckPanel(AC_TRUCKXMINUS_NAME);
        truckXplusPanel = new AutochangerTruckPanel(AC_TRUCKXPLUS_NAME);
        initComponents();
    }

    public void setSubsystem(InterfaceAutochangerGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
        SwingUtilities.invokeLater(new UpdateTrucks(status));
    }

    public void updateTruck(String truckName, StatusDataPublishedByAutochangerTruck s) {
        if (null == truckName) {
            FCSLOG.error(truckName + ": Unknown name for AC truck. Can't update GUI.");
        } else
            switch (truckName) {
                case AC_TRUCKXMINUS_NAME:
                    truckXminusPanel.updateTruck(s);
                    break;
                case AC_TRUCKXPLUS_NAME:
                    truckXplusPanel.updateTruck(s);
                    break;
                default:
                    FCSLOG.error(truckName + ": Unknown name for AC truck. Can't update GUI.");
                    break;
            }
    }

    public void updateController(String controllerName, StatusDataPublishedByEPOSController s) {
        if (AC_TRUCKXMINUSCONTROLLER_NAME.equals(controllerName)) {
            truckXminusPanel.updateController(s);
            update(s);

        } else if (AC_TRUCKXPLUSCONTROLLER_NAME.equals(controllerName)) {
            truckXplusPanel.updateController(s);
        }
    }

    public void update(StatusDataPublishedByEPOSController s) {
        SwingUtilities.invokeLater(new UpdateController(s));
    }

    /**
     * A Runnable to update controller panel with data published by a
     * controller.
     */
    public class UpdateController implements Runnable {

        private final StatusDataPublishedByEPOSController s;

        private UpdateController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (s.isBooted() && s.getState() != null) {
                profileVelocityLabel.setText(Long.toString(s.getProfileVelocity()));
                profileAccelerationLabel.setText(Long.toString(s.getProfileAcceleration()));
                profileDecelerationLabel.setText(Long.toString(s.getProfileDeceleration()));
            }
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */

    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        setDefaultValues();
        /*
         **  Add graphical components to the main panel
         */

        updateStateWithSensorsButton.addActionListener(this::updateStateWithSensorsActionPerformed);

        updatePositionButton.addActionListener(this::updatePositionActionPerformed);

        alignFollowerButton.addActionListener(this::alignFollowerActionPerformed);

        alignFollowerForLoaderButton.addActionListener(this::alignFollowerForLoaderActionPerformed);

        goToHandoffButton.addActionListener(this::goToHandoffActionPerformed);
        goToHandoffForLoaderButton.addActionListener(this::goToHandoffForLoaderActionPerformed);

        goToOnlineButton.addActionListener(this::goToOnlineActionPerformed);

        moveToApproachStandbyButton.addActionListener(this::moveToApproachStandbyActionPerformed);

        quickStopButton.addActionListener(this::quickStopActionPerformed);

        abortButton.addActionListener(this::abortActionPerformed);

        slowTrucksProfileButton.addActionListener(this::slowTrucksProfilePerformed);
        fastTrucksProfileButton.addActionListener(this::fastTrucksProfilePerformed);

        /**********************/
        /* Homing Panel       */
        /**********************/
        homingPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.ORANGE),"Homing"));
        homingPanel.setLayout(new GridBagLayout());
        homingLabel.setFont(BIG_FONT);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = insets_big;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        homingLabel.setFont(BIG_FONT);
        homingPanel.add(homLabel, gbc1);
        gbc1.gridx++;
        homingPanel.add(homingLabel, gbc1);

        /**********************/
        /* Delta Position Panel */
        /**********************/
        deltaPositionPanel.setBorder(BorderFactory.createTitledBorder(
        BorderFactory.createLineBorder(Color.ORANGE),"Delta Position"));
        deltaPositionPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        //first column
        gbc2.anchor = GridBagConstraints.LINE_START;
        deltaPositionPanel.setFont(BIG_FONT);
        deltaPositionPanel.add(new JLabel("driver side = "), gbc2);
        gbc2.gridy ++;
        deltaPositionPanel.add(new JLabel("driver position = "), gbc2);
        gbc2.gridy ++;
        deltaPositionPanel.add(new JLabel("follower position = "), gbc2);
        gbc2.gridy ++;
        deltaPositionPanel.add(new JLabel("driver position - follower position = "), gbc2);
        //second column
        gbc2.gridy = 0;
        gbc2.gridx++;
        gbc2.anchor = GridBagConstraints.LINE_END;
        driverSideLabel.setFont(BIG_FONT);
        deltaPositionPanel.add(driverSideLabel, gbc2);
        gbc2.gridy++;
        deltaPositionPanel.add(driverPositionLabel, gbc2);
        gbc2.gridy ++;
        deltaPositionPanel.add(followerPositionLabel, gbc2);
        gbc2.gridy ++;
        deltaPositionPanel.add(deltaPositionLabel, gbc2);

        /**
         ******************************************************************************
         ** General Informations Panel
         * *****************************************************************************
         */
        JPanel generalInfoPanel = new JPanel();
        generalInfoPanel.setBorder(BorderFactory.createTitledBorder(
                BorderFactory.createLineBorder(Color.BLUE,3),"Configurable parameters"));
        generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = insets_std;
        //first column
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = GridBagConstraints.LINE_START;
        generalInfoPanel.add(new JLabel("Online Position (in micron): "), gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(new JLabel("Approach Online Position (in micron): "), gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(new JLabel("Slow Motion Position (in micron): "), gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(new JLabel("Hand-Off Position (in micron): "), gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(new JLabel("Standby Position (in micron): "), gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(new JLabel("Standby Position Empty: "), gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(new JLabel("Approach Standby Position: "), gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(new JLabel("Speed max (in rpm/mn): "), gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(new JLabel("Current max (in mA): "), gbc3);
        //second column
        gbc3.gridx++;
        gbc3.gridy = 0;
        gbc3.anchor = GridBagConstraints.LINE_END;
        generalInfoPanel.add(onlinePositionjLabel, gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(approachOnlinePositionjLabel, gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(slowMotionPositionjLabel, gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(handoffPositionjLabel, gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(standbyPositionjLabel, gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(standbyPositionEmptyjLabel, gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(approachStandbyPositionjLabel, gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(speedMaxjLabel, gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(currentMaxjLabel, gbc3);

        /**
         ******************************************************************************
         ** End of General Informations Panel
         * *****************************************************************************
         */


        /**
         ******************************************************************************
         ** Control Panel
         * *****************************************************************************
         */
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc4 = new java.awt.GridBagConstraints();
        gbc4.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc4.fill = GridBagConstraints.HORIZONTAL;
        gbc4.insets = insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        controlPanel.add(updateStateWithSensorsButton, gbc4);
        gbc4.gridy++;
        controlPanel.add(updatePositionButton, gbc4);
        gbc4.gridy++;
        controlPanel.add(alignFollowerButton, gbc4);
        gbc4.gridy++;
        controlPanel.add(alignFollowerForLoaderButton, gbc4);
        gbc4.gridy++;
        controlPanel.add(goToOnlineButton, gbc4);
        gbc4.gridy++;
        controlPanel.add(goToHandoffButton, gbc4);
        gbc4.gridy++;
        controlPanel.add(goToHandoffForLoaderButton, gbc4);
        gbc4.gridy++;
        controlPanel.add(moveToApproachStandbyButton, gbc4);
        gbc4.gridy++;
        controlPanel.add(abortButton, gbc4);

        /**
         ******************************************************************************
         ** End of Control Panel
         * *****************************************************************************
         */

         /**
         ******************************************************************************
         ** Velocity Control Panel
         * *****************************************************************************
         */
        velocityControlPanel.setLayout(new GridBagLayout());
        velocityControlPanel.setBorder(BorderFactory.createTitledBorder(
            BorderFactory.createLineBorder(Color.blue),"Trucks Velocity Profile"));
        gbc4 = new GridBagConstraints();
        gbc4.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc4.fill = GridBagConstraints.HORIZONTAL;
        gbc4.insets = insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        velocityControlPanel.add(new JLabel("ProfileVelocity: "), gbc4);
        gbc4.gridy++;
        velocityControlPanel.add(new JLabel("ProfileAcceleration: "), gbc4);
        gbc4.gridy++;
        velocityControlPanel.add(new JLabel("ProfileDeceleration: "), gbc4);
        gbc4.gridx++;
        gbc4.gridy = 0;
        gbc4.anchor = GridBagConstraints.LINE_END;
        velocityControlPanel.add(profileVelocityLabel, gbc4);
        gbc4.gridy++;
        velocityControlPanel.add(profileAccelerationLabel, gbc4);
        gbc4.gridy++;
        velocityControlPanel.add(profileDecelerationLabel, gbc4);

        //buttons
        gbc4.gridx = 0;
        gbc4.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc4.gridy++;
        velocityControlPanel.add(slowTrucksProfileButton, gbc4);
        gbc4.gridy++;
        velocityControlPanel.add(fastTrucksProfileButton, gbc4);


        /**
         ******************************************************************************
         ** end of Velocity Control Panel
         * *****************************************************************************
         */

        /**
         ******************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        setBorder(javax.swing.BorderFactory.createTitledBorder(
                BorderFactory.createLineBorder(Color.PINK),"AUTOCHANGER TRUCKS"));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.BASELINE_LEADING;
        add(homingPanel,gbc);
        gbc.gridx++;
        add(deltaPositionPanel,gbc);
        gbc.anchor = GridBagConstraints.NORTH;
        gbc.gridx = 0;
        gbc.gridy++;
        add(truckXminusPanel,gbc);
        gbc.gridy++;
        add(generalInfoPanel, gbc);
        gbc.gridx++;
        gbc.gridy--;
        gbc.gridwidth = 2;
        add(truckXplusPanel,gbc);
        gbc.anchor = GridBagConstraints.BASELINE_LEADING;
        gbc.gridy++;
        gbc.gridwidth = 1;
        add(controlPanel, gbc);
        gbc.gridx++;
        add(velocityControlPanel, gbc);

    }

    private void updateStateWithSensorsActionPerformed(java.awt.event.ActionEvent evt) {
        subs.updateStateWithSensors();
    }

    private void updatePositionActionPerformed(java.awt.event.ActionEvent evt) {
        subs.acUpdateTrucksPosition();
    }

    private void alignFollowerActionPerformed(java.awt.event.ActionEvent evt) {
        subs.acAlignFollower();
    }

    private void alignFollowerForLoaderActionPerformed(java.awt.event.ActionEvent evt) {
        subs.acAlignFollowerForLoader();
    }

    private void goToHandoffActionPerformed(java.awt.event.ActionEvent evt) {
        subs.acGoToHandOff();
    }

    private void goToHandoffForLoaderActionPerformed(java.awt.event.ActionEvent evt) {
        subs.acGoToHandOffForLoader();
    }

    private void goToOnlineActionPerformed(java.awt.event.ActionEvent evt) {
        subs.acGoToOnline();
    }

    private void moveToApproachStandbyActionPerformed(java.awt.event.ActionEvent evt) {
        subs.acMoveToApproachStandby();
    }

    private void quickStopActionPerformed(java.awt.event.ActionEvent evt) {
        subs.stopMyDestinationSubsystem();
    }

    private void abortActionPerformed(java.awt.event.ActionEvent evt) {
        subs.abortAction();
    }

    private void slowTrucksProfilePerformed(java.awt.event.ActionEvent evt) {
        subs.acSlowTrucksProfile();
    }

    private void fastTrucksProfilePerformed(java.awt.event.ActionEvent evt) {
        subs.acFastTrucksProfile();
    }

    private void setDefaultValues() {
        standbyPositionjLabel.setText(Integer.toString(0));
        handoffPositionjLabel.setText(Double.toString(0));
        onlinePositionjLabel.setText(Double.toString(0));
        approachOnlinePositionjLabel.setText(Double.toString(0));
        speedMaxjLabel.setText(Integer.toString(0));
        currentMaxjLabel.setText(Integer.toString(0));
        homingLabel.setText("NOT DONE");
        homingLabel.setForeground(Color.red);
        deltaPositionLabel.setText(Integer.toString(0));
        driverPositionLabel.setText(Integer.toString(0));
        followerPositionLabel.setText(Integer.toString(0));
    }

    /**
     * Reset components default values.
     */
    public void resetPanel() {
        setDefaultValues();
        truckXminusPanel.resetPanel();
        truckXplusPanel.resetPanel();
    }

    /**
     * This method is used by the AutochangerTreePanel to display the name of
     * the node in the JTreePanel.
     * @return
     */
    @Override
    public String toString() {
        return "Trucks";
    }

    /**
     * For tests.
     * @param argv
     */
    public static void main(String[] argv) {

        AutochangerTwoTrucksPanel d = new AutochangerTwoTrucksPanel(AC_TRUCKS_NAME);
        JFrame frame = new JFrame("Autochanger Trucks Main Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
}
