
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_CLAMPSNAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_CLAMPXMINUSCONTROLLER_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_CLAMPXMINUS_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_CLAMPXPLUSCONTROLLER_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_CLAMPXPLUS_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_CLAMPYMINUSCONTROLLER_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_CLAMPYMINUS_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.BIG_FONT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.UNKNOWN_STATE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.ZERO_VALUE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 *
 * @author virieux
 */
public class AutochangerThreeOnlineClampsPanel extends JPanel {
    private static final long serialVersionUID = -7384546448046444702L;

    private InterfaceAutochangerGUI subs;

    private final JLabel clampsState = new JLabel();
    private final JLabel strainLabel = new JLabel();
    private final JLabel rawStrainLabel = new JLabel();
    private final JLabel xMinusLabel = new JLabel("X-");
    private final JLabel xMinusLabel2 = new JLabel("X-");
    private final JLabel xPlusLabel = new JLabel("X+");
    private final JLabel xPlusLabel2 = new JLabel("X+");
    private final JLabel yLabel = new JLabel("Y-");
    private final JLabel yLabel2 = new JLabel("Y-");
    private final JPanel clampsPanel = new JPanel();
    private final JPanel clampsStatePanel = new JPanel();
    private final JPanel controlPanel = new JPanel();

    private final AutochangerOnlineClampPanel clampXminusPanel
            = new AutochangerOnlineClampPanel("autochanger/onlineClamps/"+AC_CLAMPXMINUS_NAME);
    private final AutochangerOnlineClampPanel clampXplusPanel
            = new AutochangerOnlineClampPanel("autochanger/onlineClamps/"+AC_CLAMPXPLUS_NAME);
    private final AutochangerOnlineClampPanel clampYminusPanel
            = new AutochangerOnlineClampPanel("autochanger/onlineClamps/"+AC_CLAMPYMINUS_NAME);

    private final JButton homingButton = new JButton("Homing (open in CURRENT mode)");
    private final JButton openClampsButton = new JButton("Open Clamps");
    private final JButton closeClampsButton = new JButton("Close Clamps");
    private final JButton lockClampsButton = new JButton("Lock Clamps");
    private final JButton unlockClampsButton = new JButton("Unlock Clamps");
    private final JButton updateStateWithSensorsButton = new JButton("Read sensors and update state");
    private final JButton abortButton = new JButton("Abort");
    // End of variables declaration


    /**
     * A Runnable to update this Panel from data published on the DStatus bus.
     */
    private class UpdateClamps implements Runnable {

        private StatusDataPublishedByAutochangerThreeClamps s;

        public UpdateClamps(StatusDataPublishedByAutochangerThreeClamps status) {
            this.s = status;
        }

        @Override
        public void run() {
            clampsState.setText(s.getLockStatus().getText());
            clampsState.setForeground(s.getLockStatus().getColor());
            strainLabel.setText(String.valueOf(s.getOnlineClampStrain()));
            rawStrainLabel.setText(String.valueOf(s.getOnlineClampRawStrain()));
        }
    }

    /**
     * Creates this panel and initializes components.
     */
    public AutochangerThreeOnlineClampsPanel() {
        initComponents();
    }

    public void setSubsystem(InterfaceAutochangerGUI subs) {
        this.subs = subs;
        clampXminusPanel.setSubsystem(subs);
        clampXplusPanel.setSubsystem(subs);
        clampYminusPanel.setSubsystem(subs);
    }

    /**
     * Initialize GUI from configuration data of the subsystem.
     * @param configInfo
     */
    public void initializeGui(ConfigurationInfo configInfo) {
        clampXminusPanel.initializeGui(configInfo);
        clampXplusPanel.initializeGui(configInfo);
        clampYminusPanel.initializeGui(configInfo);
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateClamps(StatusDataPublishedByAutochangerThreeClamps s) {
        SwingUtilities.invokeLater(new UpdateClamps(s));
    }

    public void updateClampXminus(StatusDataPublishedByAutochangerOnlineClamp s) {
        clampXminusPanel.updateClamp(s);
    }

    public void updateClampXplus(StatusDataPublishedByAutochangerOnlineClamp s) {
        clampXplusPanel.updateClamp(s);
    }

    public void updateClampYminus(StatusDataPublishedByAutochangerOnlineClamp s) {
        clampYminusPanel.updateClamp(s);
    }


    public void updateClamp(String clampName, StatusDataPublishedByAutochangerOnlineClamp s) {
        switch (clampName) {
            case AC_CLAMPXMINUS_NAME:
                clampXminusPanel.updateClamp(s);
                break;
            case AC_CLAMPXPLUS_NAME:
                clampXplusPanel.updateClamp(s);
                break;
            case AC_CLAMPYMINUS_NAME:
                clampYminusPanel.updateClamp(s);
                break;
            default:
                FCSLOG.error(getName() + " Unknown name for online clamp:" + clampName);
        }
    }

    public void updateController(String controllerName, StatusDataPublishedByEPOSController s) {
        switch (controllerName) {
            case AC_CLAMPXMINUSCONTROLLER_NAME:
                clampXminusPanel.updateController(s);
                break;
            case AC_CLAMPXPLUSCONTROLLER_NAME:
                clampXplusPanel.updateController(s);
                break;
            case AC_CLAMPYMINUSCONTROLLER_NAME:
                clampYminusPanel.updateController(s);
                break;
        }
    }

    /**
     * A Runnable to initialize this Panel from Configuration data.
     *
     */
    private class GuiInitialization implements Runnable {

        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            //Retrieve the configuration data for my name.
            Map<String, String> configForClamps = configInfo.getCurrentValuesFor(AC_CLAMPSNAME);

            //Initialization of the timeouts for buttons commands.
            subs.setTimeoutForOnlineClampMotion(Tools.toInt(configForClamps,"timeoutForLockingClamps"));
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     */
    private void initComponents() {
        /**
         ******************************************************************************
         ** Buttons initialization
         * *****************************************************************************
         */
        updateStateWithSensorsButton.addActionListener((ActionEvent evt) -> {
            updateStateWithSensorsButtonActionPerformed(evt);
        });

        closeClampsButton.addActionListener((ActionEvent evt) -> {
            closeClampsButtonActionPerformed(evt);
        });

        unlockClampsButton.addActionListener((ActionEvent evt) -> {
            unlockClampsButtonActionPerformed(evt);
        });

        openClampsButton.addActionListener((ActionEvent evt) -> {
            openClampsButtonActionPerformed(evt);
        });

        homingButton.addActionListener((ActionEvent evt) -> {
            homingButtonActionPerformed(evt);
        });

        lockClampsButton.addActionListener((ActionEvent evt) -> {
            lockClampsButtonActionPerformed(evt);
        });

        abortButton.addActionListener((ActionEvent evt) -> {
            abortButtonActionPerformed(evt);
        });
        /**
         ******************************************************************************
         ** end of Buttons initialization
         * *****************************************************************************
         */

        //X- and X+ and Z label
        Font xFont = new Font("Tahoma", 1, 18);
        xMinusLabel.setFont(xFont); // NOI18N
        xMinusLabel2.setFont(xFont); // NOI18N
        xPlusLabel2.setFont(xFont); // NOI18N
        xPlusLabel.setFont(xFont); // NOI18N
        yLabel.setFont(xFont); // NOI18N
        yLabel2.setFont(xFont); // NOI18N


        /**
         ******************************************************************************
         ** Clamps State Panel
         * *****************************************************************************
         */
        clampsState.setFont(BIG_FONT); // NOI18N
        clampsState.setBorder(BorderFactory.createEtchedBorder(new java.awt.Color(255, 255, 255), new java.awt.Color(255, 255, 255)));
        clampsStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.anchor = GridBagConstraints.SOUTH;
        clampsStatePanel.add(new JLabel("CLAMPS STATE :"), gbc2);
        gbc2.gridx++;
        clampsStatePanel.add(clampsState, gbc2);
        gbc2.gridx++;
        clampsStatePanel.add(new JLabel("<HTML>temperature<br>compensated strain:</br></HTML>"), gbc2);
        gbc2.gridx++;
        strainLabel.setFont(BIG_FONT);
        clampsStatePanel.add(strainLabel, gbc2);
        gbc2.gridx++;
        clampsStatePanel.add(new JLabel("raw strain:"), gbc2);
        gbc2.gridx++;
        clampsStatePanel.add(rawStrainLabel, gbc2);

        /**
         ******************************************************************************
         ** end of Clamps State Panel
         * *****************************************************************************
         */

        /**
         ******************************************************************************
         ** Clamps Panel
         * *****************************************************************************
         */
        clampsPanel.setLayout(new GridBagLayout());
        clampsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.YELLOW), "ONLINE Clamps"));
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = insets_std;

        gbc1.gridx = 0;
        gbc1.gridy = 0;
        clampsPanel.add(clampXminusPanel, gbc1);

        gbc1.gridx++;
        clampsPanel.add(clampXplusPanel, gbc1);

        gbc1.gridx = 0;
        gbc1.gridy++;
        clampsPanel.add(clampYminusPanel, gbc1);

        gbc1.gridx++;
        clampsPanel.add(controlPanel, gbc1);

        /**
         ******************************************************************************
         ** End of Clamps Panel
         * *****************************************************************************
         */


        /**
         ******************************************************************************
         ** Control Panel
         * *****************************************************************************
         */
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc3.fill = GridBagConstraints.HORIZONTAL;
        gbc3.insets = insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        controlPanel.add(updateStateWithSensorsButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(homingButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(closeClampsButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(lockClampsButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(openClampsButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(unlockClampsButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(abortButton, gbc3);
        /**
         ******************************************************************************
         ** End of Control Panel
         * *****************************************************************************
         */

        /**
         ******************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.PINK), "AUTOCHANGER ONLINE CLAMPS"));
        //setForeground(new java.awt.Color(204, 204, 255));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(xMinusLabel, gbc);
        gbc.anchor = GridBagConstraints.EAST;
        gbc.gridx = 3;
        add(xPlusLabel, gbc);

        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.anchor = GridBagConstraints.CENTER;
        add(clampsStatePanel, gbc);
        gbc.gridy++;
        add(clampsPanel, gbc);

        gbc.gridy++;
        add(yLabel, gbc);

        setDefaultValues();
    }

    private void setDefaultValues() {
        clampsState.setText(UNKNOWN_STATE);
        strainLabel.setText(ZERO_VALUE);
        rawStrainLabel.setText(ZERO_VALUE);
    }

    /**
     * Reset Panel components with default values.
     */
    public void resetPanel() {
        setDefaultValues();
        clampXminusPanel.resetPanel();
        clampXplusPanel.resetPanel();
        clampYminusPanel.resetPanel();
    }

    private void updateStateWithSensorsButtonActionPerformed(ActionEvent evt) {
        subs.updateStateWithSensors();
    }

    private void homingButtonActionPerformed(ActionEvent evt) {
        subs.homingOnlineClamps();
    }

    private void closeClampsButtonActionPerformed(ActionEvent evt) {
        subs.closeOnlineClamps();
    }

    private void lockClampsButtonActionPerformed(ActionEvent evt) {
        subs.lockOnlineClamps();
    }

    private void openClampsButtonActionPerformed(ActionEvent evt) {
        subs.openOnlineClamps();
    }

    private void unlockClampsButtonActionPerformed(ActionEvent evt) {
        subs.unlockOnlineClamps();
    }

    private void abortButtonActionPerformed(ActionEvent evt) {
        subs.abortAction();
    }

    @Override
    public String toString() {
        return "ONLINE Clamps";
    }

    public static void main(String[] argv) {

        AutochangerThreeOnlineClampsPanel d = new AutochangerThreeOnlineClampsPanel();
        JFrame frame = new JFrame("Autochanger Clamps Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
