/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;

public interface InterfaceAutochangerGUI
extends InterfaceGeneralGUI {
    public long getTimeoutForTrucksMotion();

    public long getTimeoutForOnlineClampMotion();

    public long getTimeoutForLatchesMotion();

    public long getTimeoutForAlignFollower();

    public void setTimeoutForTrucksMotion(long var1);

    public void setTimeoutForOnlineClampMotion(long var1);

    public void setTimeoutForLatchesMotion(long var1);

    public void setTimeoutForAlignFollower(long var1);

    default public void acUpdateTrucksPosition() {
        FCSCst.FCSLOG.info((Object)"Autochanger updating Trucks position");
        FCSCst.FCSLOG.info((Object)"/timeout=1000");
        this.sendCommand("updatePosition", 1000L, "autochanger/autochangerTrucks");
    }

    default public void acAlignFollower() {
        FCSCst.FCSLOG.info((Object)"Autochanger aligning follower");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getTimeoutForTrucksMotion()));
        this.sendCommand("alignFollower", this.getTimeoutForAlignFollower(), "autochanger");
    }

    default public void acAlignFollowerForLoader() {
        FCSCst.FCSLOG.info((Object)"Autochanger aligning follower for loader");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getTimeoutForTrucksMotion()));
        this.sendCommand("alignFollowerForLoader", this.getTimeoutForAlignFollower(), "autochanger");
    }

    default public void acGoToHandOff() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Handoff Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getTimeoutForTrucksMotion()));
        this.sendCommand("goToHandOff", this.getTimeoutForTrucksMotion(), "autochanger");
    }

    default public void acGoToHandOffForLoader() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Handoff Position for Loader");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getTimeoutForTrucksMotion()));
        this.sendCommand("goToHandOffForLoader", this.getTimeoutForTrucksMotion(), "autochanger");
    }

    default public void acGoToStandby() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Standby Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getTimeoutForTrucksMotion()));
        this.sendCommand("goToStandby", this.getTimeoutForTrucksMotion(), "autochanger");
    }

    default public void acMoveToApproachStandby() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Approach Standby Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getTimeoutForTrucksMotion()));
        this.sendCommand("moveToApproachStandby", this.getTimeoutForTrucksMotion(), "autochanger");
    }

    default public void acGoToOnline() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Online Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getTimeoutForTrucksMotion()));
        this.sendCommand("goToOnline", this.getTimeoutForTrucksMotion(), "autochanger");
    }

    default public void acMoveAndClampFilterOnline() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks moving to Online Position, and clamping");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getTimeoutForTrucksMotion()));
        this.sendCommand("moveAndClampFilterOnline", this.getTimeoutForTrucksMotion(), "autochanger");
    }

    default public void acSlowTrucksProfile() {
        long timeout = 2000L;
        FCSCst.FCSLOG.info((Object)"Setting trucks slow velocity and acceleration profile");
        FCSCst.FCSLOG.info((Object)("/timeout=" + timeout));
        this.sendCommand("slowTrucksProfile", timeout, "autochanger");
    }

    default public void acFastTrucksProfile() {
        long timeout = 2000L;
        FCSCst.FCSLOG.info((Object)"Setting trucks fast velocity and acceleration profile");
        FCSCst.FCSLOG.info((Object)("/timeout=" + timeout));
        this.sendCommand("fastTrucksProfile", timeout, "autochanger");
    }

    default public void acUnclampAndMoveFilterToHandoff() {
        this.sendCommand("unclampAndMoveFilterToHandoff", this.getTimeoutForTrucksMotion(), "autochanger");
    }

    default public void unlockOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger unlocking online clamps");
        this.sendCommand("unlockClamps", this.getTimeoutForOnlineClampMotion(), "autochanger");
    }

    default public void lockOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger locking online clamps");
        this.sendCommand("lockClamps", this.getTimeoutForOnlineClampMotion(), "autochanger");
    }

    default public void closeOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger closing online clamps");
        this.sendCommand("closeClamps", this.getTimeoutForOnlineClampMotion(), "autochanger");
    }

    default public void homingOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger online clamps homing");
        this.sendCommand("homing", this.getTimeoutForOnlineClampMotion(), "autochanger/onlineClamps");
    }

    default public void openOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger opening online clamps");
        this.sendCommand("openClamps", this.getTimeoutForOnlineClampMotion(), "autochanger");
    }

    default public void homingOnlineClamp(String clampName) {
        FCSCst.FCSLOG.info((Object)("Autochanger homing online clamp: " + clampName));
        this.sendCommand("openInCurrentModeAndHoming", this.getTimeoutForOnlineClampMotion(), clampName);
    }

    default public void openOnlineClamp(String clampName) {
        FCSCst.FCSLOG.info((Object)("Autochanger opening clamp: " + clampName));
        this.sendCommand("open", this.getTimeoutForOnlineClampMotion(), clampName);
    }

    default public void closeOnlineClamp(String clampName) {
        FCSCst.FCSLOG.info((Object)("Autochanger closing clamp: " + clampName));
        this.sendCommand("close", this.getTimeoutForOnlineClampMotion(), clampName);
    }

    default public void lockOnlineClamp(String clampName) {
        FCSCst.FCSLOG.info((Object)("Autochanger clamping clamp: " + clampName));
        this.sendCommand("lock", this.getTimeoutForOnlineClampMotion(), clampName);
    }

    default public void unlockOnlineClamp(String clampName) {
        FCSCst.FCSLOG.info((Object)("Autochanger unclamping clamp: " + clampName));
        this.sendCommand("unlock", this.getTimeoutForOnlineClampMotion(), clampName);
    }

    default public void closeLatch(String latchName) {
        FCSCst.FCSLOG.info((Object)("Autochanger opening latch: " + latchName));
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getTimeoutForLatchesMotion()));
        this.sendCommand("close", this.getTimeoutForLatchesMotion(), latchName);
    }

    default public void openLatch(String latchName) {
        FCSCst.FCSLOG.info((Object)("Autochanger closing latch: " + latchName));
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getTimeoutForLatchesMotion()));
        this.sendCommand("open", this.getTimeoutForLatchesMotion(), latchName);
    }

    default public void closeLatches() {
        FCSCst.FCSLOG.info((Object)"Autochanger closing latches.");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getTimeoutForLatchesMotion()));
        this.sendCommand("closeLatches", this.getTimeoutForLatchesMotion(), "autochanger");
    }

    default public void openLatches() {
        FCSCst.FCSLOG.info((Object)"Autochanger opening latches.");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getTimeoutForLatchesMotion()));
        this.sendCommand("openLatches", this.getTimeoutForLatchesMotion(), "autochanger");
    }
}

