/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusAggregator;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusEvent;

public class MutableAgentStatusEvent
extends AgentStatusEvent {
    MutableAgentStatusEvent(AgentStatusAggregator aggregator, StatusMessage message) {
        super(aggregator, null, message, new LinkedHashMap<AgentChannel, List<String>>(), Collections.emptyList(), Collections.emptyList());
    }

    MutableAgentStatusEvent(AgentStatusAggregator aggregator) {
        super(aggregator, new ArrayList<AgentInfo>(1), null, Collections.emptyMap(), new ArrayList<AgentChannel>(), new ArrayList<AgentChannel>());
    }

    public void addChange(AgentChannel channel, String attributeKey) {
        ArrayList<String> changedAttributes;
        if (attributeKey == null) {
            attributeKey = "value";
        }
        if ((changedAttributes = (ArrayList<String>)this.statusChanges.get(channel)) == null) {
            changedAttributes = new ArrayList<String>(1);
            this.statusChanges.put(channel, changedAttributes);
        }
        changedAttributes.add(attributeKey);
    }

    public void addAddedChannel(AgentChannel channel) {
        this.addedChannels.add(channel);
    }

    public void addAddedChannels(Collection<? extends AgentChannel> channels) {
        this.addedChannels.addAll(channels);
    }

    public void addRemovedChannel(AgentChannel channel) {
        this.removedChannels.add(channel);
    }

    public void addRemovedChannels(Collection<? extends AgentChannel> channels) {
        this.removedChannels.removeAll(channels);
    }

    public void validate() {
        if (this.agents.isEmpty()) {
            LinkedHashMap<String, AgentInfo> aa = new LinkedHashMap<String, AgentInfo>();
            for (AgentChannel c : this.addedChannels) {
                aa.putIfAbsent(c.getAgentName(), c.getAgent());
            }
            for (AgentChannel c : this.removedChannels) {
                aa.putIfAbsent(c.getAgentName(), c.getAgent());
            }
            this.agents.addAll(aa.values());
        }
    }
}

