package org.lsst.ccs.subsystems.fcs.ui;

import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import static org.lsst.ccs.subsystems.fcs.carousel.ui.InterfaceCarouselGUI.carouselName;
import static org.lsst.ccs.subsystems.fcs.carousel.ui.InterfaceCarouselGUI.timeoutForRotation;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;

/**
 *
 * @author virieux
 */
public interface InterfaceFcsGUI extends InterfaceGeneralGUI {

    static long CONNECT_LOADER_TIMEOUT = 6000;

    static long SET_FILTER_TIMEOUT = 120000;

    static long STORE_FILTER_TIMEOUT = 60000;

    static long LOAD_FILTER_TIMEOUT = 240000;

    static long GRAB_FILTER_TIMEOUT = 25000;

    static long DISENGAGE_FILTER_TIMEOUT = 15000;

    static long TRUCKS_MOTION_TIMEOUT = 50000;


    default void setFilter(int filterID) {
        System.out.println("setFilter with timeout=" + SET_FILTER_TIMEOUT);
        FCSLOG.info("Setting filter");
        sendCommand("setFilter " + filterID, SET_FILTER_TIMEOUT);
    }

    default void setFilterAtHandoffForLoader(int filterID) {
        System.out.println("setFilterAtHandoffForLoader with timeout=" + SET_FILTER_TIMEOUT);
        FCSLOG.info("Setting filter at Handoff for Loader");
        sendCommand("setFilterAtHandoffForLoader " + filterID, SET_FILTER_TIMEOUT);
    }

    default void storeFilterOnCarousel() {
        System.out.println("storeFilterOnCarousel with timeout=" + STORE_FILTER_TIMEOUT);
        FCSLOG.info("Storing filter on carousel");
        sendCommand("storeFilterOnCarousel", STORE_FILTER_TIMEOUT);
    }

    default void loadFilter() {
        System.out.println("loadFilter with timeout=" + LOAD_FILTER_TIMEOUT);
        FCSLOG.info("Loading filter in camera");
        sendCommand("loadFilter", LOAD_FILTER_TIMEOUT);
    }

    default void unloadFilter() {
        System.out.println("unloadFilter with timeout=" + LOAD_FILTER_TIMEOUT);
        FCSLOG.info("Unloading filter in camera");
        sendCommand("unloadFilter", LOAD_FILTER_TIMEOUT);
    }

    default void connectLoader() {
        System.out.println("connect loader with timeout=" + CONNECT_LOADER_TIMEOUT);
        FCSLOG.info("connecting loader CANbus");
        sendCommand("connectLoaderCANbus", CONNECT_LOADER_TIMEOUT);
    }

    default void disconnectLoader() {
        System.out.println("disconnect loader with timeout=" + CONNECT_LOADER_TIMEOUT);
        FCSLOG.info("disconnecting loader CANbus");
        sendCommand("disconnectLoaderCANbus", CONNECT_LOADER_TIMEOUT);
    }

    default void rotateSocketToStandby(int socketID) {
        FCSLOG.info("Carousel rotating");
        FCSLOG.info("/timeout=" + timeoutForRotation);
        if (socketID < 1 || socketID > 5) {
            throw new IllegalArgumentException(socketID + " bad socket ID; enter a digit between 1 and 5");
        }
        sendCommand("rotateSocketToStandby socket" + socketID, timeoutForRotation, carouselName);
    }

    default void grabFilterAtStandby() {
        FCSLOG.info("executing grabFilterAtStandby");
        sendCommand("grabFilterAtStandby", GRAB_FILTER_TIMEOUT, AC_NAME);
    }

    default void disengageFilterFromCarousel() {
        FCSLOG.info("executing disengageFilterFromCarousel");
        sendCommand("disengageFilterFromCarousel", DISENGAGE_FILTER_TIMEOUT);
    }

    default void moveAndClampFilterOnline() {
        FCSLOG.info("executing moveAndClampFilterOnline");
        FCSLOG.info("/timeout=" + TRUCKS_MOTION_TIMEOUT);
        sendCommand("moveAndClampFilterOnline", TRUCKS_MOTION_TIMEOUT, AC_NAME);
    }

}
