/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.io.Serializable;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class DiamondSwitch
extends JComponent {
    private String sensorName;
    private int size = 25;
    private Color color = new Color(0, 153, 0);

    public DiamondSwitch() {
        super.setPreferredSize(new Dimension(this.size, this.size));
    }

    public DiamondSwitch(String sensorName) {
        super.setPreferredSize(new Dimension(this.size, this.size));
        this.sensorName = sensorName;
    }

    public void setSize(int size) {
        this.size = size;
        super.setPreferredSize(new Dimension(size, size));
    }

    public void setColor(Color c) {
        this.color = c;
        this.repaint();
    }

    public void updateColor(boolean sensorInError, boolean sensorValue) {
        if (sensorInError) {
            this.setColor(Color.RED);
        } else {
            this.setColor(sensorValue ? Tools.greenColor : Color.gray);
        }
    }

    public void updateColorGreenGray(Map<String, Serializable> sMap) {
        if (sMap.containsKey(this.sensorName)) {
            this.setColor(1 == (Integer)sMap.get(this.sensorName) ? Color.GREEN : Color.gray);
        }
    }

    public void updateColorGrayGreen(Map<String, Serializable> sMap) {
        if (sMap.containsKey(this.sensorName)) {
            this.setColor(1 == (Integer)sMap.get(this.sensorName) ? Color.gray : Color.GREEN);
        }
    }

    public void updateColorDefaultRedGreen(Map<String, Serializable> sMap) {
        if (sMap.containsKey(this.sensorName)) {
            this.setColor(1 == (Integer)sMap.get(this.sensorName) ? Color.RED : Color.GREEN);
        }
    }

    public void updateColorDefaultRedGray(Map<String, Serializable> sMap) {
        if (sMap.containsKey(this.sensorName)) {
            this.setColor(1 == (Integer)sMap.get(this.sensorName) ? Color.RED : Color.gray);
        }
    }

    public void updateColorRedGreen(Map<String, Serializable> sMap) {
        if (sMap.containsKey(this.sensorName)) {
            this.setColor(1 == (Integer)sMap.get(this.sensorName) ? Color.GREEN : Color.RED);
        }
    }

    public void updateColorGreenRed(Map<String, Serializable> sMap) {
        if (sMap.containsKey(this.sensorName)) {
            this.setColor(1 == (Integer)sMap.get(this.sensorName) ? Color.GREEN : Color.RED);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        Diamond diamond = new Diamond((double)this.size);
        g2d.setColor(this.color);
        g2d.fill(diamond);
        g2d.setColor(Color.BLACK);
        g2d.draw(diamond);
        g2d.dispose();
    }

    public static void main(String[] argv) {
        DiamondSwitch d = new DiamondSwitch();
        JFrame frame = new JFrame();
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public class Diamond
    extends Path2D.Double {
        public Diamond(double size) {
            this.moveTo(0.0, size / 2.0);
            this.lineTo(size / 2.0, 0.0);
            this.lineTo(size, size / 2.0);
            this.lineTo(size / 2.0, size);
            this.closePath();
        }
    }
}

