
package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.GridBagConstraints;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 *
 * @author virieux
 */
public class FcsCameraProtectionPanel extends JPanel {

    private static final long serialVersionUID = 1L;
    public static final String title = "Camera Protection System";
    /* status information */
    private final CarouselStatusPanel caStatusPanel = new CarouselStatusPanel();
    private final AutochangerStatusPanel acStatusPanel = new AutochangerStatusPanel();
    private final LoaderStatusPanel loStatusPanel = new LoaderStatusPanel();


    public FcsCameraProtectionPanel() {
        initComponents();
    }

    /**
     * update from status published by Carousel
     *
     * @param s
     */
    void updateCarousel(StatusDataPublishedByCarousel s) {
        caStatusPanel.updateCarousel(s);
    }

    /**
     * update from status published by autochanger
     *
     * @param s
     */
    void updateAutochanger(StatusDataPublishedByAutoChanger s) {
        acStatusPanel.updateAutochanger(s);
    }

    
    /**
     * update from status published by sensor list
     *
     * @param kvdl
     */
    void updateLoaderFromSensorList(KeyValueDataList kvdl) {
            loStatusPanel.updateFromSensorList(kvdl);
    }


    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        /**
         ******************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        /*General Information Panel*/
        setBorder(BorderFactory.createTitledBorder(title));
        setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.BASELINE_LEADING;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(caStatusPanel, gbc);

        gbc.anchor = GridBagConstraints.EAST;
        gbc.gridx++;
        add(acStatusPanel, gbc);

        gbc.gridx++;
        add(loStatusPanel, gbc);
        /**
         ******************************************************************************
         ** end of Whole Panel
         * *****************************************************************************
         */
        setDefaultValues();
    }

    /**
     * set default values for components color and labels.
     */
    private void setDefaultValues() {
        caStatusPanel.setDefaultValues();
        acStatusPanel.setDefaultValues();
        loStatusPanel.setDefaultValues();
    }

    /**
     * Reset Panels to default values.
     */
    public void resetPanel() {
        setDefaultValues();
    }

    @Override
    public String toString() {
        return title;
    }

    /**
     * This main launches an GUI for the whole subsystem "fcs". It's used only
     * for tests.
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        FcsCameraProtectionPanel d = new FcsCameraProtectionPanel();
        JFrame frame = new JFrame("FCS Camera Protection System Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

}
