
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.HorizontalLine;
import org.lsst.ccs.subsystems.fcs.ui.commons.RectangleSwitch;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AF0_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AF1_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AF3_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AP1_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AP2_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.AP3_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.CF0_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.CF1_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.CFC_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.CS_EXP;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.SP_V_LINE_HEIGHT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.SP_V_LINE_STARTINGY;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.createPanelWithComponent;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.create_subPanelWith2Switch;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.NO_LOCKOUT;

import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalLine;

/**
 *
 * @author virieux
 */
public class PLCAutochangerPanel extends JPanel {

    private final String engineering = "<BR>Autochanger<BR>Engineering<BR>Mode";
    private final String LOCKOUT_SHUNT = "<BR>Autochanger<BR>Lock Out Shunt Standalone Bay";
    private final String enable_clamps = "enable_clamps";
    private final String enable_latches = "enable_latches";
    private final String enable_rails = "enable_linear_rails";

    private final DigitalSwitch af0Switch = new DigitalSwitch();
    private final DigitalSwitch af1SwitchL1 = new DigitalSwitch();
    private final DigitalSwitch af1SwitchL2 = new DigitalSwitch();
    private final DigitalSwitch af3SwitchC = new DigitalSwitch();
    private final DigitalSwitch af3SwitchR1 = new DigitalSwitch();
    private final DigitalSwitch af3SwitchR4 = new DigitalSwitch();
    private final DigitalSwitch ap1SwitchC = new DigitalSwitch();
    private final DigitalSwitch ap1SwitchR = new DigitalSwitch();
    private final DigitalSwitch ap2Switch = new DigitalSwitch();
    private final DigitalSwitch ap3SwitchC = new DigitalSwitch();
    private final DigitalSwitch ap3SwitchR = new DigitalSwitch();
    private final DigitalSwitch notAp3Switch = new DigitalSwitch();

    private final DigitalSwitch ainSwitchC = new DigitalSwitch();
    private final DigitalSwitch ainSwitchL = new DigitalSwitch();
    private final DigitalSwitch ainSwitchR = new DigitalSwitch();
    private final DigitalSwitch notAlmSwitch = new DigitalSwitch();
    private final DigitalSwitch aolSwitch = new DigitalSwitch();
    private final DigitalSwitch cfcSwitch = new DigitalSwitch();
    private final DigitalSwitch cf0Switch1 = new DigitalSwitch();
    private final DigitalSwitch cf0Switch2 = new DigitalSwitch();
    private final DigitalSwitch cf1Switch = new DigitalSwitch();
    private final DigitalSwitch csSwitch1 = new DigitalSwitch();
    private final DigitalSwitch csSwitch2 = new DigitalSwitch();
    private final DigitalSwitch csSwitch3 = new DigitalSwitch();
    private final DigitalSwitch csSwitch4 = new DigitalSwitch();
    private final DigitalSwitch lpsSwitch = new DigitalSwitch();
    private final DigitalSwitch lrhSwitch = new DigitalSwitch();
    private final DigitalSwitch NoLockoutSwitchC = new DigitalSwitch();
    private final DigitalSwitch NoLockoutSwitchL = new DigitalSwitch();
    private final DigitalSwitch NoLockoutSwitchR = new DigitalSwitch();
    private final DigitalSwitch lockoutShuntSwitchC = new DigitalSwitch();
    private final DigitalSwitch lockoutShuntSwitchL = new DigitalSwitch();
    private final DigitalSwitch lockoutShuntSwitchR = new DigitalSwitch();
    private final DigitalSwitch engineeringSwitchC = new DigitalSwitch();
    private final DigitalSwitch engineeringSwitchL = new DigitalSwitch();
    private final DigitalSwitch engineeringSwitchR = new DigitalSwitch();

    /* Relays*/
    private final RectangleSwitch clampsRelayRectangle = new RectangleSwitch();
    private final RectangleSwitch latchesRelayRectangle = new RectangleSwitch();
    private final RectangleSwitch railsRelayRectangle = new RectangleSwitch();
    
    /**
     * A Runnable to initialize this Panel from status data published on the STATUS bus
     * by the autochanger
     */
    private class UpdateAutochanger implements Runnable {

        private StatusDataPublishedByAutoChanger s;

        public UpdateAutochanger(StatusDataPublishedByAutoChanger status) {
            this.s = status;
        }

        @Override
        public void run() {
            /*Loader_LPS (=1 if loader is at Storage, loader connected) */
            lpsSwitch.updateColor(s.isLoaderConnectedSensorsInError(),
                    s.getLoaderConnectedSensorValue());

            /*Loader_LRH (=1 if loader is holding filter at HANDOFF) */
            lrhSwitch.updateColor(false, s.isLoaderHoldingFilterAtHandoff());

            /* not ALM is a shunt for loader presence sensor, should be green when LPS is gray, and gray when LPS is green.*/
            notAlmSwitch.updateColor(s.isLoaderPresenceInError(), !s.isLoaderPresence());


            //TODO update ain switches
            for (DigitalSwitch ds: new DigitalSwitch[]{ainSwitchC, ainSwitchL, ainSwitchR}) {
                ds.setColor(s.isOUT_AIN() ? Color.GREEN : Color.gray);
            }

            aolSwitch.setColor(s.isOUT_AOL() ? Color.GREEN : Color.gray);

            /*Carousel_CFC (=1 if if filter is clamped on carousel) */
            cfcSwitch.updateColor(s.isCarouselHoldingFilterInError(),
                    s.isCarouselHoldingFilter());

            /*Carousel_CS (=1 if carousel is stopped at standby) */
            for (DigitalSwitch ds: new DigitalSwitch[]{csSwitch1, csSwitch2, csSwitch3, csSwitch4}) {
                ds.updateColor(s.isCarousel_CS_InError(), s.isCarousel_CS());
            }
            

            /*Carousel_CF0 (=1 if no filter in carousel socket) */
            cf0Switch1.updateColor(s.isCarousel_CF0_InError(), s.isCarousel_CF0());
            cf0Switch2.updateColor(s.isCarousel_CF0_InError(), s.isCarousel_CF0());

            /*Carousel_CF1 (=1 if filter locked in carousel socket) */
            cf1Switch.updateColor(s.isCarousel_CF1_InError(), s.isCarousel_CF1());

            /* Local Protection Signals generated by AC */
            /* 0 : motion forbidden, 1: motion permitted */
            /* first argument of updateColor is false because lpm status can't be in error */
            /* because they is only one chanel */
            railsRelayRectangle.updateColor(false, s.isEnableRailLin1());
            railsRelayRectangle.updateColor(false, s.isEnableRailLin2());
            clampsRelayRectangle.updateColor(false, s.isEnableClamps());
            latchesRelayRectangle.updateColor(false, s.isEnableLatches());

            /* engineering status : ON if engineering is turned on */
            for (DigitalSwitch ds: new DigitalSwitch[]{engineeringSwitchC, engineeringSwitchL, engineeringSwitchR}) {
                ds.updateColor(s.isEngineeringKey_InError(), s.isEngineeringKey());
            }

            /* lockOut  */
            for (DigitalSwitch ds : new DigitalSwitch[]{NoLockoutSwitchC, NoLockoutSwitchL, NoLockoutSwitchR}) {
                ds.updateColor(s.isLockOutInError(), !s.isLockOut());
            }
            for (DigitalSwitch ds : new DigitalSwitch[]{lockoutShuntSwitchC, lockoutShuntSwitchL, lockoutShuntSwitchR}) {
                ds.setColor(s.isLockOutShunt() ? Color.GREEN : Color.gray);
            }
            
            /* Trucks Position status */
            ap1SwitchC.updateColor(s.isOUT_AP1_InError(), s.isOUT_AP1());
            ap1SwitchR.updateColor(s.isOUT_AP1_InError(), s.isOUT_AP1());
            ap2Switch.updateColor(s.isOUT_AP2_InError(), s.isOUT_AP2());
            ap3SwitchC.updateColor(s.isOUT_AP3_InError(), s.isOUT_AP3());
            ap3SwitchR.updateColor(s.isOUT_AP3_InError(), s.isOUT_AP3());
            notAp3Switch.updateColor(s.isOUT_AP3_InError(), !s.isOUT_AP3());
            
            /* Filter Status */
            af0Switch.updateColor(s.isOUT_AF0_InError(), s.isOUT_AF0());
            af1SwitchL1.updateColor(s.isOUT_AF1_InError(), s.isOUT_AF1());
            af1SwitchL2.updateColor(s.isOUT_AF1_InError(), s.isOUT_AF1());
            for (DigitalSwitch ds: new DigitalSwitch[]{af3SwitchC, af3SwitchR1, af3SwitchR4}) {
                ds.updateColor(s.isOUT_AF3_InError(), s.isOUT_AF3());
            }
        }
    }

    public PLCAutochangerPanel() {
        initComponents();
    }
    
    public void updateAutochanger(StatusDataPublishedByAutoChanger status) {
        SwingUtilities.invokeLater(new UpdateAutochanger(status));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     */
    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        /**
         *******************************************************************************
         * Whole panel
         * *******************************************************************************
         */
        setBorder(javax.swing.BorderFactory.createTitledBorder("AUTOCHANGER PROTECTION SYSTEM"));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.WEST;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridy++;
        add(create_explanationsPanel(), gbc);
        gbc.gridy++;
        add(create_clampsPanel(), gbc);
        gbc.gridy++;
        add(create_latchesPanel(), gbc);
        gbc.gridy++;
        add(create_linearRailsPanel(), gbc);
        
        /* set default values for whole panel*/
        setDefaultValues();
    }
    
    private JPanel create_explanationsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.WEST;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(new JLabel("<HTML><b>Signals displayed on this panel are read on acSensorsGateway (Autochanger PLC)</b></HTML>"), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(AP1_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(AP2_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(AP3_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel("<HTML><b>AOL</b>: ONLINE clamps all opened &nbsp</HTML>"), gbcp);
        gbcp.gridy++;  
        panel.add(new JLabel(AF0_EXP), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel(AF1_EXP), gbcp);
        gbcp.gridy++;  
        panel.add(new JLabel(AF3_EXP), gbcp);
        gbcp.gridy++;  
        panel.add(new JLabel(""), gbcp);

        gbcp.gridy = 1;
        gbcp.gridx = 2;
        panel.add(new JLabel(CS_EXP), gbcp);
        gbcp.gridy++; 
        panel.add(new JLabel(CFC_EXP), gbcp);
        gbcp.gridy++; 
        panel.add(new JLabel(CF0_EXP), gbcp);
        gbcp.gridy++; 
        panel.add(new JLabel(CF1_EXP), gbcp);
        gbcp.gridy++; 
        panel.add(new JLabel("<HTML><b>LRH</b>: Loader holding filter at HANDOFF position</HTML>"), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel("<HTML><b>LPS</b>: Loader carrier at STORAGE position</HTML>"), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel("<HTML><b>ALM</b>: Loader docked</HTML>"), gbcp);
        gbcp.gridy++;
        panel.add(new JLabel("<HTML><b>AIN</b>: Inclinaison sensor less than 10°</HTML>"), gbcp);
        gbcp.gridy++;  
        panel.add(new JLabel(""), gbcp);
        return panel;
    }

    private JPanel create_clampsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Online Clamps"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent("AP3", ap3SwitchC, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AF3", af3SwitchC, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AIN", ainSwitchC, false, true), gbcp);
        gbcp.gridx++;

        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);
        gbcp.gridx++;
        panel.add(new HorizontalLine(), gbcp);
        gbcp.gridx++;
        panel.add(create_subPanelWith2Switch(NO_LOCKOUT, NoLockoutSwitchC, LOCKOUT_SHUNT, lockoutShuntSwitchC), gbcp);
        gbcp.gridx++;
        panel.add(new HorizontalLine(), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(enable_clamps, clampsRelayRectangle, false, false), gbcp);


        gbcp.gridheight = 1;
        gbcp.gridwidth = 3;
        gbcp.gridx = 0;
        gbcp.gridy++;
        panel.add(createPanelWithComponent(engineering, engineeringSwitchC, false, true, 100), gbcp);

        return panel;
    }

    private JPanel create_latchesPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Latches"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent("AP2", ap2Switch, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AF1", af1SwitchL1, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("LRH", lrhSwitch, false, true), gbcp);

        gbcp.gridx++;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AIN", ainSwitchL, true, true), gbcp);

        gbcp.gridx++;
        gbcp.gridheight = 3;
        panel.add(new VerticalLine(175, 50), gbcp);

        gbcp.gridx++;
        gbcp.gridheight = 2;
        panel.add(new HorizontalLine(), gbcp);
        gbcp.gridx++;
        panel.add(create_subPanelWith2Switch(NO_LOCKOUT, NoLockoutSwitchL, LOCKOUT_SHUNT, lockoutShuntSwitchL), gbcp);

        gbcp.gridx++;
        panel.add(new HorizontalLine(), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(enable_latches, latchesRelayRectangle, false, false), gbcp);

        /* line2*/
        gbcp.gridheight = 1;
        gbcp.gridx = 0;
        gbcp.gridy++;
        panel.add(createPanelWithComponent("CFC", cfcSwitch, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AP1", ap1SwitchC, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AF1", af1SwitchL2, false, true), gbcp);

        /* line3*/
        gbcp.gridx = 0;
        gbcp.gridy++;
        gbcp.gridwidth = 5;
        panel.add(createPanelWithComponent(engineering, engineeringSwitchL, false, true, 230), gbcp);

        return panel;
    }

    private JPanel create_linearRailsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Linear Rails"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;

        /* line1*/
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent("CS", csSwitch1, false, true), gbcp);
        gbcp.gridx++;
        gbcp.gridwidth = 2;
        panel.add(createPanelWithComponent("CF0", cf0Switch1, false, true, 100), gbcp);
        gbcp.gridwidth = 1;
        
        gbcp.gridx++;
        gbcp.gridx++;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, 10), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AF3", af3SwitchR1, true, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("NOT AP3", notAp3Switch, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AOL", aolSwitch, false, true), gbcp);
        gbcp.gridx++;
        gbcp.gridheight = 3;
        panel.add(new VerticalLine(130, 45), gbcp);
        gbcp.gridx++;
        gbcp.gridheight = 2;
        panel.add(new HorizontalLine(), gbcp);
        gbcp.gridx++;
        panel.add(create_subPanelWith2Switch("LPS", lpsSwitch, "<BR>NOT ALM</BR>", notAlmSwitch), gbcp);
        gbcp.gridx++;
        panel.add(new HorizontalLine(), gbcp);
        gbcp.gridx++;
        gbcp.gridheight = 4;
        panel.add(new VerticalLine(180, 50), gbcp);
        gbcp.gridx++;
        gbcp.gridheight = 2;

        panel.add(createPanelWithComponent("AIN", ainSwitchR, true, true), gbcp);
        gbcp.gridx++;
        gbcp.gridheight = 5;
        panel.add(new VerticalLine(260, 50), gbcp);
        gbcp.gridx++;
        gbcp.gridheight = 2;
        panel.add(new HorizontalLine(), gbcp);
        gbcp.gridx++;
        panel.add(create_subPanelWith2Switch(NO_LOCKOUT, NoLockoutSwitchR, LOCKOUT_SHUNT, lockoutShuntSwitchR), gbcp);
        gbcp.gridx++;
        panel.add(new HorizontalLine(), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(enable_rails, railsRelayRectangle, false, false), gbcp);

        /* line2*/
        gbcp.gridheight = 1;
        gbcp.gridx = 0;
        gbcp.gridy++;
        panel.add(createPanelWithComponent("CS", csSwitch2, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("CF1", cf1Switch, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AP1", ap1SwitchR, false, true), gbcp);

        /* line3*/
        gbcp.gridx = 0;
        gbcp.gridy++;
        panel.add(createPanelWithComponent("CS", csSwitch3, false, true), gbcp);
        gbcp.gridx++;
        gbcp.gridwidth = 6;
        gbcp.anchor = GridBagConstraints.WEST;
        panel.add(createPanelWithComponent("AF0", af0Switch, false, true, 375), gbcp);
        gbcp.gridwidth = 1;
        gbcp.anchor = GridBagConstraints.CENTER;

        /* line4*/
        gbcp.gridx = 0;
        gbcp.gridy++;
        panel.add(createPanelWithComponent("CS", csSwitch4, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("CF0", cf0Switch2, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AP3", ap3SwitchR, false, true), gbcp);
        gbcp.gridx++;
        gbcp.gridwidth = 8;
        panel.add(createPanelWithComponent("AF3", af3SwitchR4, false, true, 500), gbcp);
        gbcp.gridwidth = 1;

        /* line5*/
        gbcp.gridx = 0;
        gbcp.gridy++;
        gbcp.gridwidth = 13;
        panel.add(createPanelWithComponent(engineering, engineeringSwitchR, false, true, 750), gbcp);

        return panel;
    }

    /**
     * Initialization to be done when Autochanger subsystem is not yet booted or is shutdown.
     */
    private void setDefaultValues() {
        DigitalSwitch[] digitalList = new DigitalSwitch[]{
                af0Switch,
                af1SwitchL1,
                af1SwitchL2,
                af3SwitchC,
                af3SwitchR1,
                af3SwitchR4,
                ap1SwitchC,
                ap1SwitchR,
                ap2Switch,
                ap3SwitchC,
                ap3SwitchR,
                notAp3Switch,
                ainSwitchC,
                ainSwitchL,
                ainSwitchR,
            notAlmSwitch,                aolSwitch,
                cfcSwitch,
                cf0Switch1,
                cf0Switch2,
                cf1Switch,
                csSwitch1,
                csSwitch2,
                csSwitch3,
                csSwitch4,
                lpsSwitch,
                lrhSwitch,
                NoLockoutSwitchC,
                NoLockoutSwitchL,
                NoLockoutSwitchR,
                lockoutShuntSwitchC,
                lockoutShuntSwitchL,
                lockoutShuntSwitchR,
                engineeringSwitchC,
                engineeringSwitchL,
                engineeringSwitchR,
        };
        for (DigitalSwitch c : digitalList) {
            c.setColor(Color.gray);
        }
        clampsRelayRectangle.setColor(Color.gray);
        latchesRelayRectangle.setColor(Color.gray);
        railsRelayRectangle.setColor(Color.gray);
    }

    /**
     * Reset components to default values.
     */
    public void resetPanel() {
        setDefaultValues();
    }
    @Override
    public String toString() {
        return "PLC Autochanger Panel";
    }
}
