/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.tree.utils.flashingNode;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeRepaintNotification;
import org.freehep.jas.plugin.tree.FTreeProvider;
import org.freehep.jas.plugin.tree.utils.flashingNode.FlashingNode;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandSource;
import org.freehep.util.commanddispatcher.CommandSourceAdapter;
import org.freehep.util.commanddispatcher.CommandState;

public class FlashingNodePlugin
extends Plugin {
    private FTreeNode[] selectedNodes;
    private FTree tree;
    private boolean isFlashed = true;

    @Override
    protected void postInit() {
        Studio app = this.getApplication();
        FTreeProvider treeProvider = (FTreeProvider)app.getLookup().lookup(FTreeProvider.class);
        this.tree = treeProvider.tree();
        treeProvider.treeNodeAdapterRegistry().registerNodeAdapter(new FlashingNodeAdapter(), FlashingNode.class);
        app.getCommandTargetManager().add((CommandGroup)new FlashingNodePluginCommands(this));
        int delay = 1000;
        ActionListener taskPerformer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlashingNodePlugin.this.isFlashed = !FlashingNodePlugin.this.isFlashed;
                FlashingNodePlugin.this.tree.treeChanged(new FTreeNodeRepaintNotification((Object)FlashingNodePlugin.this, FlashingNodePlugin.this.tree.root().path(), true));
            }
        };
        new Timer(delay, taskPerformer).start();
    }

    static /* synthetic */ FTreeNode[] access$202(FlashingNodePlugin x0, FTreeNode[] x1) {
        x0.selectedNodes = x1;
        return x1;
    }

    class FlashingNodePluginCommands
    extends CommandProcessor {
        private FlashingNodePlugin plugin;

        FlashingNodePluginCommands(FlashingNodePlugin plugin) {
            this.plugin = plugin;
        }

        public void onStartFlashing() {
            for (int i = 0; i < FlashingNodePlugin.this.selectedNodes.length; ++i) {
                FlashingNode flashingNode = (FlashingNode)FlashingNodePlugin.this.selectedNodes[i].objectForClass(FlashingNode.class);
                if (flashingNode == null) continue;
                flashingNode.setIsFlashing(true);
            }
        }

        public void enableStartFlashing(CommandState state) {
            for (int i = 0; i < FlashingNodePlugin.this.selectedNodes.length; ++i) {
                FlashingNode flashingNode = (FlashingNode)FlashingNodePlugin.this.selectedNodes[i].objectForClass(FlashingNode.class);
                if (flashingNode == null || flashingNode.isFlashing()) continue;
                state.setEnabled(true);
                return;
            }
            state.setEnabled(false);
        }

        public void onStopFlashing() {
            for (int i = 0; i < FlashingNodePlugin.this.selectedNodes.length; ++i) {
                FlashingNode flashingNode = (FlashingNode)FlashingNodePlugin.this.selectedNodes[i].objectForClass(FlashingNode.class);
                if (flashingNode == null) continue;
                flashingNode.setIsFlashing(false);
            }
        }

        public void enableStopFlashing(CommandState state) {
            for (int i = 0; i < FlashingNodePlugin.this.selectedNodes.length; ++i) {
                FlashingNode flashingNode = (FlashingNode)FlashingNodePlugin.this.selectedNodes[i].objectForClass(FlashingNode.class);
                if (flashingNode == null || !flashingNode.isFlashing()) continue;
                state.setEnabled(true);
                return;
            }
            state.setEnabled(false);
        }
    }

    class FlashingNodeAdapter
    extends DefaultFTreeNodeAdapter {
        public FlashingNodeAdapter() {
            super(500);
        }

        @Override
        public JPopupMenu modifyPopupMenu(FTreeNode[] nodes, JPopupMenu menu) {
            FlashingNodePlugin.access$202(FlashingNodePlugin.this, nodes[0].tree().selectedNodes());
            JMenuItem startItem = new JMenuItem("Start Flashing");
            FlashingNodePlugin.this.getApplication().getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)startItem));
            menu.add(startItem);
            JMenuItem stopItem = new JMenuItem("Stop Flashing");
            FlashingNodePlugin.this.getApplication().getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)stopItem));
            menu.add(stopItem);
            return menu;
        }

        @Override
        public Component treeCellRendererComponent(Component component, FTreeNode node, boolean sel, boolean expanded, boolean leaf, boolean hasFocus) {
            FlashingNode flashingNode = (FlashingNode)node.objectForClass(FlashingNode.class);
            if (flashingNode.isFlashing() && FlashingNodePlugin.this.isFlashed) {
                component.setForeground(flashingNode.flashingColor());
            }
            return component;
        }
    }
}

