/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

public class CCSHealthFilter
extends AbstractChannelsFilter {
    public static final String CREATOR_PATH = "Built-In/Whole Camera/CCS Health";
    private static final String GROUP_STATE = "Core States/";
    private static final String GROUP_VERSION = "Versions/";
    private static final String GROUP_RUNTIME = "Runtime Info/";
    private static final List<String> CHANNELS = Collections.unmodifiableList(Arrays.asList("/state/PhaseState", "/state/OperationalState", "/state/ConfigurationState", "/state/AlertState", "/state/CommandState", "/ccsVersions/", "/runtimeInfo/"));
    private static final int cut = 5;
    private static final Pattern PAT_VERSION = Pattern.compile("ccsVersions/+([^/]+)/version");
    private static final Pattern PAT_RUNTIME = Pattern.compile("runtimeInfo/+([^/]+)");
    private static final Pattern PAT_REVERSE = Pattern.compile("([^/]+/)([^/]+)/([^/]+)");

    @Create(category="AgentChannelsFilter", name="CCS", path="Built-In/Whole Camera/CCS Health", description="CCS Health Monitor. Selects channels that reflect CCS state and conditions, and are present in all subsystems.")
    public CCSHealthFilter() {
    }

    @Override
    public String getDisplayPath(AgentChannel channel) {
        String path = channel.getLocalPath();
        Matcher m = PAT_VERSION.matcher(path);
        if (m.matches()) {
            return GROUP_VERSION + channel.getAgentName() + "/" + m.group(1);
        }
        m = PAT_RUNTIME.matcher(path);
        if (m.matches()) {
            return GROUP_RUNTIME + channel.getAgentName() + "/" + m.group(1);
        }
        return GROUP_STATE + channel.getAgentName() + path.substring(5, path.length() - 5);
    }

    @Override
    public String getOriginPath(String displayPath) {
        Matcher m = PAT_REVERSE.matcher(displayPath);
        if (m.matches()) {
            switch (m.group(1)) {
                case "Core States/": {
                    return m.group(2) + "/state/" + m.group(3) + "State";
                }
                case "Versions/": {
                    return m.group(2) + "/ccsVersions/" + m.group(3) + "/version";
                }
                case "Runtime Info/": {
                    return m.group(2) + "/runtimeInfo/" + m.group(3);
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public List<String> getOriginChannels() {
        return CHANNELS;
    }

    @Override
    public String getName() {
        return "CCS";
    }

    @Override
    public List<String> getFields(boolean compact) {
        return Collections.singletonList("VALUE");
    }
}

