/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.ui.commons.DiamondSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.HorizontalLine;
import org.lsst.ccs.subsystems.fcs.ui.commons.RectangleSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalLine;

public class PLCLoaderPanel
extends JPanel {
    private static final String LABEL1 = "<HTML>On camera<BR>Filter hold</BR><BR>by Loader</BR></HTML>";
    private static final String LABEL2 = "<HTML>On camera<BR>Filter hold</BR><BR>by AC</BR></HTML>";
    private static final String LABEL3 = "<HTML>Engineering<BR>mode</BR></HTML>";
    private static final String LABEL4 = "<HTML>On camera<BR>Without Filter</BR></HTML>";
    private final String loaderDocked = "Loader<BR>Docked";
    private final String notDefault = "NO<BR>Default Status";
    private final String LFS = "LFS Status";
    private final String notLFS = "NO<BR>LFS Status";
    private final String LFD = "LFD Status";
    private final String notLFD = "NO<BR>LFD Status";
    private final String engineering = "Loader<BR>Engineering<BR>Mode";
    private final String safetyBelt = "Safety<BR>Belt<BR>Presence";
    private final String closed = "Hooks<BR>Closed</BR>";
    private final String clamped = "Hooks<BR>Clamped</BR>";
    private final String unclamped = "Hooks<BR>Unclamped</BR>";
    private final String notClosed = "Hooks NOT<BR>Closed</BR>";
    private final String opened = "Hooks<BR>Opened</BR>";
    private final String notOpened = "Hooks NOT<BR>Opened</BR>";
    private final String notUnderClamped = "Hooks NOT<BR>Under Clamped</BR>";
    private final String notOverClamped = "Hooks NOT<BR>Over Clamped</BR>";
    private final String filterPresence = "Filter<BR>Presence</BR>";
    private final String noFilterPresence = "Filter<BR>Not Present</BR>";
    private final String filterPosition = "Filter<BR>Position</BR>";
    private final String engaged = "Carrier<BR>is between ENGAGED</BR><BR> and HANDOFF</BR>";
    private final String handoff = "Carrier<BR>at HANDOFF</BR>";
    private final String storage = "Carrier<BR>at STORAGE</BR>";
    private final String notHandoff = "Carrier<BR>NOT at HANDOFF</BR>";
    private final String carrierRelay = "Carrier<BR>Relay</BR>";
    private final String hooksRelay = "Hooks<BR>Relay</BR>";
    private final DigitalSwitch loaderDockedDigitalSwitch_lfc = new DigitalSwitch();
    private final DigitalSwitch loaderDockedDigitalSwitch_lfs = new DigitalSwitch();
    private final DigitalSwitch loaderDockedDigitalSwitch_lfu = new DigitalSwitch();
    private final DigitalSwitch loaderDockedDigitalSwitch_lfx = new DigitalSwitch();
    private final DigitalSwitch loaderDockedDigitalSwitch_lfy = new DigitalSwitch();
    private final DigitalSwitch loaderDockedDigitalSwitch_lfz = new DigitalSwitch();
    private final DigitalSwitch ap2Switch1 = new DigitalSwitch();
    private final DigitalSwitch ap2Switch2 = new DigitalSwitch();
    private final DigitalSwitch ap2Switch3 = new DigitalSwitch();
    private final DigitalSwitch ap2Switch4 = new DigitalSwitch();
    private final DigitalSwitch af0Switch1 = new DigitalSwitch();
    private final DigitalSwitch af0Switch2 = new DigitalSwitch();
    private final DigitalSwitch af3Switch = new DigitalSwitch();
    private final DigitalSwitch notLockoutSwitch1 = new DigitalSwitch();
    private final DigitalSwitch notLockoutSwitch2 = new DigitalSwitch();
    private final DigitalSwitch engineeringSwitchC = new DigitalSwitch();
    private final DigitalSwitch engineeringSwitchH = new DigitalSwitch();
    private final DigitalSwitch filterPresenceSwitch_lfc = new DigitalSwitch();
    private final DigitalSwitch filterPresenceSwitch_lfd = new DigitalSwitch();
    private final DigitalSwitch filterPresenceSwitch_lfs = new DigitalSwitch();
    private final DigitalSwitch filterPresenceSwitch_lfx = new DigitalSwitch();
    private final DigitalSwitch filterPresenceSwitch_lfy = new DigitalSwitch();
    private final DigitalSwitch notFilterPresenceSwitch_lfd = new DigitalSwitch();
    private final DigitalSwitch notFilterPresenceSwitch_lfz = new DigitalSwitch();
    private final DigitalSwitch engagedPositionSwitch_lfc = new DigitalSwitch();
    private final DigitalSwitch engagedPositionSwitch_lfx = new DigitalSwitch();
    private final DigitalSwitch engagedPositionSwitch_lfz = new DigitalSwitch();
    private final DigitalSwitch handoffPositionSwitch_lfx = new DigitalSwitch();
    private final DigitalSwitch handoffPositionSwitch_lfy = new DigitalSwitch();
    private final DigitalSwitch notHandoffPositionSwitch_lfs = new DigitalSwitch();
    private final DigitalSwitch notHandoffPositionSwitch_lfd = new DigitalSwitch();
    private final DigitalSwitch storagePositionSwitch_lfz = new DigitalSwitch();
    private DigitalSwitch[] digitalList;
    private DiamondSwitch[] diamondList;
    private final DiamondSwitch hooksClampedStatusSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch hooksUnclampedStatusSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch hooksUnclampedStatusSwitch_lfy = new DiamondSwitch();
    private final DiamondSwitch notUnderClampedStatusSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfx = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfy = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfz = new DiamondSwitch();
    private final DiamondSwitch hooksClosedSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch hooksClosedSwitch_lfx = new DiamondSwitch();
    private final DiamondSwitch notClosedSwitch_lfd = new DiamondSwitch();
    private final DiamondSwitch notClosedSwitch_lfs = new DiamondSwitch();
    private final DiamondSwitch notClosedSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch notOpenedSwitch_lfd = new DiamondSwitch();
    private final DiamondSwitch openedSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch openedSwitch_lfz = new DiamondSwitch();
    private final DiamondSwitch noDefaultStatusDiamond1 = new DiamondSwitch();
    private final DiamondSwitch noDefaultStatusDiamond2 = new DiamondSwitch();
    private final DiamondSwitch noLfsStatusDiamond = new DiamondSwitch();
    private final DiamondSwitch noLfdStatusDiamond = new DiamondSwitch();
    private final DiamondSwitch lfdStatusDiamond = new DiamondSwitch();
    private final DiamondSwitch lfsStatusDiamond = new DiamondSwitch();
    private final DiamondSwitch filterGoodPositionSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch filterGoodPositionSwitch_lfs = new DiamondSwitch();
    private final DiamondSwitch safetyBeltPresenceSwitch1 = new DiamondSwitch();
    private final DiamondSwitch safetyBeltPresenceSwitch2 = new DiamondSwitch();
    private final RectangleSwitch carrierRelayRectangle = new RectangleSwitch();
    private final RectangleSwitch hooksRelayRectangle = new RectangleSwitch();

    public PLCLoaderPanel() {
        this.initComponents();
    }

    public void updateCarrier(StatusDataPublishedByLoaderCarrier status) {
        SwingUtilities.invokeLater(new UpdateCarrier(status));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateLoader(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new UpdateLoader(status));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder("LOADER PROTECTION SYSTEM"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        this.add((Component)this.create_explanationsPanel(), gbc);
        gbc.gridwidth = 1;
        ++gbc.gridy;
        this.add((Component)this.create_carrierPanel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.create_hooksPanel(), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.add((Component)this.create_lfsPanel(), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.add((Component)this.create_lfdPanel(), gbc);
        this.setDefaultValues();
    }

    private JPanel create_explanationsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 17;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)new JLabel("<HTML><b>Signals displayed on this panel are read on loaderPlutoGateway (Loader PLC)</b></HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AP2</b>: autochanger at HANDOFF position</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AF0</b>: autochanger latches opened</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>AF3</b>: filter engaged and locked on autochanger  &nbsp</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><BR></BR></HTML>"), gbcp);
        gbcp.gridy = 1;
        gbcp.gridx = 2;
        panel.add((Component)new JLabel("<HTML><b>LFU</b>: Hooks opened</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>LFD</b>: Motion prohibition</HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)new JLabel("<HTML><b>LFS</b>: Stuck-up issue</HTML>"), gbcp);
        ++gbcp.gridy;
        return panel;
    }

    private JPanel create_carrierPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Carrier"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        JLabel jlabel1 = new JLabel(LABEL1);
        jlabel1.setFont(Tools.BIG_FONT);
        panel.add((Component)jlabel1, gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.create_acStatusPanel(this.ap2Switch1, this.af0Switch1, "AF0"), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Loader<BR>Docked", this.loaderDockedDigitalSwitch_lfc, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks<BR>Closed</BR>", this.hooksClosedSwitch_lfc, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Filter<BR>Presence</BR>", this.filterPresenceSwitch_lfc, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks NOT<BR>Over Clamped</BR>", this.notOverClampedStatusSwitch_lfc, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("", this.create_lfcSubpanel(), false, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 3;
        panel.add((Component)new VerticalLine(200, 75), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("NO<BR>Default Status", this.noDefaultStatusDiamond1, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("NO<BR>LFS Status", this.noLfsStatusDiamond, true, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 4;
        panel.add((Component)new VerticalLine(300, 100), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("<B>NOT</B><BR>Lock Out Bay L</BR>", this.notLockoutSwitch1, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Safety<BR>Belt<BR>Presence", this.safetyBeltPresenceSwitch1, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Carrier<BR>Relay</BR>", this.carrierRelayRectangle, true, false), gbcp);
        gbcp.gridy += 2;
        gbcp.gridx = 0;
        JLabel jlabel2 = new JLabel(LABEL2);
        jlabel2.setFont(Tools.BIG_FONT);
        panel.add((Component)jlabel2, gbcp);
        ++gbcp.gridx;
        JPanel ap2Panel = Tools.createPanelWithComponent("AP2", this.ap2Switch3, false, true, 20);
        ap2Panel.setBorder(BorderFactory.createTitledBorder("AC Status"));
        panel.add((Component)ap2Panel, gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Loader<BR>Docked", this.loaderDockedDigitalSwitch_lfu, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks<BR>Opened</BR>", this.openedSwitch_lfu, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks NOT<BR>Under Clamped</BR>", this.notUnderClampedStatusSwitch_lfu, false, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridwidth = 2;
        panel.add((Component)Tools.createPanelWithComponent("Hooks NOT<BR>Over Clamped</BR>", this.notOverClampedStatusSwitch_lfu, false, true, 350), gbcp);
        gbcp.gridwidth = 1;
        gbcp.gridy += 2;
        gbcp.gridx = 0;
        JLabel jlabel3 = new JLabel(LABEL3);
        jlabel3.setFont(Tools.BIG_FONT);
        panel.add((Component)jlabel3, gbcp);
        ++gbcp.gridx;
        gbcp.gridwidth = 10;
        panel.add((Component)Tools.createPanelWithComponent("Loader<BR>Engineering<BR>Mode", this.engineeringSwitchC, false, true, 1000), gbcp);
        return panel;
    }

    private JPanel create_lfcSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 1;
        panel.add((Component)Tools.createPanelWithComponent("Filter<BR>Position</BR>", this.filterGoodPositionSwitch_lfc, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks<BR>Clamped</BR>", this.hooksClampedStatusSwitch_lfc, true, false), gbcp);
        ++gbcp.gridy;
        gbcp.gridx = 1;
        panel.add((Component)Tools.createPanelWithComponent("Carrier<BR>is between ENGAGED</BR><BR> and HANDOFF</BR>", this.engagedPositionSwitch_lfc, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks<BR>Unclamped</BR>", this.hooksUnclampedStatusSwitch_lfc, true, false), gbcp);
        ++gbcp.gridx;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        return panel;
    }

    private JPanel create_hooksPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Hooks"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 17;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridwidth = 3;
        panel.add((Component)this.create_hooksPanelNonEngineering(), gbcp);
        gbcp.gridx = 3;
        gbcp.gridheight = 2;
        gbcp.gridwidth = 1;
        panel.add((Component)new VerticalLine(400, 150), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("<B>NOT</B><BR>Lock Out Bay L</BR>", this.notLockoutSwitch2, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Safety<BR>Belt<BR>Presence", this.safetyBeltPresenceSwitch2, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks<BR>Relay</BR>", this.hooksRelayRectangle, true, false), gbcp);
        gbcp.gridy = 2;
        gbcp.gridx = 0;
        gbcp.gridwidth = 1;
        JLabel jlabel3 = new JLabel(LABEL3);
        jlabel3.setFont(Tools.BIG_FONT);
        panel.add((Component)jlabel3, gbcp);
        gbcp.anchor = 10;
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Loader<BR>Engineering<BR>Mode", this.engineeringSwitchH, false, true, 800), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("NO<BR>LFD Status", this.noLfdStatusDiamond, false, true, 50), gbcp);
        return panel;
    }

    private JPanel create_hooksPanelNonEngineering() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        JLabel jlabel1_2 = new JLabel(LABEL1);
        jlabel1_2.setFont(Tools.BIG_FONT);
        panel.add((Component)jlabel1_2, gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.create_acStatusPanel(this.ap2Switch2, this.af0Switch2, "AF0"), gbcp);
        ++gbcp.gridx;
        panel.add((Component)this.create_lfxPanel(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)new HorizontalLine(), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 4;
        panel.add((Component)new VerticalLine(300, 75), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("NO<BR>Default Status", this.noDefaultStatusDiamond2, true, true), gbcp);
        gbcp.gridy += 2;
        gbcp.gridx = 0;
        JLabel jlabel2_2 = new JLabel(LABEL2);
        jlabel2_2.setFont(Tools.BIG_FONT);
        panel.add((Component)jlabel2_2, gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.create_acStatusPanel(this.ap2Switch4, this.af3Switch, "AF3"), gbcp);
        ++gbcp.gridx;
        panel.add((Component)this.create_lfyPanel(), gbcp);
        gbcp.gridy += 2;
        gbcp.gridx = 0;
        JLabel jlabel4 = new JLabel(LABEL4);
        jlabel4.setFont(Tools.BIG_FONT);
        panel.add((Component)jlabel4, gbcp);
        gbcp.gridx += 2;
        panel.add((Component)this.create_lfzPanel(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)new HorizontalLine(), gbcp);
        return panel;
    }

    private JPanel create_lfxPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent("Loader<BR>Docked", this.loaderDockedDigitalSwitch_lfx, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks NOT<BR>Over Clamped</BR>", this.notOverClampedStatusSwitch_lfx, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)this.create_lfxSubpanel(), gbcp);
        return panel;
    }

    private JPanel create_lfxSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        panel.add((Component)Tools.createPanelWithComponent("Carrier<BR>at HANDOFF</BR>", this.handoffPositionSwitch_lfx, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Filter<BR>Presence</BR>", this.filterPresenceSwitch_lfx, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks<BR>Closed</BR>", this.hooksClosedSwitch_lfx, true, true), gbcp);
        ++gbcp.gridy;
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        gbcp.gridwidth = 3;
        panel.add((Component)Tools.createPanelWithComponent("Carrier<BR>is between ENGAGED</BR><BR> and HANDOFF</BR>", this.engagedPositionSwitch_lfx, true, true, 100), gbcp);
        ++gbcp.gridx;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        gbcp.gridx += 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        return panel;
    }

    public JPanel create_lfyPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent("Loader<BR>Docked", this.loaderDockedDigitalSwitch_lfy, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks NOT<BR>Over Clamped</BR>", this.notOverClampedStatusSwitch_lfy, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Carrier<BR>at HANDOFF</BR>", this.handoffPositionSwitch_lfy, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Filter<BR>Presence</BR>", this.filterPresenceSwitch_lfy, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks<BR>Unclamped</BR>", this.hooksUnclampedStatusSwitch_lfy, false, true, 80), gbcp);
        return panel;
    }

    public JPanel create_lfzPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent("Hooks NOT<BR>Over Clamped</BR>", this.notOverClampedStatusSwitch_lfz, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)this.create_lfzSubpanel(), gbcp);
        return panel;
    }

    public JPanel create_lfzSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        panel.add((Component)Tools.createPanelWithComponent("Loader<BR>Docked", this.loaderDockedDigitalSwitch_lfz, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Carrier<BR>is between ENGAGED</BR><BR> and HANDOFF</BR>", this.engagedPositionSwitch_lfz, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Filter<BR>Not Present</BR>", this.notFilterPresenceSwitch_lfz, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks<BR>Opened</BR>", this.openedSwitch_lfz, false, true), gbcp);
        ++gbcp.gridx;
        ++gbcp.gridy;
        gbcp.gridx = 1;
        gbcp.gridwidth = 4;
        panel.add((Component)Tools.createPanelWithComponent("Carrier<BR>at STORAGE</BR>", this.storagePositionSwitch_lfz, true, true, 190), gbcp);
        gbcp.gridy = 0;
        gbcp.gridx = 5;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        return panel;
    }

    private JPanel create_lfdPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("LFD"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Filter<BR>Not Present</BR>", this.notFilterPresenceSwitch_lfd, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks NOT<BR>Opened</BR>", this.notOpenedSwitch_lfd, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Carrier<BR>NOT at HANDOFF</BR>", this.notHandoffPositionSwitch_lfd, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("LFD Status", this.lfdStatusDiamond, false, false), gbcp);
        return panel;
    }

    private JPanel create_lfsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("LFS"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent("Loader<BR>Docked", this.loaderDockedDigitalSwitch_lfs, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)this.create_lfsSubpanel(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Carrier<BR>NOT at HANDOFF</BR>", this.notHandoffPositionSwitch_lfs, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("Hooks NOT<BR>Closed</BR>", this.notClosedSwitch_lfs, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent("LFS Status", this.lfsStatusDiamond, true, false), gbcp);
        return panel;
    }

    private JPanel create_lfsSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 1;
        panel.add((Component)Tools.createPanelWithComponent("Filter<BR>Position</BR>", this.filterGoodPositionSwitch_lfs, true, true), gbcp);
        ++gbcp.gridy;
        gbcp.gridx = 1;
        panel.add((Component)Tools.createPanelWithComponent("Filter<BR>Presence</BR>", this.filterPresenceSwitch_lfs, true, true), gbcp);
        gbcp.gridy = 0;
        ++gbcp.gridx;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        return panel;
    }

    private static JPanel create_acStatusPanel(DigitalSwitch ap2s, DigitalSwitch af0s, String afName) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("AC Status"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 11;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)Tools.createPanelWithComponent("AP2", ap2s, false, true, 20), gbcp);
        ++gbcp.gridx;
        panel.add((Component)Tools.createPanelWithComponent(afName, af0s, false, true, 20), gbcp);
        return panel;
    }

    private void setDefaultValues() {
        this.digitalList = new DigitalSwitch[]{this.loaderDockedDigitalSwitch_lfc, this.loaderDockedDigitalSwitch_lfs, this.loaderDockedDigitalSwitch_lfu, this.loaderDockedDigitalSwitch_lfx, this.loaderDockedDigitalSwitch_lfy, this.loaderDockedDigitalSwitch_lfz, this.ap2Switch1, this.ap2Switch2, this.ap2Switch3, this.ap2Switch4, this.af0Switch1, this.af0Switch2, this.af3Switch, this.notLockoutSwitch1, this.notLockoutSwitch2, this.engineeringSwitchC, this.engineeringSwitchH, this.filterPresenceSwitch_lfc, this.filterPresenceSwitch_lfd, this.filterPresenceSwitch_lfs, this.filterPresenceSwitch_lfx, this.filterPresenceSwitch_lfy, this.notFilterPresenceSwitch_lfz, this.notFilterPresenceSwitch_lfd, this.engagedPositionSwitch_lfc, this.engagedPositionSwitch_lfx, this.engagedPositionSwitch_lfz, this.handoffPositionSwitch_lfx, this.handoffPositionSwitch_lfy, this.notHandoffPositionSwitch_lfd, this.notHandoffPositionSwitch_lfs, this.storagePositionSwitch_lfz};
        this.diamondList = new DiamondSwitch[]{this.hooksClampedStatusSwitch_lfc, this.hooksUnclampedStatusSwitch_lfc, this.hooksUnclampedStatusSwitch_lfy, this.notUnderClampedStatusSwitch_lfu, this.notOverClampedStatusSwitch_lfc, this.notOverClampedStatusSwitch_lfu, this.notOverClampedStatusSwitch_lfx, this.notOverClampedStatusSwitch_lfy, this.notOverClampedStatusSwitch_lfz, this.hooksClosedSwitch_lfc, this.hooksClosedSwitch_lfx, this.notClosedSwitch_lfd, this.notClosedSwitch_lfs, this.notClosedSwitch_lfu, this.openedSwitch_lfu, this.openedSwitch_lfz, this.notOpenedSwitch_lfd, this.noDefaultStatusDiamond1, this.noDefaultStatusDiamond2, this.noLfsStatusDiamond, this.noLfdStatusDiamond, this.lfdStatusDiamond, this.lfsStatusDiamond, this.filterGoodPositionSwitch_lfc, this.filterGoodPositionSwitch_lfs, this.safetyBeltPresenceSwitch1};
        for (DigitalSwitch digitalSwitch : this.digitalList) {
            digitalSwitch.setColor(Color.gray);
        }
        for (JComponent jComponent : this.diamondList) {
            ((DiamondSwitch)jComponent).setColor(Color.gray);
        }
        this.filterGoodPositionSwitch_lfc.setColor(Color.gray);
        this.filterGoodPositionSwitch_lfs.setColor(Color.gray);
        this.noDefaultStatusDiamond1.setColor(Color.gray);
        this.noDefaultStatusDiamond2.setColor(Color.gray);
        this.safetyBeltPresenceSwitch1.setColor(Color.gray);
        this.safetyBeltPresenceSwitch2.setColor(Color.gray);
        this.carrierRelayRectangle.setColor(Color.gray);
        this.hooksRelayRectangle.setColor(Color.gray);
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    @Override
    public String toString() {
        return "PLC Loader Panel";
    }

    private class UpdateLoader
    implements Runnable {
        private final StatusDataPublishedByLoader s;

        public UpdateLoader(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {
            for (DigitalSwitch ds : new DigitalSwitch[]{PLCLoaderPanel.this.filterPresenceSwitch_lfc, PLCLoaderPanel.this.filterPresenceSwitch_lfd, PLCLoaderPanel.this.filterPresenceSwitch_lfs, PLCLoaderPanel.this.filterPresenceSwitch_lfx, PLCLoaderPanel.this.filterPresenceSwitch_lfy}) {
                ds.updateColor(this.s.isFilterPresenceSensorsInError(), this.s.getFilterPresenceSensorValue());
            }
            PLCLoaderPanel.this.notFilterPresenceSwitch_lfz.updateColor(this.s.isFilterPresenceSensorsInError(), !this.s.getFilterPresenceSensorValue());
            for (DigitalSwitch ds : new DigitalSwitch[]{PLCLoaderPanel.this.loaderDockedDigitalSwitch_lfc, PLCLoaderPanel.this.loaderDockedDigitalSwitch_lfs, PLCLoaderPanel.this.loaderDockedDigitalSwitch_lfu, PLCLoaderPanel.this.loaderDockedDigitalSwitch_lfx, PLCLoaderPanel.this.loaderDockedDigitalSwitch_lfy, PLCLoaderPanel.this.loaderDockedDigitalSwitch_lfz}) {
                ds.updateColor(this.s.isLoaderOnCameraSensorsInError(), this.s.isLoaderOnCameraSensorValue());
            }
            PLCLoaderPanel.this.af0Switch1.updateColor(this.s.isAf0InError(), this.s.isAf0());
            PLCLoaderPanel.this.af0Switch2.updateColor(this.s.isAf0InError(), this.s.isAf0());
            PLCLoaderPanel.this.af3Switch.updateColor(this.s.isAf3InError(), this.s.isAf3());
            PLCLoaderPanel.this.ap2Switch1.updateColor(this.s.isAp2InError(), this.s.isAp2());
            PLCLoaderPanel.this.ap2Switch2.updateColor(this.s.isAp2InError(), this.s.isAp2());
            PLCLoaderPanel.this.ap2Switch3.updateColor(this.s.isAp2InError(), this.s.isAp2());
            PLCLoaderPanel.this.ap2Switch4.updateColor(this.s.isAp2InError(), this.s.isAp2());
            PLCLoaderPanel.this.engineeringSwitchC.updateColor(this.s.isKeyEngInError(), this.s.isKeyEng());
            PLCLoaderPanel.this.engineeringSwitchH.updateColor(this.s.isKeyEngInError(), this.s.isKeyEng());
            PLCLoaderPanel.this.notLockoutSwitch1.updateColor(this.s.isKeyLockInError(), !this.s.isKeyLock());
            PLCLoaderPanel.this.notLockoutSwitch2.updateColor(this.s.isKeyLockInError(), !this.s.isKeyLock());
            PLCLoaderPanel.this.filterGoodPositionSwitch_lfc.setColor(this.s.isFilterPositionStatus() ? Color.GREEN : Color.gray);
            PLCLoaderPanel.this.filterGoodPositionSwitch_lfs.setColor(this.s.isFilterPositionStatus() ? Color.GREEN : Color.gray);
            PLCLoaderPanel.this.noDefaultStatusDiamond1.setColor(this.s.isLoaderDefaultStatus() ? Color.RED : Color.GREEN);
            PLCLoaderPanel.this.noDefaultStatusDiamond2.setColor(this.s.isLoaderDefaultStatus() ? Color.RED : Color.GREEN);
            PLCLoaderPanel.this.safetyBeltPresenceSwitch1.setColor(this.s.isSafetyBeltPresence() ? Color.GREEN : Color.gray);
            PLCLoaderPanel.this.safetyBeltPresenceSwitch2.setColor(this.s.isSafetyBeltPresence() ? Color.GREEN : Color.gray);
            PLCLoaderPanel.this.carrierRelayRectangle.setColor(this.s.isCarrierRelayStatus() ? Color.GREEN : Color.gray);
            PLCLoaderPanel.this.hooksRelayRectangle.setColor(this.s.isHooksRelayStatus() ? Color.GREEN : Color.gray);
            PLCLoaderPanel.this.noLfsStatusDiamond.setColor(this.s.isLfs() ? Color.GREEN : Color.gray);
            PLCLoaderPanel.this.noLfdStatusDiamond.setColor(this.s.isLfd() ? Color.GREEN : Color.gray);
            PLCLoaderPanel.this.lfsStatusDiamond.setColor(this.s.isLfs() ? Color.RED : Color.gray);
            PLCLoaderPanel.this.lfdStatusDiamond.setColor(this.s.isLfd() ? Color.RED : Color.gray);
        }
    }

    private class UpdateClamp
    implements Runnable {
        private final StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        @Override
        public void run() {
            PLCLoaderPanel.this.hooksClosedSwitch_lfc.setColor(this.s.isAllHooksInStateCLOSED() ? Color.GREEN : Color.GRAY);
            PLCLoaderPanel.this.hooksClosedSwitch_lfx.setColor(this.s.isAllHooksInStateCLOSED() ? Color.GREEN : Color.GRAY);
            PLCLoaderPanel.this.openedSwitch_lfu.setColor(this.s.getClampState().equals((Object)FcsEnumerations.LockStatus.OPENED) ? Color.GREEN : Color.GRAY);
            PLCLoaderPanel.this.openedSwitch_lfz.setColor(this.s.getClampState().equals((Object)FcsEnumerations.LockStatus.OPENED) ? Color.GREEN : Color.GRAY);
            PLCLoaderPanel.this.notOpenedSwitch_lfd.setColor(this.s.getClampState().equals((Object)FcsEnumerations.LockStatus.OPENED) ? Color.GRAY : Color.GREEN);
            PLCLoaderPanel.this.notClosedSwitch_lfd.setColor(this.s.isAllHooksInStateCLOSED() ? Color.GRAY : Color.GREEN);
            PLCLoaderPanel.this.notClosedSwitch_lfs.setColor(this.s.isAllHooksInStateCLOSED() ? Color.GRAY : Color.GREEN);
            PLCLoaderPanel.this.notClosedSwitch_lfu.setColor(this.s.isAllHooksInStateCLOSED() ? Color.GRAY : Color.GREEN);
            PLCLoaderPanel.this.hooksClampedStatusSwitch_lfc.setColor(this.s.isForceClampedStatus() ? Color.GREEN : Color.GRAY);
            PLCLoaderPanel.this.hooksUnclampedStatusSwitch_lfc.setColor(this.s.isForceUnclampedStatus() ? Color.GREEN : Color.GRAY);
            PLCLoaderPanel.this.hooksUnclampedStatusSwitch_lfy.setColor(this.s.isForceUnclampedStatus() ? Color.GREEN : Color.GRAY);
            PLCLoaderPanel.this.notOverClampedStatusSwitch_lfc.setColor(this.s.isForceOverClampedStatus() ? Color.RED : Color.GREEN);
            PLCLoaderPanel.this.notOverClampedStatusSwitch_lfu.setColor(this.s.isForceOverClampedStatus() ? Color.RED : Color.GREEN);
            PLCLoaderPanel.this.notOverClampedStatusSwitch_lfx.setColor(this.s.isForceOverClampedStatus() ? Color.RED : Color.GREEN);
            PLCLoaderPanel.this.notOverClampedStatusSwitch_lfy.setColor(this.s.isForceOverClampedStatus() ? Color.RED : Color.GREEN);
            PLCLoaderPanel.this.notOverClampedStatusSwitch_lfz.setColor(this.s.isForceOverClampedStatus() ? Color.RED : Color.GREEN);
            PLCLoaderPanel.this.notUnderClampedStatusSwitch_lfu.setColor(this.s.isForceUnderClampedStatus() ? Color.GRAY : Color.GREEN);
        }
    }

    private class UpdateCarrier
    implements Runnable {
        private final StatusDataPublishedByLoaderCarrier s;

        public UpdateCarrier(StatusDataPublishedByLoaderCarrier status) {
            this.s = status;
        }

        @Override
        public void run() {
            PLCLoaderPanel.this.storagePositionSwitch_lfz.setColor(this.s.isAtStorage() ? Color.GREEN : Color.gray);
            PLCLoaderPanel.this.handoffPositionSwitch_lfy.setColor(this.s.isAtHandoff() ? Color.GREEN : Color.gray);
            PLCLoaderPanel.this.notHandoffPositionSwitch_lfs.setColor(this.s.isAtHandoff() ? Color.gray : Color.GREEN);
            PLCLoaderPanel.this.notHandoffPositionSwitch_lfd.setColor(this.s.isAtHandoff() ? Color.gray : Color.GREEN);
            PLCLoaderPanel.this.engagedPositionSwitch_lfc.setColor(this.s.isEngagedSensorOn() ? Color.GREEN : Color.gray);
            PLCLoaderPanel.this.engagedPositionSwitch_lfx.setColor(this.s.isEngagedSensorOn() ? Color.GREEN : Color.gray);
            PLCLoaderPanel.this.engagedPositionSwitch_lfz.setColor(this.s.isEngagedSensorOn() ? Color.GREEN : Color.gray);
        }
    }
}

