/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.InterfaceAutochangerGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class AutochangerGeneralViewPanel
extends JPanel {
    private static final long serialVersionUID = -713173978095339372L;
    private InterfaceAutochangerGUI subs;
    private final JPanel loaderStatusPanel = new JPanel();
    private final DigitalSwitch loader_LPS_Switch = new DigitalSwitch();
    private final DigitalSwitch loader_LRH_Switch = new DigitalSwitch();
    private final DigitalSwitch carousel_CFC_Switch = new DigitalSwitch();
    private final DigitalSwitch carousel_CS_Switch = new DigitalSwitch();
    private final DigitalSwitch carousel_CF0_Switch = new DigitalSwitch();
    private final DigitalSwitch carousel_CF1_Switch = new DigitalSwitch();
    private final JPanel lockOutPanel = new JPanel();
    private final DigitalSwitch loaderPresenceSwitch = new DigitalSwitch();
    private final DigitalSwitch lockOutSwitch = new DigitalSwitch();
    private final JPanel lpmStatusPanel = new JPanel();
    private final DigitalSwitch enableRailLinMasterSwitch = new DigitalSwitch();
    private final DigitalSwitch enableRailLinFollowerSwitch = new DigitalSwitch();
    private final DigitalSwitch enableClampsSwitch = new DigitalSwitch();
    private final DigitalSwitch enableLatchesSwitch = new DigitalSwitch();
    private final DigitalSwitch engineeringSwitch = new DigitalSwitch();
    private final JPanel latchesStatePanel = new JPanel();
    private final JPanel clampsStatePanel = new JPanel();
    private final FilterPanel filterPanel = new FilterPanel();
    private final JPanel inclinometersPanel = new JPanel();
    private final JPanel carouselStatusPanel = new JPanel();
    private JPanel trucksStatePanel;
    private final DigitalSwitch standbyDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inTravelDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch handoffDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch onlineDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inErrorDigitalSwitch = new DigitalSwitch();
    private final JLabel standbyjLabel = new JLabel("STANDBY");
    private final JLabel inTraveljLabel = new JLabel("In Travel");
    private final JLabel handoffjLabel = new JLabel("HAND-OFF");
    private final JLabel onlinejLabel = new JLabel("ONLINE");
    private final JLabel inErrorjLabel = new JLabel("IN ERROR");
    private final JButton moveAndClampButton = new JButton("moveAndClampFilterOnline");
    private final JButton goToStandbyButton = new JButton("goToStandby");
    private final JButton goToHandoffButton = new JButton("goToHandOff");
    private final JButton goToOnlineButton = new JButton("goToOnline");
    private final JLabel clampsStateLabel = new JLabel();
    private final JLabel latchesStateLabel = new JLabel();
    private final JButton closeLatchesButton = new JButton("Close Latches");
    private final JButton openLatchesButton = new JButton("Open Latches");
    private final JLabel trucksPositionLabel = new JLabel();
    private final JLabel inclXminusLabel = new JLabel();
    private final JLabel inclXplusLabel = new JLabel();
    private final DecimalFormat formatter = new DecimalFormat("00.00");
    private final JPanel clampsPanel = new JPanel();
    private final JButton closeClampsButton = new JButton("Close Clamps");
    private final JButton openClampsButton = new JButton("Open Clamps");

    public AutochangerGeneralViewPanel() {
        this.initComponents();
    }

    public void setSubsystem(InterfaceAutochangerGUI subs) {
        this.subs = subs;
    }

    void initializeGui(ConfigurationInfo configInfo) {
    }

    void updateAutochanger(StatusDataPublishedByAutoChanger s) {
        SwingUtilities.invokeLater(new UpdateAutochanger(s));
    }

    void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        SwingUtilities.invokeLater(new UpdateTrucks(s));
    }

    void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        SwingUtilities.invokeLater(new UpdateLatches(s));
    }

    void updateClamps(StatusDataPublishedByAutochangerThreeClamps s) {
        SwingUtilities.invokeLater(new UpdateClamps(s));
    }

    private void initComponents() {
        this.closeClampsButton.addActionListener(evt -> this.closeButtonActionPerformed(evt));
        this.openClampsButton.addActionListener(evt -> this.openClampsButtonActionPerformed(evt));
        this.closeLatchesButton.addActionListener(evt -> this.closeLatchesButtonActionPerformed(evt));
        this.openLatchesButton.addActionListener(evt -> this.openLatchesButtonActionPerformed(evt));
        this.goToHandoffButton.addActionListener(this::goToHandoffActionPerformed);
        this.goToOnlineButton.addActionListener(this::goToOnlineActionPerformed);
        this.goToStandbyButton.addActionListener(this::goToStandbyActionPerformed);
        this.moveAndClampButton.addActionListener(this::moveAndClampFilterOnlineActionPerformed);
        this.loaderStatusPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA, 6));
        this.loaderStatusPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.anchor = 17;
        gbc0.insets = Tools.insets_std;
        this.loaderStatusPanel.add((Component)new JLabel("Loader_LPS (loader at Storage)"), gbc0);
        ++gbc0.gridy;
        this.loaderStatusPanel.add((Component)new JLabel("Loader_LRH (loader holds filter)"), gbc0);
        gbc0.gridy = 0;
        gbc0.gridx = 1;
        gbc0.anchor = 13;
        this.loaderStatusPanel.add((Component)this.loader_LPS_Switch, gbc0);
        ++gbc0.gridy;
        this.loaderStatusPanel.add((Component)this.loader_LRH_Switch, gbc0);
        this.lockOutPanel.setBorder(BorderFactory.createLineBorder(Color.YELLOW, 6));
        this.lockOutPanel.setLayout(new GridBagLayout());
        gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.insets = Tools.insets_std;
        gbc0.anchor = 17;
        this.lockOutPanel.add((Component)new JLabel("Loader Presence"), gbc0);
        ++gbc0.gridy;
        this.lockOutPanel.add((Component)new JLabel("Lock Out Bay M"), gbc0);
        gbc0.gridx = 1;
        gbc0.gridy = 0;
        gbc0.anchor = 13;
        this.lockOutPanel.add((Component)this.loaderPresenceSwitch, gbc0);
        ++gbc0.gridy;
        this.lockOutPanel.add((Component)this.lockOutSwitch, gbc0);
        this.carouselStatusPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA, 6));
        this.carouselStatusPanel.setLayout(new GridBagLayout());
        gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.insets = Tools.insets_std;
        gbc0.anchor = 17;
        this.carouselStatusPanel.add((Component)new JLabel("Carousel_CFC (filter clamped)"), gbc0);
        ++gbc0.gridy;
        this.carouselStatusPanel.add((Component)new JLabel("Carousel_CS (socket stop at Standby)"), gbc0);
        ++gbc0.gridy;
        this.carouselStatusPanel.add((Component)new JLabel("Carousel_CF0 (no filter)"), gbc0);
        ++gbc0.gridy;
        this.carouselStatusPanel.add((Component)new JLabel("Carousel_CF1 (filter on socket)"), gbc0);
        gbc0.gridx = 1;
        gbc0.gridy = 0;
        gbc0.anchor = 13;
        this.carouselStatusPanel.add((Component)this.carousel_CFC_Switch, gbc0);
        ++gbc0.gridy;
        this.carouselStatusPanel.add((Component)this.carousel_CS_Switch, gbc0);
        ++gbc0.gridy;
        this.carouselStatusPanel.add((Component)this.carousel_CF0_Switch, gbc0);
        ++gbc0.gridy;
        this.carouselStatusPanel.add((Component)this.carousel_CF1_Switch, gbc0);
        Border border = BorderFactory.createLineBorder(Color.BLUE, 6);
        this.lpmStatusPanel.setBorder(BorderFactory.createTitledBorder(border, "Local Protection Module"));
        this.lpmStatusPanel.setLayout(new GridBagLayout());
        gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.insets = Tools.insets_big;
        gbc0.anchor = 17;
        this.lpmStatusPanel.add((Component)new JLabel("Enable Rail Linear1"), gbc0);
        ++gbc0.gridy;
        this.lpmStatusPanel.add((Component)new JLabel("Enable Rail Linear2"), gbc0);
        gbc0.gridx = 1;
        gbc0.gridy = 0;
        gbc0.anchor = 13;
        this.lpmStatusPanel.add((Component)this.enableRailLinMasterSwitch, gbc0);
        ++gbc0.gridy;
        this.lpmStatusPanel.add((Component)this.enableRailLinFollowerSwitch, gbc0);
        gbc0.gridx = 2;
        gbc0.gridy = 0;
        gbc0.anchor = 17;
        this.lpmStatusPanel.add((Component)new JLabel("Enable Clamps"), gbc0);
        ++gbc0.gridy;
        this.lpmStatusPanel.add((Component)new JLabel("Enable Latches"), gbc0);
        gbc0.gridx = 3;
        gbc0.gridy = 0;
        gbc0.anchor = 13;
        this.lpmStatusPanel.add((Component)this.enableClampsSwitch, gbc0);
        ++gbc0.gridy;
        this.lpmStatusPanel.add((Component)this.enableLatchesSwitch, gbc0);
        ++gbc0.gridy;
        gbc0.gridx = 0;
        this.lpmStatusPanel.add((Component)new JLabel("Engineering Key"), gbc0);
        ++gbc0.gridx;
        this.lpmStatusPanel.add((Component)this.engineeringSwitch, gbc0);
        this.latchesStatePanel.setBorder(BorderFactory.createTitledBorder("Latches"));
        this.latchesStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.fill = 2;
        this.latchesStatePanel.add((Component)this.latchesStateLabel, gbc1);
        ++gbc1.gridy;
        this.latchesStatePanel.add((Component)this.closeLatchesButton, gbc1);
        ++gbc1.gridy;
        this.latchesStatePanel.add((Component)this.openLatchesButton, gbc1);
        this.inclinometersPanel.setLayout(new GridBagLayout());
        this.inclinometersPanel.setBorder(BorderFactory.createTitledBorder("Inclinometers"));
        gbc0 = new GridBagConstraints();
        gbc0.insets = Tools.insets_small;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.anchor = 17;
        this.inclinometersPanel.add((Component)new JLabel("InclinometerXminus"), gbc0);
        ++gbc0.gridy;
        gbc0.insets = Tools.insets_small;
        this.inclinometersPanel.add((Component)this.inclXminusLabel, gbc0);
        gbc0.gridy = 0;
        ++gbc0.gridx;
        gbc0.insets = new Insets(1, 48, 1, 1);
        gbc0.anchor = 13;
        this.inclinometersPanel.add((Component)new JLabel("InclinometerXplus"), gbc0);
        ++gbc0.gridy;
        this.inclinometersPanel.add((Component)this.inclXplusLabel, gbc0);
        this.filterPanel.setSize(120);
        this.trucksStatePanel = new JPanel();
        this.trucksStatePanel.setBorder(BorderFactory.createTitledBorder("Trucks State"));
        this.trucksStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = Tools.insets_big;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        this.trucksStatePanel.add((Component)new JLabel("Trucks position:"), gbc2);
        ++gbc2.gridy;
        this.trucksStatePanel.add((Component)this.trucksPositionLabel, gbc2);
        ++gbc2.gridx;
        gbc2.gridy = 0;
        this.trucksStatePanel.add((Component)this.inErrorDigitalSwitch, gbc2);
        ++gbc2.gridy;
        this.trucksStatePanel.add((Component)this.inErrorjLabel, gbc2);
        ++gbc2.gridx;
        gbc2.gridy = 0;
        this.trucksStatePanel.add((Component)this.inTravelDigitalSwitch, gbc2);
        ++gbc2.gridy;
        this.trucksStatePanel.add((Component)this.inTraveljLabel, gbc2);
        ++gbc2.gridx;
        gbc2.gridy = 0;
        this.trucksStatePanel.add((Component)this.standbyDigitalSwitch, gbc2);
        ++gbc2.gridy;
        this.trucksStatePanel.add((Component)this.standbyjLabel, gbc2);
        ++gbc2.gridx;
        gbc2.gridy = 0;
        this.trucksStatePanel.add((Component)this.handoffDigitalSwitch, gbc2);
        ++gbc2.gridy;
        this.trucksStatePanel.add((Component)this.handoffjLabel, gbc2);
        ++gbc2.gridx;
        gbc2.gridy = 0;
        this.trucksStatePanel.add((Component)this.onlineDigitalSwitch, gbc2);
        ++gbc2.gridy;
        this.trucksStatePanel.add((Component)this.onlinejLabel, gbc2);
        gbc2.gridx = 1;
        gbc2.insets = Tools.insets_small;
        gbc2.gridwidth = 5;
        gbc2.fill = 2;
        ++gbc2.gridy;
        this.trucksStatePanel.add((Component)this.moveAndClampButton, gbc2);
        ++gbc2.gridy;
        this.trucksStatePanel.add((Component)this.goToOnlineButton, gbc2);
        ++gbc2.gridy;
        this.trucksStatePanel.add((Component)this.goToHandoffButton, gbc2);
        ++gbc2.gridy;
        this.trucksStatePanel.add((Component)this.goToStandbyButton, gbc2);
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        this.clampsStatePanel.add((Component)new JLabel("LockStatus:"), gbc3);
        ++gbc3.gridx;
        this.clampsStatePanel.add((Component)this.clampsStateLabel, gbc3);
        this.clampsPanel.setLayout(new GridBagLayout());
        this.clampsPanel.setBorder(BorderFactory.createTitledBorder("ONLINE clamps"));
        gbc3 = new GridBagConstraints();
        gbc3.anchor = 23;
        gbc3.fill = 2;
        gbc3.insets = Tools.insets_small;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        this.clampsPanel.add((Component)this.clampsStatePanel, gbc3);
        ++gbc3.gridy;
        this.clampsPanel.add((Component)this.closeClampsButton, gbc3);
        ++gbc3.gridy;
        this.clampsPanel.add((Component)this.openClampsButton, gbc3);
        GridBagConstraints gbc = new GridBagConstraints();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), "AUTOCHANGER General View"));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        gbc.anchor = 512;
        gbc.insets = Tools.insets_big;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.carouselStatusPanel, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 2;
        gbc.anchor = 13;
        this.add((Component)this.loaderStatusPanel, gbc);
        gbc.anchor = 512;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 4;
        this.add((Component)this.lpmStatusPanel, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        this.add((Component)this.lockOutPanel, gbc);
        gbc.anchor = 512;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 4;
        gbc.anchor = 10;
        gbc.fill = 2;
        this.add((Component)this.inclinometersPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.add((Component)this.latchesStatePanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.filterPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.clampsPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridheight = 1;
        gbc.gridwidth = 3;
        gbc.anchor = 512;
        this.add((Component)this.trucksStatePanel, gbc);
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        this.inclXminusLabel.setText("0.0");
        this.inclXplusLabel.setText("0.0");
        this.loader_LPS_Switch.setColor(Color.GRAY);
        this.loader_LRH_Switch.setColor(Color.GRAY);
        this.carousel_CFC_Switch.setColor(Color.GRAY);
        this.carousel_CS_Switch.setColor(Color.GRAY);
        this.carousel_CF0_Switch.setColor(Color.GRAY);
        this.carousel_CF1_Switch.setColor(Color.GRAY);
        this.enableRailLinMasterSwitch.setColor(Color.GRAY);
        this.enableRailLinFollowerSwitch.setColor(Color.GRAY);
        this.enableClampsSwitch.setColor(Color.GRAY);
        this.enableLatchesSwitch.setColor(Color.GRAY);
        this.engineeringSwitch.setColor(Color.GRAY);
        this.loaderPresenceSwitch.setColor(Color.GRAY);
        this.lockOutSwitch.setColor(Color.GRAY);
        this.filterPanel.setIsFilterInHouse(false, "NONE", 0);
        this.filterPanel.setColor(Color.gray);
        this.standbyDigitalSwitch.setColor(Color.gray);
        this.inTravelDigitalSwitch.setColor(Color.gray);
        this.handoffDigitalSwitch.setColor(Color.gray);
        this.onlineDigitalSwitch.setColor(Color.gray);
        this.inErrorDigitalSwitch.setColor(Color.gray);
        this.trucksPositionLabel.setText("0.0");
        this.clampsStateLabel.setText("UNKNOWN STATE");
        this.latchesStateLabel.setText("UNKNOWN STATE");
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    @Override
    public String toString() {
        return "General View";
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.subs.closeOnlineClamps();
    }

    private void openClampsButtonActionPerformed(ActionEvent evt) {
        this.subs.openOnlineClamps();
    }

    private void closeLatchesButtonActionPerformed(ActionEvent evt) {
        this.subs.closeLatches();
    }

    private void openLatchesButtonActionPerformed(ActionEvent evt) {
        this.subs.openLatches();
    }

    private void goToHandoffActionPerformed(ActionEvent evt) {
        this.subs.acGoToHandOff();
    }

    private void goToOnlineActionPerformed(ActionEvent evt) {
        this.subs.acGoToOnline();
    }

    private void goToStandbyActionPerformed(ActionEvent evt) {
        this.subs.acGoToStandby();
    }

    private void moveAndClampFilterOnlineActionPerformed(ActionEvent evt) {
        this.subs.acMoveAndClampFilterOnline();
    }

    public static void main(String[] argv) {
        AutochangerGeneralViewPanel d = new AutochangerGeneralViewPanel();
        JFrame frame = new JFrame("Autochanger GeneralView Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdateClamps
    implements Runnable {
        private StatusDataPublishedByAutochangerThreeClamps s;

        public UpdateClamps(StatusDataPublishedByAutochangerThreeClamps status) {
            this.s = status;
        }

        @Override
        public void run() {
            AutochangerGeneralViewPanel.this.clampsStateLabel.setText(this.s.getLockStatus().toString());
            AutochangerGeneralViewPanel.this.clampsStateLabel.setForeground(this.s.getLockStatus().getColor());
        }
    }

    class UpdateLatches
    implements Runnable {
        private StatusDataPublishedByAutochangerTwoLatches s;

        public UpdateLatches(StatusDataPublishedByAutochangerTwoLatches status) {
            this.s = status;
        }

        @Override
        public void run() {
            AutochangerGeneralViewPanel.this.latchesStateLabel.setText(this.s.getLockStatus().toString());
            AutochangerGeneralViewPanel.this.latchesStateLabel.setForeground(this.s.getLockStatus().getColor());
            AutochangerGeneralViewPanel.this.filterPanel.setIsFilterInHouse(this.s.getFilterPresenceStatus().equals((Object)FcsEnumerations.FilterPresenceStatus.ENGAGED), this.s.getFilterName(), this.s.getFilterId());
            if (this.s.getFilterPresenceStatus().equals((Object)FcsEnumerations.FilterPresenceStatus.UNKNOWN)) {
                AutochangerGeneralViewPanel.this.filterPanel.setColor(Color.YELLOW);
            }
        }
    }

    private class UpdateTrucks
    implements Runnable {
        private StatusDataPublishedByAutoChangerTrucks s;

        public UpdateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
            this.s = status;
        }

        @Override
        public void run() {
            AutochangerGeneralViewPanel.this.trucksPositionLabel.setText(String.valueOf(this.s.getDriverPosition()));
            AutochangerGeneralViewPanel.this.handoffDigitalSwitch.setColor(this.s.isAtHandoff() ? Tools.greenColor : Color.gray);
            AutochangerGeneralViewPanel.this.onlineDigitalSwitch.setColor(this.s.isAtOnline() ? Tools.greenColor : Color.gray);
            AutochangerGeneralViewPanel.this.standbyDigitalSwitch.setColor(this.s.isAtStandby() ? Tools.greenColor : Color.gray);
            AutochangerGeneralViewPanel.this.inErrorDigitalSwitch.setColor(this.s.isInError() ? Color.RED : Tools.greenColor);
            AutochangerGeneralViewPanel.this.inErrorjLabel.setText(this.s.isInError() ? "IN ERROR" : "NO ERROR");
            AutochangerGeneralViewPanel.this.inTravelDigitalSwitch.setColor(!this.s.isAtHandoff() && !this.s.isAtOnline() && !this.s.isAtStandby() ? Color.YELLOW : Color.gray);
        }
    }

    private class UpdateAutochanger
    implements Runnable {
        private StatusDataPublishedByAutoChanger s;

        public UpdateAutochanger(StatusDataPublishedByAutoChanger status) {
            this.s = status;
        }

        @Override
        public void run() {
            AutochangerGeneralViewPanel.this.loader_LPS_Switch.updateColor(this.s.isLoaderConnectedSensorsInError(), this.s.getLoaderConnectedSensorValue());
            AutochangerGeneralViewPanel.this.loader_LRH_Switch.updateColor(false, this.s.isLoaderHoldingFilterAtHandoff());
            AutochangerGeneralViewPanel.this.inclXminusLabel.setText(AutochangerGeneralViewPanel.this.formatter.format(this.s.getInclinaisonXminus()));
            AutochangerGeneralViewPanel.this.inclXplusLabel.setText(AutochangerGeneralViewPanel.this.formatter.format(this.s.getInclinaisonXplus()));
            AutochangerGeneralViewPanel.this.carousel_CFC_Switch.updateColor(this.s.isCarouselHoldingFilterInError(), this.s.isCarouselHoldingFilter());
            AutochangerGeneralViewPanel.this.carousel_CS_Switch.updateColor(this.s.isCarousel_CS_InError(), this.s.isCarousel_CS());
            AutochangerGeneralViewPanel.this.carousel_CF0_Switch.updateColor(this.s.isCarousel_CF0_InError(), this.s.isCarousel_CF0());
            AutochangerGeneralViewPanel.this.carousel_CF1_Switch.updateColor(this.s.isCarousel_CF1_InError(), this.s.isCarousel_CF1());
            AutochangerGeneralViewPanel.this.enableRailLinMasterSwitch.updateColor(false, this.s.isEnableRailLin1());
            AutochangerGeneralViewPanel.this.enableRailLinFollowerSwitch.updateColor(false, this.s.isEnableRailLin2());
            AutochangerGeneralViewPanel.this.enableClampsSwitch.updateColor(false, this.s.isEnableClamps());
            AutochangerGeneralViewPanel.this.enableLatchesSwitch.updateColor(false, this.s.isEnableLatches());
            AutochangerGeneralViewPanel.this.engineeringSwitch.updateColor(this.s.isEngineeringKey_InError(), this.s.isEngineeringKey());
            AutochangerGeneralViewPanel.this.loaderPresenceSwitch.updateColor(this.s.isLoaderPresenceInError(), this.s.isLoaderPresence());
            AutochangerGeneralViewPanel.this.lockOutSwitch.updateColor(this.s.isLockOutInError(), this.s.isLockOut());
        }
    }
}

