
package org.lsst.ccs.subsystems.fcs.loader.ui;

import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalProgressBarPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import static org.lsst.ccs.subsystems.fcs.FCSCst.UNKNOWN;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.BIG_FONT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.UNKNOWN_STATE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_big;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 *
 * @author virieux
 */
public class LoaderClampPanel extends JPanel {

    private static final long serialVersionUID = -6313746913674371727L;
    private final String fullPathClampName;
    private InterfaceLoaderGUI subs;

    private final JLabel clampState = new JLabel();
    private final JLabel clampStateLabel = new JLabel("Hooks State :");
    private final JLabel xMinusLabel = new JLabel("X-");
    private final JLabel xMinuxLabel2 = new JLabel("X-");
    private final JLabel xPlusLabel = new JLabel("X+");
    private final JLabel xPlusLabel2 = new JLabel("X+");
    private final DecimalFormat formatter = new DecimalFormat("00");

    /* Force Sensors Panel*/
    private final JLabel forceSensor0Label = new JLabel();
    private final JLabel forceSensor1Label = new JLabel();
    private final DigitalSwitch forceClampedStatusSwitch = new DigitalSwitch();
    private final DigitalSwitch forceUnclampedStatusSwitch = new DigitalSwitch();
    private final DigitalSwitch forceUnderClampedStatusSwitch = new DigitalSwitch();
    private final DigitalSwitch forceOverClampedStatusSwitch = new DigitalSwitch();
    private final JLabel forceStatusLabel = new JLabel();
    private final JLabel minClampedVoltageLabel = new JLabel();

    /* Homing panel */
    private final JPanel homingPanel = new JPanel();
    private final JLabel homLabel = new JLabel("Homing of the hooks controller:");
    private final JLabel homingLabel = new JLabel();

    /* Good Filter Position panel */
    private final JPanel goodFilterPositionPanel = new JPanel();
    private final DigitalSwitch goodFilterPositionSwitch = new DigitalSwitch();
    private final JLabel filterDistanceLabel = new JLabel();

    private LoaderHookPanel hookPanel1;
    private LoaderHookPanel hookPanel2;
    private LoaderHookPanel hookPanel3;
    private LoaderHookPanel hookPanel4;
    private final JPanel forceSensorPanel = new JPanel();
    private final FilterPanel filterPanel = new FilterPanel();
    private VerticalProgressBarPanel positionProgressBarPanel;
    private VerticalProgressBarPanel currentProgressBarPanel;
    private JButton closeHooksButton;
    private JButton openHooksButton;
    private JButton unclampHooksPositionButton;
    private JButton clampHooksButton;
    private JButton updateStateWithSensorsButton;
    private JButton abortButton;
    // End of variables declaration



    /**
     * A Runnable to initialize this panel from configuration data.
     */
    private class GuiInitialization implements Runnable {

        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            /** Retrieve the configuration data for my name.*/
            Map<String, String> configForClamp = configInfo.getCurrentValuesFor(fullPathClampName);
            positionProgressBarPanel.setMinValue(0);
            positionProgressBarPanel.setMaxValue(Tools.toInt(configForClamp,"absolutePositionToClose"));
            positionProgressBarPanel.setValue(0);
            currentProgressBarPanel.setMinValue(Tools.toInt(configForClamp,"currentToOpen"));
            currentProgressBarPanel.setMaxValue(Tools.toInt(configForClamp,"currentToClamp"));
            currentProgressBarPanel.setValue(0);

            minClampedVoltageLabel.setText(configForClamp.get("minClampedVoltage"));

            /** Initialization of the timeouts for the buttons commands.*/
            subs.setOpenHooksTimeout(Tools.toInt(configForClamp,"timeoutForOpeningHooks"));
            subs.setCloseHooksTimeout(Tools.toInt(configForClamp,"timeoutForClosingHooks"));
            subs.setClampHooksTimeout(Tools.toInt(configForClamp,"timeoutForClampingHooks"));
        }
    }

    /**
     * A Runnable to update this panel from data published on the status bus from the Loader Clamp.
     */
    private class UpdateClamp implements Runnable {

        private final StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        @Override
        public void run() {

            Color clampStateColor = s.getClampState().getColor();
            int clampPosition = s.getPosition();
            clampState.setText(s.getClampState().getText());
            clampState.setForeground(clampStateColor);
            positionProgressBarPanel.setValue(clampPosition);
            positionProgressBarPanel.setColor(clampStateColor);
            currentProgressBarPanel.setValue(s.getCurrent());
            hookPanel1.updateHook(s.getStatusPublishedByHook1());
            hookPanel2.updateHook(s.getStatusPublishedByHook2());
            hookPanel3.updateHook(s.getStatusPublishedByHook3());
            hookPanel4.updateHook(s.getStatusPublishedByHook4());
            forceSensor0Label.setText(formatter.format(s.getForceSensorVoltage0()));
            forceSensor1Label.setText(formatter.format(s.getForceSensorVoltage1()));
            forceStatusLabel.setText(s.getForceStatus().toString());

            if (s.isForceClampedStatus()) {
                forceClampedStatusSwitch.setColor(greenColor);
            } else {
                forceClampedStatusSwitch.setColor(Color.GRAY);
            }
            if (s.isForceUnclampedStatus()) {
                forceUnclampedStatusSwitch.setColor(greenColor);
            } else {
                forceUnclampedStatusSwitch.setColor(Color.GRAY);
            }
            if (s.isForceOverClampedStatus()) {
                forceOverClampedStatusSwitch.setColor(Color.RED);
            } else {
                forceOverClampedStatusSwitch.setColor(Color.GRAY);
            }
            if (s.isForceUnderClampedStatus()) {
                forceUnderClampedStatusSwitch.setColor(Color.ORANGE);
            } else {
                forceUnderClampedStatusSwitch.setColor(Color.GRAY);
            }
            if (s.isHomingDone()) {
                homingLabel.setText("DONE");
                homingLabel.setForeground(greenColor);
            } else {
                homingLabel.setText("NOT DONE");
                homingLabel.setForeground(Color.red);
            }
        }
    }

    /**
     * A Runnable to update this panel from data published on the status bus from the Loader.
     */
    private class UpdateFilterPanel implements Runnable {

        private final StatusDataPublishedByLoader s;

        public UpdateFilterPanel(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (s.isFilterPresenceSensorsInError()) {
                filterPanel.setColor(Color.red);
            } else {
                filterPanel.setIsFilterInHouse(s.getFilterPresenceSensorValue(), "", 0);
            }
            goodFilterPositionSwitch.setColor(s.isFilterPositionStatus() ? greenColor : Color.gray);
            filterDistanceLabel.setText(Integer.toString(s.getFilterDistance()));

        }

    }

    /**
     * Creates new form LoaderClampPanel
     * @param clampName
     */
    public LoaderClampPanel(String clampName) {
        this.fullPathClampName = clampName;
        initComponents();
    }

    public void setSubsystem(InterfaceLoaderGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo config) {
        SwingUtilities.invokeLater(new GuiInitialization(config));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateClamp(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new UpdateFilterPanel(status));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     */
    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {

        //X- and X+ label
        Font xFont = new Font("Tahoma", 1, 18);
        xMinusLabel.setFont(xFont); // NOI18N
        xMinuxLabel2.setFont(xFont); // NOI18N
        xPlusLabel2.setFont(xFont); // NOI18N
        xPlusLabel.setFont(xFont); // NOI18N
        JPanel hooksPanel = new JPanel();
        JPanel clampStatePanel = new JPanel();
        JPanel controlPanel = new JPanel();
        hookPanel1 = new LoaderHookPanel("hook1");
        hookPanel2 = new LoaderHookPanel("hook2");
        hookPanel3 = new LoaderHookPanel("hook3");
        hookPanel4 = new LoaderHookPanel("hook4");

        currentProgressBarPanel = new VerticalProgressBarPanel("Current", -300, 500, 0, 1);
        currentProgressBarPanel.setStringPainted(false);
        positionProgressBarPanel = new VerticalProgressBarPanel("Position", 5000, 480000, 0, 1);


        updateStateWithSensorsButton = new JButton("Read sensors and update state");
        openHooksButton = new JButton("Open and Homing");
        clampHooksButton = new JButton("Clamp");
        closeHooksButton = new JButton("Close");
        unclampHooksPositionButton = new JButton("Unclamp");
        abortButton = new JButton("Abort");

        updateStateWithSensorsButton.addActionListener((ActionEvent evt) ->
            updateStateWithSensorsButtonActionPerformed(evt)
        );

        openHooksButton.addActionListener((ActionEvent evt) ->
            openHooksButtonActionPerformed(evt)
        );

        clampHooksButton.addActionListener((ActionEvent evt) ->
            clampHooksButtonActionPerformed(evt)
        );

        closeHooksButton.addActionListener((ActionEvent evt) ->
            closeHooksButtonActionPerformed(evt)
        );

        unclampHooksPositionButton.addActionListener((ActionEvent evt) ->
            unclampHooksButtonActionPerformed(evt)
        );

        abortButton.addActionListener((ActionEvent evt) ->
            abortActionPerformed(evt)
        );


        /**
         ******************************************************************************
         ** Clamp State Panel
         * *****************************************************************************
         */
        clampState.setFont(BIG_FONT); // NOI18N
        clampState.setBorder(javax.swing.BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(255, 255, 255)));
        clampStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        clampStatePanel.add(clampStateLabel, gbc2);
        gbc2.gridx++;
        clampStatePanel.add(clampState, gbc2);
        /**
         ******************************************************************************
         ** end of Clamp State Panel
         * *****************************************************************************
         */

        /**
         * minClampedVoltagePanel
         */
        JPanel minClampedPanel = new JPanel();
        minClampedPanel.setLayout(new GridBagLayout());
        minClampedPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.LINE_START;
        gbc.gridwidth = 2;
        JLabel label = new JLabel("CLAMPED if voltage >= minClampedVoltage");
        label.setFont(BIG_FONT);
        minClampedPanel.add(label, gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy++;
        minClampedPanel.add(new JLabel("minClampedVoltage:"), gbc);
        gbc.gridx++;
        minClampedPanel.add(minClampedVoltageLabel, gbc);

        /**
         ******************************************************************************
         ** Force Sensor Panel
        ******************************************************************************
        */
        forceSensorPanel.setLayout(new GridBagLayout());
        forceSensorPanel.setBorder(BorderFactory.createTitledBorder(
        BorderFactory.createLineBorder(Color.BLUE,1), "Force Sensors"));
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.insets = insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        gbc4.gridheight = 2;
        forceSensorPanel.add(minClampedPanel, gbc4);
        gbc4.gridheight = 1;
        gbc4.gridx++;

        /*first force sensor*/
        forceSensorPanel.add(new JLabel("ForceSensor0 voltage:"), gbc4);
        gbc4.gridx++;
        gbc4.anchor = GridBagConstraints.LINE_END;
        forceSensor0Label.setFont(BIG_FONT);
        forceSensorPanel.add(forceSensor0Label,gbc4);
        /* 2nd force sensor*/
        gbc4.gridx--;
        gbc4.gridy++;
        gbc4.anchor = GridBagConstraints.LINE_START;
        forceSensorPanel.add(new JLabel("ForceSensor1 voltage:"), gbc4);
        gbc4.gridx++;
        gbc4.anchor = GridBagConstraints.LINE_END;
        forceSensor1Label.setFont(BIG_FONT);
        forceSensorPanel.add(forceSensor1Label,gbc4);

        /* unclamped status*/
        gbc4.gridx = 4;
        gbc4.gridy = 0;
        gbc4.anchor = GridBagConstraints.CENTER;
        gbc4.insets = new Insets(1,12,1,1);
        forceSensorPanel.add(forceUnclampedStatusSwitch,gbc4);
        gbc4.gridy++;
        forceSensorPanel.add(new JLabel("<HTML><CENTER>Unclamped<br>Status</CENTER></HTML>"),gbc4);

        /* underclamped status*/
        gbc4.gridx++;
        gbc4.gridy = 0;
        forceSensorPanel.add(forceUnderClampedStatusSwitch,gbc4);
        gbc4.gridy++;
        forceSensorPanel.add(new JLabel("<HTML><CENTER>UnderClamped<br>Status</CENTER></HTML>"),gbc4);

        /* clamped status*/
        gbc4.gridx++;
        gbc4.gridy = 0;
        forceSensorPanel.add(forceClampedStatusSwitch,gbc4);
        gbc4.gridy++;
        forceSensorPanel.add(new JLabel("<HTML><CENTER>Clamped<br>Status</CENTER></HTML>"),gbc4);

        /* overclamped status*/
        gbc4.gridx++;
        gbc4.gridy = 0;
        forceSensorPanel.add(forceOverClampedStatusSwitch,gbc4);
        gbc4.gridy++;
        forceSensorPanel.add(new JLabel("<HTML><CENTER>OverClamped<br>Status</CENTER></HTML>"),gbc4);

        /* forceSensorStatus*/
        gbc4.gridx++;
        gbc4.gridy = 0;
        forceSensorPanel.add(new JLabel("Force Status"),gbc4);
        gbc4.gridy++;
        forceSensorPanel.add(forceStatusLabel,gbc4);
        forceStatusLabel.setFont(BIG_FONT);
        /**
         ******************************************************************************
         ** end of Force Sensor Panel
        ******************************************************************************
        */

        /**********************/
        /* Homing Panel       */
        /**********************/
        homingPanel.setBorder(BorderFactory.createLineBorder(Color.ORANGE, 2));
        homingPanel.setLayout(new GridBagLayout());
        homingLabel.setFont(BIG_FONT);
        GridBagConstraints gbc6 = new GridBagConstraints();
        gbc6.insets = insets_big;
        gbc6.gridx = 0;
        gbc6.gridy = 0;
        homingLabel.setFont(BIG_FONT);
        homingPanel.add(homLabel, gbc6);
        gbc6.gridx++;
        homingPanel.add(homingLabel, gbc6);
        /**********************/
        /* end of Homing Panel*/
        /**
         * *******************
         */

        /**
         * ***************************
         */
        /* Good Filter Position Panel */
        /**
         * ***************************
         */
        goodFilterPositionPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA, 2));
        goodFilterPositionPanel.setLayout(new GridBagLayout());
        gbc2 = new GridBagConstraints();
        gbc2.insets = insets_big;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.anchor = GridBagConstraints.BASELINE_LEADING;
        goodFilterPositionPanel.add(new JLabel("Filter Position:"), gbc2);
        gbc2.gridx++;
        gbc2.anchor = GridBagConstraints.BASELINE_TRAILING;
        goodFilterPositionPanel.add(goodFilterPositionSwitch, gbc2);
        gbc2.gridx++;
        gbc2.anchor = GridBagConstraints.BASELINE_LEADING;
        goodFilterPositionPanel.add(new JLabel("  Filter Distance:"));
        gbc2.gridx++;
        gbc2.anchor = GridBagConstraints.BASELINE_TRAILING;
        goodFilterPositionPanel.add(filterDistanceLabel);
        /**
         * **********************************
         */
        /* end of Good Filter Position Panel*/
        /**
         * ***********************************
         */


        /**
         ******************************************************************************
         ** Hooks Panel
         * *****************************************************************************
         */
        hooksPanel.setLayout(new GridBagLayout());
        hooksPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.ORANGE), "Hooks State"));
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = insets_std;

        hookPanel1.setHookLocation(LoaderHookPanel.LEFT);
        hookPanel2.setHookLocation(LoaderHookPanel.LEFT);
        hookPanel3.setHookLocation(LoaderHookPanel.LEFT);
        hookPanel4.setHookLocation(LoaderHookPanel.LEFT);

        gbc1.gridx = 0;
        gbc1.gridy = 0;
        hooksPanel.add(hookPanel2, gbc1);

        gbc1.gridx = 1;
        gbc1.gridy = 0;
        hooksPanel.add(hookPanel1, gbc1);

        gbc1.gridx = 0;
        gbc1.gridy = 1;
        hooksPanel.add(hookPanel4, gbc1);

        gbc1.gridx = 1;
        gbc1.gridy = 1;
        hooksPanel.add(hookPanel3, gbc1);
        /**
         ******************************************************************************
         ** End of Hooks Panel
         * *****************************************************************************
         */

        /**
         ******************************************************************************
         ** Control Panel
         * *****************************************************************************
         */
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc3.fill = GridBagConstraints.HORIZONTAL;
        gbc3.insets = insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        controlPanel.add(updateStateWithSensorsButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(openHooksButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(closeHooksButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(clampHooksButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(unclampHooksPositionButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(abortButton, gbc3);
        /**
         ******************************************************************************
         ** End of Control Panel
         * *****************************************************************************
         */

        /**
         ******************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        setBorder(javax.swing.BorderFactory.createTitledBorder("LOADER HOOKS"));
        setLayout(new java.awt.GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.WEST;

        gbc.insets = insets_std;

        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        add(homingPanel, gbc);
        gbc.gridx = 1;
        add(goodFilterPositionPanel, gbc);

        gbc.gridx = 0;
        gbc.gridy++;
        gbc.anchor = GridBagConstraints.WEST;
        add(xMinusLabel, gbc);
        gbc.anchor = GridBagConstraints.EAST;
        gbc.fill = GridBagConstraints.NONE;
        gbc.gridx = 3;
        add(xPlusLabel, gbc);

        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.anchor = GridBagConstraints.CENTER;
        add(clampStatePanel, gbc);
        gbc.anchor = GridBagConstraints.WEST;
        gbc.gridy++;

        add(hooksPanel, gbc);
        gbc.gridy++;
        gbc.gridwidth = 4;
        add(forceSensorPanel, gbc);
        gbc.insets = new Insets(14, 30, 6, 30);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy++;
        add(positionProgressBarPanel, gbc);
        gbc.gridx++;
        add(currentProgressBarPanel, gbc);
        gbc.gridx++;
        gbc.anchor = GridBagConstraints.CENTER;
        add(filterPanel, gbc);
        gbc.gridx++;

        gbc.anchor = GridBagConstraints.EAST;
        add(controlPanel, gbc);

        setDefaultValues();


    }// </editor-fold>

    /**
     * Initialization to be done when Loader subsystem is not yet booted or is shutdown.
     */
    private void setDefaultValues() {
        filterPanel.setColor(Color.gray);
        clampState.setText(UNKNOWN_STATE);
        forceSensor0Label.setText(Integer.toString(99));
        forceSensor1Label.setText(Integer.toString(99));
        forceClampedStatusSwitch.setColor(Color.gray);
        forceUnclampedStatusSwitch.setColor(Color.gray);
        forceUnderClampedStatusSwitch.setColor(Color.gray);
        forceOverClampedStatusSwitch.setColor(Color.gray);
        forceStatusLabel.setText(UNKNOWN);
        homingLabel.setText("TO BE DONE");
        homingLabel.setForeground(Color.red);
        positionProgressBarPanel.setValue(0);
        positionProgressBarPanel.setColor(Color.gray);
        currentProgressBarPanel.setValue(0);
        goodFilterPositionSwitch.setColor(Color.gray);
        filterDistanceLabel.setText(UNKNOWN);
        minClampedVoltageLabel.setText("0");
    }

    /**
     * Reset components to default values.
     */
    public void resetPanel() {
        setDefaultValues();
        hookPanel1.resetPanel();
        hookPanel2.resetPanel();
        hookPanel3.resetPanel();
        hookPanel4.resetPanel();
    }

    private void updateStateWithSensorsButtonActionPerformed(java.awt.event.ActionEvent evt) {
        subs.updateStateWithSensors();
    }

    private void openHooksButtonActionPerformed(ActionEvent evt) {
        subs.loOpenHooks();
    }

    private void closeHooksButtonActionPerformed(ActionEvent evt) {
        subs.loCloseHooks();
    }

    private void clampHooksButtonActionPerformed(ActionEvent evt) {
        subs.loClampHooks();
    }

    private void unclampHooksButtonActionPerformed(ActionEvent evt) {
        subs.loUnclampHooks();
    }

    private void abortActionPerformed(ActionEvent evt) {
        subs.abortAction();
    }


    @Override
    public String toString() {
        return "Hooks Panel";
    }

    public static void main(String[] argv) {

        LoaderClampPanel d = new LoaderClampPanel("myClamp");
        JFrame frame = new JFrame("New Loader Clamp Panel");
        d.currentProgressBarPanel.setValueName("Current");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
