package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Path2D;
import javax.swing.JComponent;
import javax.swing.JFrame;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;

/**
 *
 * @author virieux
 */
public class DiamondSwitch extends JComponent {
    
    private int size = 25;
    
    private Color color = new Color(0, 153, 0);
    
    /**
     * A diamond 
     */
    public class Diamond extends Path2D.Double {
        
        public Diamond(double size) {
            moveTo(0, size / 2);
            lineTo(size / 2, 0);
            lineTo(size, size / 2);
            lineTo(size / 2, size);
            closePath();
        }
    }
    
    /**
     * Creates new form DiamondSwitch
     */
    public DiamondSwitch() {
        super.setPreferredSize(new Dimension(size, size));
    }
    
    /**
     * Change the size of the DigitalSwitch
     * @param size
     */
    public void setSize(int size) {
        this.size = size;
        super.setPreferredSize(new Dimension(size, size));
    }
    
    public void setColor(Color c) {
        this.color = c;
        repaint();
    }

    /**
     * updates color of a diamond switch Uses when a diamond switch represents a
     * sensors.
     *
     * If the sensor is in error, color is set to RED. If sensor is not in
     * error, and its value is 1, color is set to GREEN. If its value is zero
     * it's set to GRAY.
     *
     * @param sensorInError
     * @param sensorValue
     */
    public void updateColor(boolean sensorInError, boolean sensorValue) {
        if (sensorInError) {
                setColor(Color.RED);
        } else {
                setColor(sensorValue ? greenColor : Color.gray);
        }
    }
    
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D) g.create();
        Shape diamond = new Diamond(size);
        g2d.setColor(color);
        g2d.fill(diamond);
        g2d.setColor(Color.BLACK);
        g2d.draw(diamond);
        g2d.dispose();
    }

    /**
     * for tests
     *
     * @param argv
     */
    public static void main(String[] argv) {

        DiamondSwitch d = new DiamondSwitch();
        JFrame frame = new JFrame();
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
    
}
