
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAccelerometer;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.NICE_PINK;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.resetTable;

/**
 * A panel to display values published by accelerometer.
 *
 * @author virieux
 */
public class AcceleroPanel extends JPanel {

    private JTable accelTable;
    private JScrollPane jScrollPane;

    private final DecimalFormat formatter = new DecimalFormat("#####0.00");

    /**
     * Creates a new AcceleroPanel and initialize all its components.
     */
    public AcceleroPanel() {
        initComponents();
    }

    private class UpdateAccelero implements Runnable {

        private StatusDataPublishedByAccelerometer s;

        public UpdateAccelero(StatusDataPublishedByAccelerometer status) {
            this.s = status;
        }

        @Override
        public void run() {
            DefaultTableModel filterTableModel = (DefaultTableModel) accelTable.getModel();
            accelTable.setValueAt(formatter.format(s.getAngularVelocityX()), 0, 1);
            accelTable.setValueAt(formatter.format(s.getAngularVelocityY()), 0, 2);
            accelTable.setValueAt(formatter.format(s.getAngularVelocityZ()), 0, 3);
            accelTable.setValueAt(formatter.format(s.getAccelerationX()), 1, 1);
            accelTable.setValueAt(formatter.format(s.getAccelerationY()), 1, 2);
            accelTable.setValueAt(formatter.format(s.getAccelerationZ()), 1, 3);
            filterTableModel.fireTableDataChanged();
        }
    }

    public void updateAccelero(StatusDataPublishedByAccelerometer s) {
        SwingUtilities.invokeLater(new UpdateAccelero(s));
    }

    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description">
    private void initComponents() {

        /**
         ******************************************************************************
         ** Accelero Table
         * *****************************************************************************
         */
        jScrollPane = new JScrollPane();
        accelTable = new JTable();
        accelTable.setModel(new DefaultTableModel(
                new Object[][]{},
                new String[]{
                    "", "X AXE", "Y AXE", "Z AXE"
                }
        ) {
            private static final long serialVersionUID = -6158042587124966771L;
            private final Class[] types = new Class[]{
                String.class, Integer.class, Integer.class, Integer.class
            };
            private final boolean[] canEdit = new boolean[]{
                false, false, false, false};

            @Override
            public Class getColumnClass(int columnIndex) {
                return types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit[columnIndex];
            }
        });
        accelTable.setName("accelTable");
        /* First column initialization */
        DefaultTableModel accelTableModel = (DefaultTableModel) accelTable.getModel();
        Object[] row1 = {"ANGULAR VELOCITY", 0, 0, 0};
        accelTableModel.addRow(row1);
        Object[] row2 = {"ACCELERATION", 0, 0, 0};
        accelTableModel.addRow(row2);
        accelTableModel.fireTableDataChanged();
        
        /* column size*/ 
        TableColumn column;
        int rowNB = accelTable.getModel().getRowCount();
        for (int i = 0; i < rowNB; i++) {
            column = accelTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(150); //first column is bigger
            }
        }
        jScrollPane.setPreferredSize(new java.awt.Dimension(500, 60));
        jScrollPane.setViewportView(accelTable);

        /**
         ******************************************************************************
         ** end of Values Table
         * *****************************************************************************
         */
        //Whole Panel
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(NICE_PINK),"Back Flange Accelerometer"));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();

        gbc.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(jScrollPane, gbc);
    }
    
    /**
     * Remove data on panel.
     * To be used when subsystem is disconnecting.
     */
    public void resetPanel() {
        resetTable(accelTable);
    }

    /**
     * Just for tests.
     *
     * @param argv
     */
    public static void main(String[] argv) {

        AcceleroPanel p = new AcceleroPanel();

        JFrame frame = new JFrame("Accelero Values");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
}
