
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderHook;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.UNKNOWN_STATE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;

/**
 *
 * @author virieux
 */
public class LoaderHookPanel extends JPanel {

    protected static final int LEFT = 0, RIGHT = 1;
    private static final long serialVersionUID = 6930078848107595811L;

    private final String hookName;

    // Variables declaration
    private DigitalSwitch hookError;
    private JLabel hookErrorLabel;
    private DigitalSwitch hookLockSensor;
    private JLabel hookLockStatus;
    private JLabel hookNameLabel;
    private DigitalSwitch hookUnlockSensor;
    private JLabel jLabel1;
    private JLabel jLabel2;
    // End of variables declaration

    /**
     * Creates new form LoaderMainPanel
     * @param hookName
     */
    public LoaderHookPanel(String hookName) {
        this.hookName = hookName;
        initComponents();
    }


    // if we want to inverse the display of the hook for the hooks displayed on the right,
    // we have to do : setHookLocation(RIGHT)
    protected void setHookLocation(int pos) {
        switch (pos) {
            case 1:
                GridBagLayout layout = (GridBagLayout) getLayout();

                // Move the label to the right by two places
                GridBagConstraints hookNameConst = layout.getConstraints(hookNameLabel);
                hookNameConst.gridx = hookNameConst.gridx + 2;
                layout.setConstraints(hookNameLabel, hookNameConst);

                // Move the locked sensor to the left by two spaces
                GridBagConstraints lockedSensorConst = layout.getConstraints(hookLockSensor);
                lockedSensorConst.gridx = lockedSensorConst.gridx - 2;
                layout.setConstraints(hookLockSensor, lockedSensorConst);
                break;

            case 0:
                break;
        }
    }

    public void updateHook(StatusDataPublishedByLoaderHook statusDataPublishedByLoaderHook) {
        SwingUtilities.invokeLater(new UpdateHook(statusDataPublishedByLoaderHook));
    }

    /**
     * A Runnable to update this panel from data published on the STATUS bus by a Loader Hook.
     */
    private class UpdateHook implements Runnable {

        private final StatusDataPublishedByLoaderHook s;

        public UpdateHook(StatusDataPublishedByLoaderHook statusDataPublishedByLoaderHook) {
            this.s = statusDataPublishedByLoaderHook;
        }

        @Override
        public void run() {
            hookNameLabel.setText(hookName);
            hookUnlockSensor.setColor(s.getUnlockSensorValue()  ? greenColor : Color.gray);
            hookLockSensor.setColor(s.getLockSensorValue()  ? greenColor : Color.gray);
            boolean inTravel = (!s.getUnlockSensorValue() ) && (!s.getLockSensorValue());
            if (s.isInError()) {
                hookError.setColor(Color.RED);
                hookErrorLabel.setText("IN ERROR");
            } else if (inTravel) {
                hookError.setColor(Color.YELLOW);
                hookErrorLabel.setText("IN TRAVEL");
            } else if (s.getLockStatus().equals(LockStatus.UNKNOWN)) {
                hookError.setColor(Color.DARK_GRAY);
                hookErrorLabel.setText("UNKNOWN");
            } else {
                hookError.setColor(Color.GREEN);
                hookErrorLabel.setText("NO ERROR");
            }
            hookLockStatus.setText(s.getLockStatus().toString());
            Color hookLockStatusColor = s.getLockStatus().getColor();
            hookLockStatus.setBackground(hookLockStatusColor);
        }
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints;

        hookNameLabel = new JLabel();
        hookUnlockSensor = new org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch();
        hookLockSensor = new org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch();
        jLabel1 = new JLabel();
        jLabel2 = new JLabel();
        hookError = new org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch();
        hookErrorLabel = new JLabel();
        hookLockStatus = new JLabel();

        setBorder(BorderFactory.createEtchedBorder());
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());

        hookNameLabel.setText("hook1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 14;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        add(hookNameLabel, gridBagConstraints);

        GroupLayout hookUnlockSensorLayout = new GroupLayout(hookUnlockSensor);
        hookUnlockSensor.setLayout(hookUnlockSensorLayout);
        hookUnlockSensorLayout.setHorizontalGroup(
                hookUnlockSensorLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
                .addGap(0, 23, Short.MAX_VALUE)
        );
        hookUnlockSensorLayout.setVerticalGroup(
                hookUnlockSensorLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
                .addGap(0, 23, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        add(hookUnlockSensor, gridBagConstraints);

        GroupLayout hookLockSensorLayout = new GroupLayout(hookLockSensor);
        hookLockSensor.setLayout(hookLockSensorLayout);
        hookLockSensorLayout.setHorizontalGroup(
                hookLockSensorLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
                .addGap(0, 23, Short.MAX_VALUE)
        );
        hookLockSensorLayout.setVerticalGroup(
                hookLockSensorLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
                .addGap(0, 23, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        add(hookLockSensor, gridBagConstraints);

        jLabel1.setText("<html><P align=\"center\">OPEN<br>SENSOR</p></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 6;
        gridBagConstraints.insets = new Insets(0, 7, 0, 7);
        add(jLabel1, gridBagConstraints);

        jLabel2.setText("<html><P align=\"center\">CLOSE<br>SENSOR</p></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.insets = new Insets(0, 7, 0, 7);
        add(jLabel2, gridBagConstraints);

        GroupLayout hookErrorLayout = new GroupLayout(hookError);
        hookError.setLayout(hookErrorLayout);
        hookErrorLayout.setHorizontalGroup(
                hookErrorLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
                .addGap(0, 20, Short.MAX_VALUE)
        );
        hookErrorLayout.setVerticalGroup(
                hookErrorLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
                .addGap(0, 20, Short.MAX_VALUE)
        );

        add(hookError, new GridBagConstraints());

        hookErrorLabel.setText("ERROR");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 35, 0, 35);
        add(hookErrorLabel, gridBagConstraints);

        hookLockStatus.setFont(new Font("Lucida Grande", 1, 14)); // NOI18N
        hookLockStatus.setText("hookState");
        hookLockStatus.setBorder(BorderFactory.createEtchedBorder(new Color(0, 255, 255), null));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new Insets(0, 18, 0, 18);
        add(hookLockStatus, gridBagConstraints);
        setDefaultValues();
    }

    private void setDefaultValues() {
        hookUnlockSensor.setColor(Color.gray);
        hookLockSensor.setColor(Color.gray);
        hookError.setColor(Color.gray);
        hookLockStatus.setText(UNKNOWN_STATE);
    }

    public void resetPanel() {
        setDefaultValues();
    }

    public static void main(String[] argv) {

        JFrame frame = new JFrame("New Loader Hook Panel");
        LoaderHookPanel d = new LoaderHookPanel("my_hook");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
