/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.carousel.ui.AnalogicSensorPanel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.FilterPresenceSensorPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.ControllerStatePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class CarouselClampPanel
extends JPanel {
    private static final long serialVersionUID = -1273081770223753869L;
    private final String fullPathClampName;
    private final String lockSensorName;
    private final String filterPresenceSensorName;
    private JLabel clampStateLabel;
    private final JLabel explainText = new JLabel("<HTML><P>UNLOCKED: <P>between minValue and offset1 <P>LOCKED: <P>between minLocked and maxLimit</HTML>");
    private AnalogicSensorPanel lockSensorPanel;
    private FilterPresenceSensorPanel filterPresenceSensorPanel;
    private JPanel paramsPanel;
    private final JLabel currentToUnlockLabel = new JLabel("0");
    private final JLabel currentToPrepareUnlockLabel = new JLabel("0");
    private final ControllerStatePanel controllerPanel;

    public CarouselClampPanel(String clampName) {
        this.fullPathClampName = clampName;
        String[] words = clampName.split("X");
        this.lockSensorName = "lockSensorX" + words[1];
        this.filterPresenceSensorName = "filterPresenceX" + words[1];
        String controllerName = Tools.getShortComponentName(this.fullPathClampName).contains("Xminus") ? "clampXminusController" : "clampXplusController";
        this.controllerPanel = new ControllerStatePanel(controllerName, false);
        this.initComponents();
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        Map config = configInfo.getCurrentValuesFor(this.fullPathClampName);
        this.currentToUnlockLabel.setText((String)config.get("currentToUnlock"));
        Map configCa = configInfo.getCurrentValuesFor("carousel");
        this.currentToPrepareUnlockLabel.setText((String)configCa.get("currentToPrepareUnlock"));
        this.lockSensorPanel.initializeGui(configInfo);
        this.filterPresenceSensorPanel.initializeGui(configInfo);
    }

    protected void updateClamp(StatusDataPublishedByCarouselClamp s) {
        SwingUtilities.invokeLater(new UpdateClamp(s));
    }

    public void updateController(StatusDataPublishedByEPOSController s) {
        this.controllerPanel.update(s);
    }

    public void updateMinLocked(long value) {
        this.lockSensorPanel.updateMinLocked(value);
    }

    private void initComponents() {
        this.clampStateLabel = new JLabel("UNKNOWN STATE");
        this.clampStateLabel.setFont(Tools.BIG_FONT);
        this.lockSensorPanel = new AnalogicSensorPanel(this.fullPathClampName, this.lockSensorName, 0);
        this.filterPresenceSensorPanel = new FilterPresenceSensorPanel(this.fullPathClampName, this.filterPresenceSensorName, 1);
        this.paramsPanel = new JPanel();
        this.paramsPanel.setBorder(BorderFactory.createLineBorder(Color.blue));
        this.paramsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = Tools.insets_std;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.anchor = 21;
        this.paramsPanel.add((Component)new JLabel("Current to unlock:"), gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)new JLabel("<HTML>Current to <P>prepare unlock:</HTML>"), gbcp);
        ++gbcp.gridx;
        gbcp.anchor = 22;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        this.paramsPanel.add((Component)this.currentToUnlockLabel, gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)this.currentToPrepareUnlockLabel, gbcp);
        String clampName = Tools.getShortComponentName(this.fullPathClampName);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Tools.NICE_PINK), clampName));
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.clampStateLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.controllerPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.explainText, gbc);
        ++gbc.gridx;
        this.add((Component)this.paramsPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.lockSensorPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.filterPresenceSensorPanel, gbc);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.currentToUnlockLabel.setText("0.0");
        this.currentToPrepareUnlockLabel.setText("0.0");
        this.clampStateLabel.setText("UNKNOWN STATE");
        this.controllerPanel.resetPanel();
    }

    public void resetPanel() {
        this.setDefaultValues();
        this.lockSensorPanel.resetPanel();
        this.filterPresenceSensorPanel.resetPanel();
    }

    public void resetControllerPanel() {
        this.controllerPanel.resetPanel();
    }

    public static void main(String[] argv) {
        CarouselClampPanel d = new CarouselClampPanel("clampXminus");
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public class UpdateClamp
    implements Runnable {
        private StatusDataPublishedByCarouselClamp s;

        public UpdateClamp(StatusDataPublishedByCarouselClamp s) {
            this.s = s;
        }

        @Override
        public void run() {
            CarouselClampPanel.this.clampStateLabel.setText(this.s.getClampState().toString());
            CarouselClampPanel.this.clampStateLabel.setForeground(this.s.getClampState().getColor());
            CarouselClampPanel.this.lockSensorPanel.update(this.s.getLockSensorValue(), (FcsEnumerations.ColoredObject)this.s.getLockStatus());
            CarouselClampPanel.this.lockSensorPanel.updateOffset1(this.s.getLockSensorOffset1());
            CarouselClampPanel.this.filterPresenceSensorPanel.update(this.s.getFilterPositionSensorValue(), (FcsEnumerations.ColoredObject)this.s.getFilterPresenceStatus());
            CarouselClampPanel.this.filterPresenceSensorPanel.updateOffset1(this.s.getFilterPresenceMinNoFilter());
            CarouselClampPanel.this.filterPresenceSensorPanel.updateOffset2(this.s.getFilterPresenceOffset2());
        }
    }
}

