
package org.lsst.ccs.subsystems.fcs.ui;

import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;

/**
 * A panel to display loader status LPS and LRH, and on Camera sensor
 *
 * @author virieux
 */
public class LoaderStatusPanel extends JPanel {

    private static final long serialVersionUID = 1L;

    private static final String title = "loader status";
    private final DigitalSwitch loaderPresenceSwitch = new DigitalSwitch();
    private final DigitalSwitch loader_LPS_Switch = new DigitalSwitch();
    private final DigitalSwitch loader_LRH_Switch = new DigitalSwitch();

    public LoaderStatusPanel() {
        initComponents();
    }

    /**
     * A Runnable to initialize this Panel from status data published on the
     * STATUS bus by the loader
     */
    private class UpdateLoader implements Runnable {

        private StatusDataPublishedByLoader s;

        public UpdateLoader(StatusDataPublishedByLoader status) {
            this.s = status;
        }

        @Override
        public void run() {
            /*Loader_LPS (=1 if loader is at Storage, loader connected) */
            loader_LPS_Switch.updateColor(s.isLpsInError(), s.isLps());

            /*Loader_LRH (=1 if loader is holding filter at HANDOFF) */
            loader_LRH_Switch.updateColor(s.isLrhInError(), s.isLrh());

            /* loader presence status */
            loaderPresenceSwitch.updateColor(s.isLoaderOnCameraSensorsInError(), s.isLoaderOnCameraSensorValue());
        }
    }

    void updateLoader(StatusDataPublishedByLoader s) {
        SwingUtilities.invokeLater(new LoaderStatusPanel.UpdateLoader(s));
    }

    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(
                Color.MAGENTA, WIDTH + 5), "Read on loaderPlutoGateway"));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.insets = insets_std;
        add(new JLabel("Loader on camera"), gbc);
        gbc.gridy++;
        add(new JLabel("Loader_LPS (loader at Storage)"), gbc);
        gbc.gridy++;
        add(new JLabel("Loader_LRH (loader holds filter)"), gbc);
        gbc.gridy = 0;
        gbc.gridx = 1;
        gbc.anchor = GridBagConstraints.EAST;
        add(this.loaderPresenceSwitch, gbc);
        gbc.gridy++;
        add(loader_LPS_Switch, gbc);
        gbc.gridy++;
        add(loader_LRH_Switch, gbc);
        setDefaultValues();
    }

    /**
     * set default values for components color and labels.
     */
    public void setDefaultValues() {
        loader_LPS_Switch.setColor(Color.GRAY);
        loader_LRH_Switch.setColor(Color.GRAY);
        loaderPresenceSwitch.setColor(Color.GRAY);
    }

    /**
     * Reset Panels to default values.
     */
    public void resetPanel() {
        setDefaultValues();
    }

    @Override
    public String toString() {
        return title;
    }

    /**
     * This main launches an GUI for the whole subsystem "fcs". It's used only
     * for tests.
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        LoaderStatusPanel d = new LoaderStatusPanel();
        JFrame frame = new JFrame("LoaderStatus Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

}
