
package org.lsst.ccs.subsystems.fcs.ui;

import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;

/**
 * A panel to display autochanger status : AP1, AP2, AP3, AF0, AF1, AF2
 *
 * @author virieux
 */
public class AutochangerStatusPanel extends JPanel {
    private static final long serialVersionUID = 1L;

    private final DigitalSwitch ap1Switch = new DigitalSwitch();
    private final DigitalSwitch ap2Switch = new DigitalSwitch();
    private final DigitalSwitch ap3Switch = new DigitalSwitch();
    private final DigitalSwitch af0Switch = new DigitalSwitch();
    private final DigitalSwitch af1Switch = new DigitalSwitch();
    private final DigitalSwitch af3Switch = new DigitalSwitch();

    public AutochangerStatusPanel() {
        initComponents();
    }

    /**
     * A Runnable to update from data published by autochanger. For output signals
     * from autochanger : AF0, AF1, AF3, AP1, AP2, AP3
     */
    class UpdateAutochanger implements Runnable {

        private final StatusDataPublishedByAutoChanger s;

        UpdateAutochanger(StatusDataPublishedByAutoChanger s) {
            this.s = s;
        }

        @Override
        public void run() {

            ap1Switch.updateColor(s.isOUT_AP1_InError(), s.isOUT_AP1());
            ap2Switch.updateColor(s.isOUT_AP2_InError(), s.isOUT_AP2());
            ap3Switch.updateColor(s.isOUT_AP3_InError(), s.isOUT_AP3());

            af0Switch.updateColor(s.isOUT_AF0_InError(), s.isOUT_AF0());
            af1Switch.updateColor(s.isOUT_AF1_InError(), s.isOUT_AF1());
            af3Switch.updateColor(s.isOUT_AF3_InError(), s.isOUT_AF3());

        }
    }

    /**
     * A Runnable to update from data published by loader.
     */
    class UpdateLoader implements Runnable {

        private final StatusDataPublishedByLoader s;

        UpdateLoader(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {
            // NOP
            // No data for us here
        }
    }

    /**
     * A Runnable to update from data published by carousel.
     */
    class UpdateCarousel implements Runnable {

        private final StatusDataPublishedByCarousel s;

        UpdateCarousel(StatusDataPublishedByCarousel s) {
            this.s = s;
        }

        @Override
        public void run() {
            // NOP
            // No data for us here

        }
    }

    /**
     * To update the Panel when the autochanger publishes on the bus its global
     * status.
     *
     * @param status
     */
    public void updateAutochanger(StatusDataPublishedByAutoChanger status) {
        SwingUtilities.invokeLater(new AutochangerStatusPanel.UpdateAutochanger(status));
    }

    /**
     * To update the Panel when the loader publishes on the bus its global status.
     *
     * @param status
     */
    public void updateLoader(StatusDataPublishedByLoader status) {
        // not deleted in case we want to compare in/out
        // SwingUtilities.invokeLater(new AutochangerStatusPanel.UpdateLoader(status));
    }

    /**
     * To update the Panel when the carousel publishes on the bus its global status.
     *
     * @param status
     */
    public void updateCarousel(StatusDataPublishedByCarousel status) {
        // not deleted in case we want to compare in/out
        // SwingUtilities.invokeLater(new
        // AutochangerStatusPanel.UpdateCarousel(status));
    }

    /**
     * To initialize all the components of this Panel.
     */
    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        // CameraProtectionPanel with status coming from autochanger
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.MAGENTA, WIDTH + 5),
                "Read on acPlutoGateway"));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.insets = insets_std;
        add(new JLabel("AP1 (AC at standby)"), gbc);
        gbc.gridy++;
        add(new JLabel("AP2 (AC at handoff)"), gbc);
        gbc.gridy++;
        add(new JLabel("AP3 (AC at online)"), gbc);
        gbc.gridy++;
        add(new JLabel("AF0 (AC latches opened)"), gbc);
        gbc.gridy++;
        add(new JLabel("AF1 (filter detected in AC)"), gbc);
        gbc.gridy++;
        add(new JLabel("AF3 (filter locked in AC)"), gbc);

        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.EAST;
        add(ap1Switch, gbc);
        gbc.gridy++;
        add(ap2Switch, gbc);
        gbc.gridy++;
        add(ap3Switch, gbc);
        gbc.gridy++;
        add(af0Switch, gbc);
        gbc.gridy++;
        add(af1Switch, gbc);
        gbc.gridy++;
        add(af3Switch, gbc);
        setDefaultValues();
    }

    protected void setDefaultValues() {
        ap1Switch.setColor(Color.gray);
        ap2Switch.setColor(Color.gray);
        ap3Switch.setColor(Color.gray);
        af0Switch.setColor(Color.gray);
        af1Switch.setColor(Color.gray);
        af3Switch.setColor(Color.gray);
    }

    /**
     * Reset components to default values.
     */
    public void resetPanel() {
        setDefaultValues();
    }

    /**
     * To be displayed on the GUI.
     *
     * @return
     */
    @Override
    public String toString() {
        return "Autochanger Protection Status";
    }

    /**
     * Just for tests.
     *
     * @param args
     */
    public static void main(String[] args) {
        AutochangerStatusPanel d = new AutochangerStatusPanel();
        JFrame frame = new JFrame("AutochangerProtectionStatusPanel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

}
