package org.lsst.ccs.subsystems.fcs.carousel.ui;

import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;

/**
 *
 * @author virieux
 */
public interface InterfaceCarouselGUI extends InterfaceGeneralGUI {

    //TODO read this configurables parameters values from configuration system when GUI starts.
    public static final long timeoutForOpeningClamps = 10000;
    public static final long timeoutForRotation = 100000;
    public static final long timeoutForCheckingFilterLocation = 2000;
    public static final long timeoutForCANbus = 500;
    public static String carouselName = "carousel";
    
    /**
     * Check Filter Location
     */
    default void checkFiltersLocation() {
        sendCommand("checkFiltersLocation", timeoutForCheckingFilterLocation);
    }

    /**
     ******************************************************************************
     ** Carousel Rotation
     * *****************************************************************************
     * @param socketID
     */
    default void rotate(int socketID) {
        FCSLOG.info("Carousel rotating");
        FCSLOG.info("/timeout=" + timeoutForRotation);
        if (socketID < 1 || socketID > 5) {
            throw new IllegalArgumentException(socketID + " bad socket ID; enter a digit between 1 and 5");
        }
        sendCommand("rotateSocketToStandby socket" + socketID, timeoutForRotation, carouselName);
    }

    default void updatePosition() {
        FCSLOG.info("Carousel updating position");
        FCSLOG.info("/timeout=" + READ_CONTROLLER_TIMEOUT);
        sendCommand("updatePosition", READ_CONTROLLER_TIMEOUT, carouselName);
    }

    default void setSlowMode() {
        FCSLOG.info("Carousel entering slow mode");
        sendCommand("setSlowMode", READ_CONTROLLER_TIMEOUT, carouselName);
    }

    default void setFastMode() {
        FCSLOG.info("Carousel entering fast mode");
        sendCommand("setFastMode", READ_CONTROLLER_TIMEOUT, carouselName);
    }

    default void homing() {
        FCSLOG.info("Carousel setPositionSensorTypeEncoderSSI");
        sendCommand("setControllerPositionSensorTypeEncoderSSI", timeoutForCANbus, carouselName);
    }

    /**
     ******************************************************************************
     ** end of Carousel Rotation
     * *****************************************************************************
     */
    /**
     ******************************************************************************
     ** Clamps Actions
     * *****************************************************************************
     */
    default void unlockClamps() {
        FCSLOG.info("Carousel unlocking clamps");
        FCSLOG.info("/timeout=" + timeoutForOpeningClamps);
        sendCommand("unlockClamps", timeoutForOpeningClamps);
    }

    /**
     ******************************************************************************
     ** end of Clamps Actions
     * *****************************************************************************
     */
    
}
