/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderHook;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class LoaderHookPanel
extends JPanel {
    protected static final int LEFT = 0;
    protected static final int RIGHT = 1;
    private static final long serialVersionUID = 6930078848107595811L;
    private final String hookName;
    private DigitalSwitch hookError;
    private JLabel hookErrorLabel;
    private DigitalSwitch hookLockSensor;
    private JLabel hookLockStatus;
    private JLabel hookNameLabel;
    private DigitalSwitch hookUnlockSensor;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public LoaderHookPanel(String hookName) {
        this.hookName = hookName;
        this.initComponents();
    }

    protected void setHookLocation(int pos) {
        switch (pos) {
            case 1: {
                GridBagLayout layout = (GridBagLayout)this.getLayout();
                GridBagConstraints hookNameConst = layout.getConstraints(this.hookNameLabel);
                hookNameConst.gridx += 2;
                layout.setConstraints(this.hookNameLabel, hookNameConst);
                GridBagConstraints lockedSensorConst = layout.getConstraints(this.hookLockSensor);
                lockedSensorConst.gridx -= 2;
                layout.setConstraints(this.hookLockSensor, lockedSensorConst);
                break;
            }
        }
    }

    public void updateHook(StatusDataPublishedByLoaderHook statusDataPublishedByLoaderHook) {
        SwingUtilities.invokeLater(new UpdateHook(statusDataPublishedByLoaderHook));
    }

    private void initComponents() {
        this.hookNameLabel = new JLabel();
        this.hookUnlockSensor = new DigitalSwitch();
        this.hookLockSensor = new DigitalSwitch();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.hookError = new DigitalSwitch();
        this.hookErrorLabel = new JLabel();
        this.hookLockStatus = new JLabel();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        this.hookNameLabel.setText("hook1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 14;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.hookNameLabel, gridBagConstraints);
        GroupLayout hookUnlockSensorLayout = new GroupLayout(this.hookUnlockSensor);
        this.hookUnlockSensor.setLayout(hookUnlockSensorLayout);
        hookUnlockSensorLayout.setHorizontalGroup(hookUnlockSensorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        hookUnlockSensorLayout.setVerticalGroup(hookUnlockSensorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        this.add((Component)this.hookUnlockSensor, gridBagConstraints);
        GroupLayout hookLockSensorLayout = new GroupLayout(this.hookLockSensor);
        this.hookLockSensor.setLayout(hookLockSensorLayout);
        hookLockSensorLayout.setHorizontalGroup(hookLockSensorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        hookLockSensorLayout.setVerticalGroup(hookLockSensorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        this.add((Component)this.hookLockSensor, gridBagConstraints);
        this.jLabel1.setText("<html><P align=\"center\">UNLOCK<br>SENSOR</p></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 6;
        gridBagConstraints.insets = new Insets(0, 7, 0, 7);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("<html><P align=\"center\">LOCK<br>SENSOR</p></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.insets = new Insets(0, 7, 0, 7);
        this.add((Component)this.jLabel2, gridBagConstraints);
        GroupLayout hookErrorLayout = new GroupLayout(this.hookError);
        this.hookError.setLayout(hookErrorLayout);
        hookErrorLayout.setHorizontalGroup(hookErrorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        hookErrorLayout.setVerticalGroup(hookErrorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        this.add((Component)this.hookError, new GridBagConstraints());
        this.hookErrorLabel.setText("ERROR");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 35, 0, 35);
        this.add((Component)this.hookErrorLabel, gridBagConstraints);
        this.hookLockStatus.setFont(new Font("Lucida Grande", 1, 14));
        this.hookLockStatus.setText("hookState");
        this.hookLockStatus.setBorder(BorderFactory.createEtchedBorder(new Color(0, 255, 255), null));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new Insets(0, 18, 0, 18);
        this.add((Component)this.hookLockStatus, gridBagConstraints);
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        this.hookUnlockSensor.setColor(Color.gray);
        this.hookLockSensor.setColor(Color.gray);
        this.hookError.setColor(Color.gray);
        this.hookLockStatus.setText("UNKNOWN STATE");
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame("New Loader Hook Panel");
        LoaderHookPanel d = new LoaderHookPanel("my_hook");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateHook
    implements Runnable {
        private final StatusDataPublishedByLoaderHook s;

        public UpdateHook(StatusDataPublishedByLoaderHook statusDataPublishedByLoaderHook) {
            this.s = statusDataPublishedByLoaderHook;
        }

        @Override
        public void run() {
            boolean inTravel;
            LoaderHookPanel.this.hookNameLabel.setText(LoaderHookPanel.this.hookName);
            LoaderHookPanel.this.hookUnlockSensor.setColor(this.s.getUnlockSensorValue() ? Tools.greenColor : Color.gray);
            LoaderHookPanel.this.hookLockSensor.setColor(this.s.getLockSensorValue() ? Tools.greenColor : Color.gray);
            boolean bl = inTravel = !this.s.getUnlockSensorValue() && !this.s.getLockSensorValue();
            if (this.s.isInError()) {
                LoaderHookPanel.this.hookError.setColor(Color.RED);
                LoaderHookPanel.this.hookErrorLabel.setText("IN ERROR");
            } else if (inTravel) {
                LoaderHookPanel.this.hookError.setColor(Color.YELLOW);
                LoaderHookPanel.this.hookErrorLabel.setText("IN TRAVEL");
            } else if (this.s.getLockStatus().equals((Object)FcsEnumerations.LockStatus.UNKNOWN)) {
                LoaderHookPanel.this.hookError.setColor(Color.DARK_GRAY);
                LoaderHookPanel.this.hookErrorLabel.setText("UNKNOWN");
            } else {
                LoaderHookPanel.this.hookError.setColor(Color.GREEN);
                LoaderHookPanel.this.hookErrorLabel.setText("NO ERROR");
            }
            LoaderHookPanel.this.hookLockStatus.setText(this.s.getLockStatus().toString());
            Color hookLockStatusColor = this.s.getLockStatus().getColor();
            LoaderHookPanel.this.hookLockStatus.setBackground(hookLockStatusColor);
        }
    }
}

