/*
 * Decompiled with CFR 0.152.
 */
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Problem {
    static final Object lock = new Object();
    static CountDownLatch latch;
    static int n;
    static int[] result;
    static int firstNumber;
    static volatile boolean done;
    static final int[] test;

    public static void main(String ... args) {
        int N_THREADS = 7;
        ExecutorService exec = Executors.newFixedThreadPool(N_THREADS);
        long time = System.currentTimeMillis();
        for (n = 50; n <= 51; ++n) {
            result = null;
            firstNumber = 1;
            latch = new CountDownLatch(N_THREADS);
            done = false;
            for (int iThread = 0; iThread < N_THREADS; ++iThread) {
                exec.submit(() -> Problem.runSolver());
            }
            try {
                latch.await();
            }
            catch (InterruptedException iThread) {
                // empty catch block
            }
            long seconds = (System.currentTimeMillis() - time) / 1000L;
            StringBuilder sb = new StringBuilder();
            if (seconds < 60L) {
                sb.append(seconds).append(" seconds, ");
            } else {
                long minutes = seconds / 60L;
                sb.append(minutes).append(" minutes, ");
            }
            if (result != null) {
                sb.append("Success for ").append(n).append(" : ");
                for (int k = 0; k < n; ++k) {
                    sb.append(result[k]).append(",");
                }
            } else {
                sb.append("Failed: ").append(n);
            }
            System.out.println(sb.toString());
            time = System.currentTimeMillis();
        }
        exec.shutdown();
        System.out.println("Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void runSolver() {
        try {
            int start;
            int[] r;
            do {
                Object object = lock;
                synchronized (object) {
                    ++firstNumber;
                    if (done) return;
                    if (start > n) {
                        return;
                    }
                }
            } while ((r = Problem.solve(start)) == null);
            Object object = lock;
            synchronized (object) {
                result = r;
                done = true;
                return;
            }
        }
        finally {
            latch.countDown();
        }
    }

    static int[] solve(int start) {
        boolean[] used = new boolean[n + 1];
        int[] solution = new int[n];
        int[] first = new int[n + 1];
        first[0] = start;
        int i = 0;
        int nOdd = (n + 1) / 2;
        while (i < n) {
            block8: {
                int a = i > 1 ? solution[i - 2] : 1;
                int candidate = solution[i];
                boolean even = i > 0 && (solution[i - 1] & 1) == 0;
                int n = candidate = candidate == 0 ? first[i] : candidate + a;
                while (true) {
                    if (candidate > Problem.n) {
                        used[solution[i]] = false;
                        if ((solution[i] & 1) != 0) {
                            ++nOdd;
                        }
                        solution[i] = 0;
                        --i;
                        if (done) {
                            return null;
                        }
                        break block8;
                    }
                    if (!used[candidate] && (!even || nOdd <= 0 || (candidate & 1) != 0)) break;
                    candidate += a;
                }
                used[solution[i]] = false;
                solution[i] = candidate;
                used[candidate] = true;
                if ((candidate & 1) != 0) {
                    --nOdd;
                }
                if (i == 0) {
                    first[i + 1] = 1;
                } else {
                    int prev = solution[i - 1];
                    first[i + 1] = prev - candidate % prev;
                }
                ++i;
            }
            if (i >= 1) continue;
            break;
        }
        return (int[])(i == n ? solution : null);
    }

    static {
        test = new int[]{33, 23, 10, 13, 7, 6, 1, 29, 27, 2, 25, 21, 4, 17, 15, 19, 11, 8, 3, 5, 31, 9, 22, 14, 30, 26, 34, 18, 16, 20, 12, 28, 32, 24};
    }
}

