/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class ControllerStatePanel
extends JPanel {
    private final DigitalSwitch controllerSwitch = new DigitalSwitch();
    private final JLabel nameLabel = new JLabel();
    private final JLabel eposStateLabel = new JLabel();
    private final JLabel modeLabel = new JLabel();
    private final JLabel currentjLabel = new JLabel("0");
    private final JLabel positionjLabel = new JLabel("0");
    private final JLabel velocityjLabel = new JLabel("0");

    public ControllerStatePanel() {
        this.initComponents();
    }

    public void update(String controllerName, StatusDataPublishedByEPOSController s) {
        FCSCst.FCSLOG.debug((Object)("ControllerStatePanel updating from controller data of " + controllerName));
        SwingUtilities.invokeLater(new UpdateController(controllerName, s));
    }

    private void initComponents() {
        this.setDefaultValues();
        this.nameLabel.setFont(Tools.BIG_FONT);
        this.setBorder(BorderFactory.createLineBorder(Color.MAGENTA, 6));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.nameLabel, gbc);
        ++gbc.gridy;
        this.controllerSwitch.setSize(40);
        this.add((Component)this.controllerSwitch, gbc);
        ++gbc.gridy;
        this.add((Component)this.eposStateLabel, gbc);
        ++gbc.gridy;
        this.add((Component)this.modeLabel, gbc);
        gbc.anchor = 17;
        gbc.gridy = 4;
        this.add((Component)new JLabel("<HTML>Current : <BR>(in mA) </HTML>"), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel("<HTML>Position : <BR>(in um)</HTML>"), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel("<HTML>Velocity : <BR>(in rpm) </HTML>"), gbc);
        ++gbc.gridx;
        gbc.gridy = 4;
        gbc.anchor = 13;
        this.add((Component)this.currentjLabel, gbc);
        ++gbc.gridy;
        this.add((Component)this.positionjLabel, gbc);
        ++gbc.gridy;
        this.add((Component)this.velocityjLabel, gbc);
    }

    private void setDefaultValues() {
        this.nameLabel.setText("UNKNOWN CTL NAME");
        this.controllerSwitch.setColor(Color.gray);
        this.eposStateLabel.setText("UNKNOWN STATE");
        this.modeLabel.setText("UNKNOWN");
        this.positionjLabel.setText("0");
        this.currentjLabel.setText("0");
        this.velocityjLabel.setText("0");
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    @Override
    public String toString() {
        return "Controller State View";
    }

    public static void main(String[] argv) {
        ControllerStatePanel d = new ControllerStatePanel();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public class UpdateController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;
        private final String controllerName;

        private UpdateController(String controllerName, StatusDataPublishedByEPOSController s) {
            this.s = s;
            this.controllerName = controllerName;
        }

        @Override
        public void run() {
            ControllerStatePanel.this.nameLabel.setText(this.controllerName);
            if (this.s.isBooted() && this.s.getState() != null) {
                ControllerStatePanel.this.eposStateLabel.setText(this.s.getState().name());
                ControllerStatePanel.this.controllerSwitch.setColor(this.s.getState().getColor());
            } else if (!this.s.isBooted()) {
                ControllerStatePanel.this.eposStateLabel.setText("not booted");
                ControllerStatePanel.this.controllerSwitch.setColor(Color.RED);
            }
            if (this.s.isBooted()) {
                ControllerStatePanel.this.positionjLabel.setText(Integer.toString(this.s.getPosition()));
                ControllerStatePanel.this.currentjLabel.setText(Integer.toString(this.s.getCurrent()));
                ControllerStatePanel.this.velocityjLabel.setText(Integer.toString(this.s.getVelocity()));
            }
            ControllerStatePanel.this.modeLabel.setText(this.s.getMode() == null ? "UNKNOWN" : this.s.getMode().toString());
        }
    }
}

