/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystems.fcs.ui.commons.BottomPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;

public class GeneralPanel
extends JPanel
implements StatusMessageListener {
    private static final long serialVersionUID = -1056620058636291687L;
    protected GeneralGUI subs;
    private final SubsystemPanel subsystemPanel;
    private final BottomPanel bottomPanel;
    private final JSplitPane splitPane = new JSplitPane(0);

    public GeneralPanel(GeneralGUI subs, BottomPanel bottomPanel) {
        this.subs = subs;
        this.subsystemPanel = new SubsystemPanel(subs.destination);
        this.subsystemPanel.setSubsystem(subs);
        this.bottomPanel = bottomPanel;
        this.initComponents();
    }

    public SubsystemPanel getSubsystemPanel() {
        return this.subsystemPanel;
    }

    public void setRunMode(String aMode) {
        this.subsystemPanel.setcontrolRealHardwareLabelText(aMode);
    }

    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareList) throws InterruptedException, InvocationTargetException {
        this.subsystemPanel.initializeGui(configInfo);
        this.bottomPanel.initializeGUIWithConfigInfo(configInfo, hardwareList);
    }

    public void initializeGUIWithLoaderConfigInfo(ConfigurationInfo configInfo, List<String> hardwareList) throws InterruptedException, InvocationTargetException {
        this.bottomPanel.initializeGUIWithLoaderConfigInfo(configInfo, hardwareList);
    }

    public void initializeGUIWithFiltersInfo(ConfigurationInfo configInfo, List<String> filterNamesList) throws InterruptedException, InvocationTargetException {
        this.bottomPanel.initializeGUIWithFiltersInfo(configInfo, filterNamesList);
    }

    public void initializeGUIWithControllersMap(Map<String, String> controllersMap) {
        this.bottomPanel.initializeGUIWithControllersMap(controllersMap);
    }

    private void initComponents() {
        JScrollPane bottomScrollPane = new JScrollPane(this.bottomPanel);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.add((Component)this.subsystemPanel, "North");
        this.add((Component)bottomScrollPane, "Center");
    }

    public void onStatusMessage(StatusMessage msg) {
        this.bottomPanel.onStatusMessage(msg);
    }

    void resetPanel() {
        this.bottomPanel.resetPanel();
    }
}

