package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByPlutoGateway;
import static org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel.FCSLOG;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.NICE_PINK;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * A Panel to display data from a PLutoGateway.
 * Empty now. To be completed.
 * @author virieux
 */
public class PlutoGatewayPanel extends JPanel {
    private static final long serialVersionUID = -7222037685600465352L;

    /**
     * Variables declaration *
     */
    private final String gatewayName;
    private final String publishedDataKey;
    
    //general informations panel
    private final CanOpenDevicePanel  generalInfoPanel;
    private final JPanel valuesPanel;
    JScrollPane jScrollPane = new JScrollPane();
    JTable valuesTable = new JTable();
    

    /**
     * A Runnable to update this panel from data published on the STATUS bus
     * by the plutoGateway.
     */
    class UpdatePlutoGateway implements Runnable {

        private StatusDataPublishedByPlutoGateway s;

        public UpdatePlutoGateway(StatusDataPublishedByPlutoGateway status) {
            this.s = status;
        }

        @Override
        public void run() {
            FCSLOG.fine(" UpdatePlutoGateway for gateway=" + gatewayName);
            //General Informations Panel
            generalInfoPanel.updateCanOpenDevice(gatewayName, s);
            
            /* values panel*/
            DefaultTableModel valuesTableModel = (DefaultTableModel) valuesTable.getModel();
            int rowNB = s.getIntValues().length;
            for (int i = 0; i < rowNB; i++) {
                int value = s.getIntValues()[i];
                String bin = String.format("%016d", Long.parseLong(Integer.toBinaryString(value)));
                valuesTableModel.setValueAt(value, i, 1);
                valuesTableModel.setValueAt("  0b" + bin, i, 2);
            }
            valuesTableModel.fireTableDataChanged();
        }
    }

    /**
     * Creates new form PlutoGatewayPanel with a name and a general informations panel.
     * @param gatewayName
     */
    public PlutoGatewayPanel(String gatewayName) {
        this.gatewayName = gatewayName;
        this.generalInfoPanel = new CanOpenDevicePanel(gatewayName);
        valuesPanel = new JPanel();
        int ind = gatewayName.lastIndexOf("/");            
        publishedDataKey = ind >=0 ? gatewayName.substring(ind+1) : gatewayName;
        
        initComponents();
    }

    
    /**
     * Initialize the PLutoGatewayPanel from configuration info.
     * @param configInfo 
     */
    public void initializeGui(ConfigurationInfo configInfo) {
        generalInfoPanel.initializeGui(configInfo);
        /* values panel*/
        DefaultTableModel valuesTableModel = (DefaultTableModel) valuesTable.getModel();
        for (int i = 0; i < 16; i++) {
            Object[] tab = {i, 0, 0};
            valuesTableModel.addRow(tab);
        }
        valuesTableModel.fireTableDataChanged();
    }

    /**
     * updates PlutoGatewayPanel from data published by a plutoGateway.
     * @param deviceToUpdateName
     * @param status 
     */
    public void updatePlutoGateway(String deviceToUpdateName, StatusDataPublishedByPlutoGateway status) {
        if (publishedDataKey.equals(deviceToUpdateName)) {
            generalInfoPanel.updateCanOpenDevice(deviceToUpdateName, status);
            SwingUtilities.invokeLater(new UpdatePlutoGateway(status));
        }
    }
    

    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description">                          
    private void initComponents() {
        
        /**
         ******************************************************************************
         ** Values Panel
         * *****************************************************************************
         */

        valuesTable.setModel(new DefaultTableModel(
                new Object[][]{},
                new String[]{
                    "ByteNumero", "Decimal Value", "Binaire Value"
                }
        ) {
            private static final long serialVersionUID = 1L;
            private final Class[] types = new Class[]{
                Integer.class, Integer.class, String.class
            };
            private final boolean[] canEdit = new boolean[]{
                false, false, false
            };

            @Override
            public Class getColumnClass(int columnIndex) {
                return types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit[columnIndex];
            }
        });
        TableColumn column;
        for (int i = 0; i < 3; i++) {
            column = valuesTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(25); //first column is smaller
            }
            if (i == 2) {
                column.setPreferredWidth(150); //third column is bigger
            }
        }
        jScrollPane.setViewportView(valuesTable);
        
        valuesPanel.setBorder(BorderFactory.createLineBorder(NICE_PINK));
        valuesPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.anchor = GridBagConstraints.NORTHWEST;
        gbc0.insets = insets_std;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        valuesPanel.add(jScrollPane, gbc0);
        /**
         ******************************************************************************
         ** end of Values Panel
         * *****************************************************************************
         */


        /**
         ******************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        setBorder(BorderFactory.createLineBorder(Color.GREEN));
        //setForeground(new java.awt.Color(204, 204, 255));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.CENTER;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(generalInfoPanel, gbc);
        gbc.gridy++;
        add(valuesPanel, gbc);

        /**
         ******************************************************************************
         ** end of Whole Panel
         * *****************************************************************************
         */
    }
    
    public void resetPanel() {
        generalInfoPanel.resetPanel();
        DefaultTableModel valuesTableModel = (DefaultTableModel) valuesTable.getModel();
        for (int i=15; i >= 0; i--) {
            valuesTableModel.removeRow(i);
            valuesTableModel.fireTableRowsDeleted(i, i);
        }
    }

    @Override
    public String toString() {
        if (gatewayName == null) {
            return "plutoGateway";
        } else {
            int ind = gatewayName.lastIndexOf("/");            
            return ind >=0 ? gatewayName.substring(ind+1) : gatewayName;
        }
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame("Pluto Gateway Panel");
        PlutoGatewayPanel p = new PlutoGatewayPanel("my_plutoGateway");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

}
