
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.Map;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterPresenceStatus;

/**
 *
 * @author virieux
 */
public class Tools {

    public static final Color greenColor = new Color(0, 165, 0);
    public static final Color nicePink = new Color(255, 0, 255);

    public static final String fcsFontInString = "Lucida Grande";
    public static final Font BIG_FONT = new Font(fcsFontInString, 1, 14);
    public static final Font HUGE_FONT = new Font(fcsFontInString, 1, 20);
    public static final Font VERY_BIG_FONT = new Font("Tahoma", 1, 18);
    public static final Insets insets_std = new Insets(4, 4, 4, 4);
    public static final Insets insets_big = new Insets(14, 4, 6, 4);
    public static final Insets insets_small = new Insets(1, 1, 1, 1);

    public static final String ZERO_VALUE = "0.0";
    public static final String UNKNOWN_VALUE = "999.99";
    public static final String UNKNOWN_STATE = "UNKNOWN STATE";
    public static final String UNKNOWN_ERROR = "UNKNOWN ERROR";

    public static final String NONE = "None";
    public static final String TIRETS = "--";

    public static final Dimension preferedPanelSize = new Dimension(1200, 600);


    /**
     *
     * @param filterPresenceStatus
     * @return
     */
    public static Color getFilterPresenceColor(String filterPresenceStatus) {
        if (filterPresenceStatus.equals(FilterPresenceStatus.ERROR.toString())) {
            return Color.red;
        } else if (filterPresenceStatus.equals(FilterPresenceStatus.LOCKABLE.toString())) {
            return greenColor;
        } else if (filterPresenceStatus.equals(FilterPresenceStatus.NOT_LOCKABLE.toString())) {
            return Color.orange;
        } else if (filterPresenceStatus.equals(FilterPresenceStatus.NOFILTER.toString())) {
            return Color.gray;
        } else {
            FCSLOG.error("Unknown Filter Presence Status " + filterPresenceStatus);
            return Color.gray;
        }
    }


    /**
     * Return value of parameterName found in map config if it exits.
     * If config doesn't contain parameterName, returns 0 and log and ERROR.
     * @param config
     * @param parameterName
     * @return
     */
    public static int toInt(Map<String, String> config, String parameterName) {
        if (config.containsKey(parameterName)) {
            return Integer.parseInt(config.get(parameterName));
        } else {
            FCSLOG.error("no such parameter in ConfigurationInfo:" + parameterName);
            return 0;
        }
    }


}
