/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class FilterPanel
extends JPanel {
    private static final long serialVersionUID = 1771035528248774462L;
    private int size = 200;
    private final Color filterOutColor = new Color(153, 153, 153);
    private final Color filterInColor = new Color(0, 165, 0);
    private Color filterColor = this.filterOutColor;
    private String filterString = "";

    public FilterPanel() {
        this.initComponents();
        this.setSize(this.size);
    }

    public final void setSize(int size) {
        this.size = size;
        super.setPreferredSize(new Dimension(size, size));
    }

    @Override
    public void setBackground(Color bg) {
        this.setColor(bg);
    }

    public void setIsFilterInHouse(boolean isFilterIn, String filterName) {
        if (isFilterIn) {
            this.filterString = filterName;
            this.setColor(this.filterInColor);
        } else {
            this.filterString = "No Filter";
            this.setColor(this.filterOutColor);
        }
    }

    public void setColor(Color c) {
        this.filterColor = c;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.addRenderingHints(hints);
        float width = this.size;
        float height = this.size;
        float actualWidth = Math.min(width, height);
        double border = 1.0;
        Arc2D.Double outerCircle = new Arc2D.Double(border, border, (double)actualWidth - 2.0 * border, (double)actualWidth - 2.0 * border, 0.0, 360.0, 1);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(Color.gray);
        g2.fill(outerCircle);
        g2.setColor(Color.black);
        g2.draw(outerCircle);
        BigDecimal aw = BigDecimal.valueOf(actualWidth).add(BigDecimal.valueOf(-20L));
        Arc2D.Double filterCircle = new Arc2D.Double(border + 10.0, border + 10.0, (double)aw.floatValue() - 2.0 * border, (double)aw.floatValue() - 2.0 * border, 0.0, 360.0, 1);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(this.filterColor);
        g2.fill(filterCircle);
        g2.setColor(Color.black);
        g2.draw(filterCircle);
        String msg = this.filterString.replace("filterID_", "");
        if (!"".equals(msg)) {
            g2.setFont(new Font("system", 1, 20));
            Rectangle2D bounds = g2.getFontMetrics().getStringBounds(msg, g2);
            g2.drawString(msg, (int)(((double)this.getWidth() - bounds.getWidth()) / 2.0), (int)((double)this.getHeight() + bounds.getHeight() / 2.0) / 2);
        }
    }

    public static void main(String[] argv) {
        FilterPanel d = new FilterPanel();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

