/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class EPOSParametersPanel
extends JPanel {
    private static final long serialVersionUID = 7733122808854397608L;
    private JTable paramsTable;
    private JScrollPane jScrollPane;
    private final JLabel mLabel = new JLabel("Parameters defined for mode: ");
    private final JLabel modeLabel = new JLabel("Unknown Mode");

    public EPOSParametersPanel() {
        this.initComponents();
    }

    public void initializeGUI(String mode, Map<String, String> paramsMap) {
        SwingUtilities.invokeLater(new GuiInitialization(mode, paramsMap));
    }

    private void initComponents() {
        this.paramsTable = new JTable();
        this.paramsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Parameter Name", "Index", "Subindex", "Size", "Signed", "Decimal Value"}){
            private static final long serialVersionUID = -6158042587124966771L;
            private final Class[] types;
            private final boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, Boolean.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false, false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        for (int i = 0; i < 6; ++i) {
            TableColumn column = this.paramsTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(250);
                continue;
            }
            if (i != 5) continue;
            column.setPreferredWidth(120);
        }
        this.paramsTable.setAutoResizeMode(4);
        this.jScrollPane = new JScrollPane(this.paramsTable);
        this.jScrollPane.setMinimumSize(new Dimension(400, 50));
        this.jScrollPane.setPreferredSize(new Dimension(500, 100));
        this.paramsTable.setFillsViewportHeight(true);
        this.setBorder(BorderFactory.createLineBorder(Tools.nicePink));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.mLabel, gbc);
        ++gbc.gridx;
        this.modeLabel.setFont(Tools.BIG_FONT);
        this.add((Component)this.modeLabel, gbc);
        --gbc.gridx;
        ++gbc.gridy;
        gbc.gridwidth = 4;
        this.add((Component)this.jScrollPane, gbc);
    }

    public void resetPanel() {
        DefaultTableModel paramsTableModel = (DefaultTableModel)this.paramsTable.getModel();
        int rowNB = paramsTableModel.getRowCount();
        while (paramsTableModel.getRowCount() > 0) {
            paramsTableModel.removeRow(paramsTableModel.getRowCount() - 1);
        }
        paramsTableModel.fireTableRowsDeleted(0, rowNB - 1);
    }

    public static void main(String[] argv) {
        EPOSParametersPanel p = new EPOSParametersPanel();
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("ContinuousCurrentLimit", "3440");
        paramsMap.put("OutputCurrentLimit", "6880");
        paramsMap.put("MaxSpeedInCurrentMode", "2000");
        p.initializeGUI("CURRENT", paramsMap);
        JFrame frame = new JFrame("EPOS Parameters");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class GuiInitialization
    implements Runnable {
        private final String modeInString;
        private final Map<String, String> paramsMap;

        GuiInitialization(String mode, Map<String, String> paramsMap) {
            this.modeInString = mode;
            this.paramsMap = paramsMap;
        }

        @Override
        public void run() {
            EPOSParametersPanel.this.modeLabel.setText(this.modeInString);
            DefaultTableModel paramsTableModel = (DefaultTableModel)EPOSParametersPanel.this.paramsTable.getModel();
            if (paramsTableModel.getRowCount() > 0) {
                EPOSParametersPanel.this.resetPanel();
            }
            if (this.paramsMap != null) {
                for (Map.Entry<String, String> entry : this.paramsMap.entrySet()) {
                    String paramName = entry.getKey();
                    String configValue = entry.getValue();
                    EPOSEnumerations.Parameter param = EPOSEnumerations.Parameter.valueOf(paramName);
                    String indexHexa = "0x" + Integer.toHexString(param.getIndex());
                    String subindexHexa = "0x" + Integer.toHexString(param.getSubindex());
                    Object[] tab = new Object[]{paramName, indexHexa, subindexHexa, param.getSize(), param.isSigned(), configValue};
                    paramsTableModel.addRow(tab);
                }
            }
            paramsTableModel.fireTableDataChanged();
        }
    }
}

