
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import javax.swing.tree.DefaultMutableTreeNode;
import static org.lsst.ccs.subsystems.fcs.FCSCst.CHANGER_TCPPROXY_NAME;
import org.lsst.ccs.subsystems.fcs.ui.commons.BottomPanel;

/**
 * This is the bottom Panel for the autochanger standalone subsystem.
 * It extends BottomPanel, so at the left there is a tree of Panels. 
 * 
 * @author virieux
 */
public class AutochangerBottomPanel extends BottomPanel {
    private static final long serialVersionUID = -5328560102090705688L;

    /**
     * A constructor with a AutochangerGatherPanel and a title.
     * The title is displayed on the border of the Panel.
     * 
     * @param gatherPanel
     * @param title 
     */
    public AutochangerBottomPanel(AutochangerGatherPanel gatherPanel, String title) {
        super(gatherPanel, title);
    }
    
    /**
     * Creates the nodes of the TreePanel.
     * This tree is displayed on the left part of this Panel.
     * 
     * @param top 
     */
    @Override
    public void createNodes(DefaultMutableTreeNode top) {

        if (gatherPanel == null) {
            gatherPanel = new AutochangerGatherPanel(CHANGER_TCPPROXY_NAME);
        }
        
        /** CANopen devices panels*/
        DefaultMutableTreeNode devicesNode = new DefaultMutableTreeNode("CANopen devices");
        devicesNode.add(new DefaultMutableTreeNode(gatherPanel.getCanOpenHardwareListPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((AutochangerGatherPanel) gatherPanel).getPlutoGatewayPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((AutochangerGatherPanel) gatherPanel).getLatchXminusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((AutochangerGatherPanel) gatherPanel).getLatchXplusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((AutochangerGatherPanel) gatherPanel).getLinearRailSlaveControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((AutochangerGatherPanel) gatherPanel).getLinearRailMasterControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((AutochangerGatherPanel) gatherPanel).getOnlineClampXminusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((AutochangerGatherPanel) gatherPanel).getOnlineClampXplusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((AutochangerGatherPanel) gatherPanel).getOnlineClampYminusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((AutochangerGatherPanel) gatherPanel).getOnlineStrainGaugePanel()));
        top.add(devicesNode);

        top.add(new DefaultMutableTreeNode(((AutochangerGatherPanel) gatherPanel).getAcGeneralViewPanel()));

        top.add(new DefaultMutableTreeNode(((AutochangerGatherPanel) gatherPanel).getAcLatchesPanel()));

        top.add(new DefaultMutableTreeNode(((AutochangerGatherPanel) gatherPanel).getAcTrucksPanel()));

        top.add(new DefaultMutableTreeNode(((AutochangerGatherPanel) gatherPanel).getAcClampsPanel()));

    }
    
}
