/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.dom;

import org.python.apache.xerces.dom.ChildNode;
import org.python.apache.xerces.dom.CoreDocumentImpl;
import org.python.apache.xerces.dom.DOMMessageFormatter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CharacterDataImpl
extends ChildNode {
    static final long serialVersionUID = 7931170150428474230L;
    protected String data;
    private static final transient NodeList singletonNodeList = new NodeList(){

        public Node item(int n) {
            return null;
        }

        public int getLength() {
            return 0;
        }
    };

    public CharacterDataImpl() {
    }

    protected CharacterDataImpl(CoreDocumentImpl coreDocumentImpl, String string2) {
        super(coreDocumentImpl);
        this.data = string2;
    }

    public NodeList getChildNodes() {
        return singletonNodeList;
    }

    public String getNodeValue() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.data;
    }

    protected void setNodeValueInternal(String string2) {
        this.setNodeValueInternal(string2, false);
    }

    protected void setNodeValueInternal(String string2, boolean bl) {
        CoreDocumentImpl coreDocumentImpl = this.ownerDocument();
        if (coreDocumentImpl.errorChecking && this.isReadOnly()) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string3);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        String string4 = this.data;
        coreDocumentImpl.modifyingCharacterData(this, bl);
        this.data = string2;
        coreDocumentImpl.modifiedCharacterData(this, string4, string2, bl);
    }

    public void setNodeValue(String string2) {
        this.setNodeValueInternal(string2);
        this.ownerDocument().replacedText(this);
    }

    public String getData() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.data;
    }

    public int getLength() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.data.length();
    }

    public void appendData(String string2) {
        if (this.isReadOnly()) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string3);
        }
        if (string2 == null) {
            return;
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.setNodeValue(this.data + string2);
    }

    public void deleteData(int n, int n2) throws DOMException {
        this.internalDeleteData(n, n2, false);
    }

    void internalDeleteData(int n, int n2, boolean bl) throws DOMException {
        CoreDocumentImpl coreDocumentImpl = this.ownerDocument();
        if (coreDocumentImpl.errorChecking) {
            if (this.isReadOnly()) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, string2);
            }
            if (n2 < 0) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null);
                throw new DOMException(1, string3);
            }
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        int n3 = Math.max(this.data.length() - n2 - n, 0);
        try {
            String string4 = this.data.substring(0, n) + (n3 > 0 ? this.data.substring(n + n2, n + n2 + n3) : "");
            this.setNodeValueInternal(string4, bl);
            coreDocumentImpl.deletedText(this, n, n2);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null);
            throw new DOMException(1, string5);
        }
    }

    public void insertData(int n, String string2) throws DOMException {
        this.internalInsertData(n, string2, false);
    }

    void internalInsertData(int n, String string2, boolean bl) throws DOMException {
        CoreDocumentImpl coreDocumentImpl = this.ownerDocument();
        if (coreDocumentImpl.errorChecking && this.isReadOnly()) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string3);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        try {
            String string4 = new StringBuffer(this.data).insert(n, string2).toString();
            this.setNodeValueInternal(string4, bl);
            coreDocumentImpl.insertedText(this, n, string2.length());
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null);
            throw new DOMException(1, string5);
        }
    }

    public void replaceData(int n, int n2, String string2) throws DOMException {
        CoreDocumentImpl coreDocumentImpl = this.ownerDocument();
        if (coreDocumentImpl.errorChecking && this.isReadOnly()) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string3);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        coreDocumentImpl.replacingData(this);
        String string4 = this.data;
        this.internalDeleteData(n, n2, true);
        this.internalInsertData(n, string2, true);
        coreDocumentImpl.replacedCharacterData(this, string4, this.data);
    }

    public void setData(String string2) throws DOMException {
        this.setNodeValue(string2);
    }

    public String substringData(int n, int n2) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        int n3 = this.data.length();
        if (n2 < 0 || n < 0 || n > n3 - 1) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null);
            throw new DOMException(1, string2);
        }
        int n4 = Math.min(n + n2, n3);
        return this.data.substring(n, n4);
    }
}

