/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class VerticalProgressBarPanel
extends JPanel {
    private static final long serialVersionUID = -2994272988748620616L;
    public int value = 0;
    public int maxValue = 10000;
    public int minValue = -2000;
    public String valueName = "Value";
    public Color color = Color.BLUE;
    private int orientation;
    private JLabel valueLabel;
    private JLabel valueNameLabel;
    private JLabel maxValueLabel;
    private JLabel maxValueNameLabel;
    private JLabel minValueLabel;
    private JLabel minValueNameLabel;
    private JProgressBar jProgressBar;

    public VerticalProgressBarPanel() {
        this.initComponents();
    }

    public VerticalProgressBarPanel(String valueName, int minValue, int maxValue, int value, int orientation) {
        this.value = value;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.valueName = valueName;
        this.orientation = orientation;
        this.initComponents();
    }

    public void setColor(Color c) {
        this.color = c;
        this.jProgressBar.setForeground(c);
    }

    public void setValue(int value) {
        this.value = value;
        this.jProgressBar.setValue(value);
        this.valueLabel.setText(Integer.toString(value));
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
        this.jProgressBar.setMaximum(maxValue);
        this.maxValueLabel.setText(Integer.toString(maxValue));
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
        this.jProgressBar.setMinimum(minValue);
        this.minValueLabel.setText(Integer.toString(minValue));
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    public void setStringPainted(boolean b) {
        this.jProgressBar.setStringPainted(b);
    }

    private void initComponents() {
        this.valueNameLabel = new JLabel(this.valueName);
        this.valueLabel = new JLabel(Integer.toString(this.value));
        this.maxValueLabel = new JLabel(Integer.toString(this.maxValue));
        this.minValueLabel = new JLabel(Integer.toString(this.minValue));
        this.maxValueNameLabel = new JLabel("Max " + this.valueName);
        this.minValueNameLabel = new JLabel("Min " + this.valueName);
        this.valueNameLabel.setFont(Tools.BIG_FONT);
        this.minValueNameLabel.setFont(Tools.BIG_FONT);
        this.maxValueNameLabel.setFont(Tools.BIG_FONT);
        this.jProgressBar = new JProgressBar();
        this.jProgressBar.setBackground(new Color(255, 0, 153));
        this.jProgressBar.setForeground(new Color(255, 0, 204));
        this.jProgressBar.setMinimum(this.minValue);
        this.jProgressBar.setMaximum(this.maxValue);
        this.jProgressBar.setValue(this.value);
        this.jProgressBar.setOrientation(this.orientation);
        this.jProgressBar.setStringPainted(true);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        this.add((Component)this.valueNameLabel, gbc);
        ++gbc.gridy;
        this.add((Component)this.valueLabel, gbc);
        ++gbc.gridy;
        this.add((Component)this.jProgressBar, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.add((Component)this.minValueNameLabel, gbc);
        ++gbc.gridy;
        this.add((Component)this.maxValueNameLabel, gbc);
        gbc.anchor = 13;
        ++gbc.gridx;
        --gbc.gridy;
        this.add((Component)this.minValueLabel, gbc);
        ++gbc.gridy;
        this.add((Component)this.maxValueLabel, gbc);
    }

    public static void main(String[] argv) {
        VerticalProgressBarPanel p = new VerticalProgressBarPanel("Position", 0, 5000, 500, 0);
        JFrame frame = new JFrame("Vertical Progress Bar Panel");
        p.setColor(Color.red);
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

