package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JFrame;

/**
 *
 * @author virieux
 */
public class RectangleSwitch extends JComponent {
    
    private int width = 60;
    private int height = width * 4 / 5;
    
    private Color color = new Color(0, 153, 0);
    
    /**
     * Creates new form RectangleSwitch
     */
    public RectangleSwitch() {
        super.setPreferredSize(new Dimension(width, height));
    }
    
    /**
     * Change the size of the RectangleSwitch
     *
     * @param width
     */
    public void setWidth(int width) {
        this.width = width;
        this.height = width * 4 / 5;
        super.setPreferredSize(new Dimension(width, height));
        repaint();
    }
    
    public void setColor(Color c) {
        this.color = c;
        repaint();
    }

    /**
     * updates color of a rectangle switch Uses when a rectangle switch
     * represents a sensors.     * If the sensor is in error, color is set to RED,
     * If sensor is not in error, and its value is 1, color is set to GREEN,
     * if its value is zero it's set to GRAY.
     *
     * @param sensorInError
     * @param sensorValue
     */
    public void updateColor(boolean sensorInError, boolean sensorValue) {
        if (sensorInError) {
                setColor(Color.RED);
        } else {
            setColor(sensorValue ? Color.GREEN : Color.gray);
        }
    }
    
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D) g.create();
        Shape r = new Rectangle(0, 0, width, height);
        g2d.setColor(color);
        g2d.fill(r);
        g2d.setColor(Color.BLACK);
        g2d.draw(r);
        g2d.dispose();
    }
    
    public static void main(String[] argv) {

        RectangleSwitch d = new RectangleSwitch();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
    
}
