package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import javax.swing.JComponent;
import javax.swing.JFrame;

/**
 *
 * @author virieux
 */
public class HorizontalLine extends JComponent {
    
    private int length = 30;

    int startingX = 0;
    int startingY = 20;
    
    
    /**
     * Creates new HorizontalLine
     */
    public HorizontalLine() {
        super.setPreferredSize(new Dimension(length, 2 * startingY));
    }
    
    public HorizontalLine(int length) {
        this.length = length;
        super.setPreferredSize(new Dimension(length, 2 * startingY));
    }
    
    public HorizontalLine(int length, int startingY) {
        this.length = length;
        this.startingY = startingY;
        super.setPreferredSize(new Dimension(length + startingY, 2 * startingY));
    }
    
    /**
     * Change the length of the SimpleLine
     * @param size
     */
    public void setLength(int size) {
        this.length = size;
        super.setPreferredSize(new Dimension(length, 2 * startingY));
        repaint();
    }

    public void setStartingY(int startingY) {
        this.startingY = startingY;
        super.setPreferredSize(new Dimension(length, 2 * startingY));
        repaint();
    }
    
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D) g.create();
        Path2D linePath = new Path2D.Double();
        linePath.moveTo(startingX, startingY);
        linePath.lineTo(length, startingY);
        g2d.setColor(Color.BLACK);
        g2d.draw(linePath);
        g2d.dispose();
    }

    /**
     * for tests
     *
     * @param argv
     */
    public static void main(String[] argv) {

        HorizontalLine d = new HorizontalLine();
        JFrame frame = new JFrame();
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
    
}
