package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import static org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus.CLOSED;
import static org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus.OPENED;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.ui.commons.DiamondSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.HorizontalLine;
import org.lsst.ccs.subsystems.fcs.ui.commons.RectangleSwitch;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.BIG_FONT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalLine;

/**
 *
 * @author virieux
 */
public class PLCLoaderPanel extends JPanel {

    /* height of vertical lines at start and end of subpanels */
    public static final int SP_V_LINE_HEIGHT = 75;

    /* starting Y point for vertical lines at start and end of subpanels */
    public static final int SP_V_LINE_STARTINGY = 22;

    private static final String LABEL1 = "<HTML>On camera<BR>Filter hold</BR><BR>by Loader</BR></HTML>";
    private static final String LABEL2 = "<HTML>On camera<BR>Filter hold</BR><BR>by AC</BR></HTML>";
    private static final String LABEL3 = "<HTML><BR>Engineering</BR><BR>mode</BR></HTML>";
    private static final String LABEL4 = "<HTML>On camera<BR>Without Filter</BR></HTML>";

    /**
     * Labels for displayed components.
     * Can be displayed more than one time.
     */
    /* general status*/
    private final String loaderDocked = "Loader<BR>Docked";
    private final String notDefault = "NO<BR>Default Status";
    private final String notLFS = "NO<BR>LFS Status";
    private final String lockout = "Loader<BR>Lock Out<BR>Bay M";
    private final String engineering = "Loader<BR>Engineering<BR>Mode";
    private final String safetyBelt = "Safety<BR>Belt<BR>Presence";

    /* hooks */
    private final String closed = "Hooks<BR>Closed</BR>";
    private final String clamped = "Hooks<BR>Clamped</BR>";
    private final String unclamped = "Hooks<BR>Unclamped</BR>";
    private final String notClosed = "Hooks NOT<BR>Closed</BR>";
    private final String opened = "Hooks<BR>Opened</BR>";
    private final String notOpened = "Hooks NOT<BR>Opened</BR>";
    private final String notUnderClamped = "Hooks NOT<BR>Under Clamped</BR>";
    private final String notOverClamped = "Hooks NOT<BR>Over Clamped</BR>";

    /* filter */
    private final String filterPresence = "Filter<BR>Presence</BR>";
    private final String noFilterPresence = "Filter<BR>Not Present</BR>";
    private final String filterPosition = "Filter<BR>Position</BR>";

    /* carrier */
    private final String engaged = "Carrier<BR>at ENGAGED</BR>";
    private final String handoff = "Carrier<BR>at HANDOFF</BR>";
    private final String storage = "Carrier<BR>at STORAGE</BR>";
    private final String notHandoff = "Carrier<BR>NOT at HANDOFF</BR>";
    
    /* relays */
    private final String carrierRelay = "<BR>Carrier<BR>Relay</BR>";
    private final String hooksRelay = "Hooks<BR>Relay</BR>";
    
    private final DigitalSwitch loaderDockedDigitalSwitch_lfc = new DigitalSwitch();
    private final DigitalSwitch loaderDockedDigitalSwitch_lfs = new DigitalSwitch();
    private final DigitalSwitch loaderDockedDigitalSwitch_lfu = new DigitalSwitch();
    private final DigitalSwitch loaderDockedDigitalSwitch_lfx = new DigitalSwitch();
    private final DigitalSwitch loaderDockedDigitalSwitch_lfy = new DigitalSwitch();
    private final DigitalSwitch loaderDockedDigitalSwitch_lfz = new DigitalSwitch();
    private final DigitalSwitch ap2Switch1 = new DigitalSwitch();
    private final DigitalSwitch ap2Switch2 = new DigitalSwitch();
    private final DigitalSwitch ap2Switch3 = new DigitalSwitch();
    private final DigitalSwitch ap2Switch4 = new DigitalSwitch();

    private final DigitalSwitch af0Switch1 = new DigitalSwitch();
    private final DigitalSwitch af0Switch2 = new DigitalSwitch();
    private final DigitalSwitch af3Switch = new DigitalSwitch();
    private final DigitalSwitch lockoutSwitch1 = new DigitalSwitch();
    private final DigitalSwitch lockoutSwitch2 = new DigitalSwitch();
    private final DigitalSwitch engineeringSwitch = new DigitalSwitch();

    private final DigitalSwitch filterPresenceSwitch_lfc = new DigitalSwitch();
    private final DigitalSwitch filterPresenceSwitch_lfd = new DigitalSwitch();
    private final DigitalSwitch filterPresenceSwitch_lfs = new DigitalSwitch();
    private final DigitalSwitch filterPresenceSwitch_lfx = new DigitalSwitch();
    private final DigitalSwitch filterPresenceSwitch_lfy = new DigitalSwitch();
    private final DigitalSwitch notFilterPresenceSwitch_lfd = new DigitalSwitch();
    private final DigitalSwitch notFilterPresenceSwitch_lfz = new DigitalSwitch();
    private final DigitalSwitch engagedPositionSwitch_lfc = new DigitalSwitch();
    private final DigitalSwitch engagedPositionSwitch_lfx = new DigitalSwitch();
    private final DigitalSwitch engagedPositionSwitch_lfz = new DigitalSwitch();
    private final DigitalSwitch handoffPositionSwitch_lfx = new DigitalSwitch();
    private final DigitalSwitch handoffPositionSwitch_lfy = new DigitalSwitch();
    private final DigitalSwitch notHandoffPositionSwitch_lfs = new DigitalSwitch();
    private final DigitalSwitch notHandoffPositionSwitch_lfd = new DigitalSwitch();
    private final DigitalSwitch storagePositionSwitch_lfz = new DigitalSwitch();
    
    private final DigitalSwitch[] digitalList;
    private final DiamondSwitch[] diamondList;

    /* hooks sensors*/
    private final DiamondSwitch hooksClampedStatusSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch hooksUnclampedStatusSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch hooksUnclampedStatusSwitch_lfy = new DiamondSwitch();
    private final DiamondSwitch notUnderClampedStatusSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfx = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfy = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfz = new DiamondSwitch();
    private final DiamondSwitch hooksClosedSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch hooksClosedSwitch_lfx = new DiamondSwitch();
    private final DiamondSwitch notClosedSwitch_lfd = new DiamondSwitch();
    private final DiamondSwitch notClosedSwitch_lfs = new DiamondSwitch();
    private final DiamondSwitch notClosedSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch notOpenedSwitch_lfd = new DiamondSwitch();
    private final DiamondSwitch openedSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch openedSwitch_lfz = new DiamondSwitch();
        
    /* status signals */
    private final DiamondSwitch defaultStatusDiamond1 = new DiamondSwitch();
    private final DiamondSwitch defaultStatusDiamond2 = new DiamondSwitch();
    private final DiamondSwitch noLfsStatusDiamond = new DiamondSwitch();
    private final DiamondSwitch filterGoodPositionSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch filterGoodPositionSwitch_lfs = new DiamondSwitch();
    private final DiamondSwitch safetyBeltPresenceSwitch1 = new DiamondSwitch();
    private final DiamondSwitch safetyBeltPresenceSwitch2 = new DiamondSwitch();

    /* Relays*/
    private final RectangleSwitch carrierRelayRectangle = new RectangleSwitch();
    private final RectangleSwitch hooksRelayRectangle = new RectangleSwitch();

    /**
     * A Runnable to update this panel from data published on the status bus from the Loader Carrier.
     */
    private class UpdateCarrier implements Runnable {

        private final StatusDataPublishedByLoaderCarrier s;

        public UpdateCarrier(StatusDataPublishedByLoaderCarrier status) {
            this.s = status;
        }

        @Override
        public void run() {
            storagePositionSwitch_lfz.setColor(s.isAtStorage() ? greenColor : Color.gray);
            handoffPositionSwitch_lfy.setColor(s.isAtHandoff() ? greenColor : Color.gray);
            notHandoffPositionSwitch_lfs.setColor(s.isAtHandoff() ? Color.gray : greenColor);
            notHandoffPositionSwitch_lfd.setColor(s.isAtHandoff() ? Color.gray : greenColor);
            engagedPositionSwitch_lfc.setColor(s.isAtEngaged() ? greenColor : Color.gray);
            engagedPositionSwitch_lfx.setColor(s.isAtEngaged() ? greenColor : Color.gray);
            engagedPositionSwitch_lfz.setColor(s.isAtEngaged() ? greenColor : Color.gray);
        }
    }
        
    
    /**
     * A Runnable to update this panel from data published on the status bus from the Loader Clamp.
     */
    private class UpdateClamp implements Runnable {

        private final StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        @Override
        public void run() {
            hooksClosedSwitch_lfc.setColor(s.getClampState().equals(CLOSED) ? greenColor : Color.GRAY);
            hooksClosedSwitch_lfx.setColor(s.getClampState().equals(CLOSED) ? greenColor : Color.GRAY);
            openedSwitch_lfu.setColor(s.getClampState().equals(OPENED) ? greenColor : Color.GRAY);
            notOpenedSwitch_lfd.setColor(s.getClampState().equals(OPENED) ? Color.GRAY : greenColor);
            notClosedSwitch_lfd.setColor(s.getClampState().equals(CLOSED) ? Color.GRAY : greenColor);
            notClosedSwitch_lfs.setColor(s.getClampState().equals(CLOSED) ? Color.GRAY : greenColor);
            notClosedSwitch_lfu.setColor(s.getClampState().equals(CLOSED) ? Color.GRAY : greenColor);

            hooksClampedStatusSwitch_lfc.setColor(s.isForceClampedStatus() ? greenColor : Color.GRAY);
            hooksUnclampedStatusSwitch_lfc.setColor(s.isForceUnclampedStatus() ? greenColor : Color.GRAY);
            hooksUnclampedStatusSwitch_lfy.setColor(s.isForceUnclampedStatus() ? greenColor : Color.GRAY);
            
            notOverClampedStatusSwitch_lfc.setColor(s.isForceOverClampedStatus() ? Color.GRAY : greenColor);
            notOverClampedStatusSwitch_lfu.setColor(s.isForceOverClampedStatus() ? Color.GRAY : greenColor);
            notOverClampedStatusSwitch_lfx.setColor(s.isForceOverClampedStatus() ? Color.GRAY : greenColor);
            notOverClampedStatusSwitch_lfy.setColor(s.isForceOverClampedStatus() ? Color.GRAY : greenColor);
            notOverClampedStatusSwitch_lfz.setColor(s.isForceOverClampedStatus() ? Color.GRAY : greenColor);

            notUnderClampedStatusSwitch_lfu.setColor(s.isForceUnderClampedStatus() ? Color.GRAY : greenColor);
        }
    }
    
        
    /**
     * A Runnable to update this panel from data published on the status bus from the Loader.
     */
    private class UpdateLoader implements Runnable {

        private final StatusDataPublishedByLoader s;

        public UpdateLoader(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {
            /* redondant sensors : value 0 (GRAY) or 1 (GREEN) but can be in error (RED) */
            for (DigitalSwitch ds : new DigitalSwitch[]{filterPresenceSwitch_lfc, filterPresenceSwitch_lfd,
                filterPresenceSwitch_lfs, filterPresenceSwitch_lfx, filterPresenceSwitch_lfy
            }) {
                ds.updateColor(s.isFilterPresenceSensorsInError(), s.getFilterPresenceSensorValue());
            }
            notFilterPresenceSwitch_lfz.updateColor(s.isFilterPresenceSensorsInError(), !s.getFilterPresenceSensorValue());
            for (DigitalSwitch ds : new DigitalSwitch[]{loaderDockedDigitalSwitch_lfc,
                loaderDockedDigitalSwitch_lfs, loaderDockedDigitalSwitch_lfu,
                loaderDockedDigitalSwitch_lfx, loaderDockedDigitalSwitch_lfy,
                loaderDockedDigitalSwitch_lfz
            }) {
                ds.updateColor(s.isLoaderOnCameraSensorsInError(), s.isLoaderOnCameraSensorValue());
            }
            af0Switch1.updateColor(s.isAf0InError(), s.isAf0());
            af0Switch2.updateColor(s.isAf0InError(), s.isAf0());
            af3Switch.updateColor(s.isAf3InError(), s.isAf3());
            ap2Switch1.updateColor(s.isAp2InError(), s.isAp2());
            ap2Switch2.updateColor(s.isAp2InError(), s.isAp2());
            ap2Switch3.updateColor(s.isAp2InError(), s.isAp2());
            ap2Switch4.updateColor(s.isAp2InError(), s.isAp2());

            engineeringSwitch.updateColor(s.isKeyEngInError(), s.isKeyEng());
            lockoutSwitch1.updateColor(s.isKeyLockInError(), s.isKeyLock());
            lockoutSwitch2.updateColor(s.isKeyLockInError(), s.isKeyLock());
            
            /* status signals : can only be 0 or 1 */
            filterGoodPositionSwitch_lfc.setColor(s.isFilterPositionStatus() ? greenColor : Color.gray);
            filterGoodPositionSwitch_lfs.setColor(s.isFilterPositionStatus() ? greenColor : Color.gray);
            defaultStatusDiamond1.setColor(s.isLoaderDefaultStatus() ? greenColor : Color.gray);
            defaultStatusDiamond2.setColor(s.isLoaderDefaultStatus() ? greenColor : Color.gray);
            safetyBeltPresenceSwitch1.setColor(s.isSafetyBeltPresence() ? greenColor : Color.gray);
            safetyBeltPresenceSwitch2.setColor(s.isSafetyBeltPresence() ? greenColor : Color.gray);
            carrierRelayRectangle.setColor(s.isCarrierRelayStatus() ? greenColor : Color.gray);
            hooksRelayRectangle.setColor(s.isHooksRelayStatus() ? greenColor : Color.gray);
        }
    }

    public PLCLoaderPanel() {
        digitalList = new DigitalSwitch[] {loaderDockedDigitalSwitch_lfc, 
            loaderDockedDigitalSwitch_lfs, loaderDockedDigitalSwitch_lfu,
            loaderDockedDigitalSwitch_lfx, loaderDockedDigitalSwitch_lfy, loaderDockedDigitalSwitch_lfz,
            ap2Switch1, ap2Switch2, ap2Switch3, ap2Switch4, af0Switch1, af0Switch2, af3Switch,
            lockoutSwitch1, lockoutSwitch2, engineeringSwitch,
            filterPresenceSwitch_lfc, filterPresenceSwitch_lfd, filterPresenceSwitch_lfs, filterPresenceSwitch_lfx,
            filterPresenceSwitch_lfy,
            notFilterPresenceSwitch_lfz,
            engagedPositionSwitch_lfc, engagedPositionSwitch_lfx, engagedPositionSwitch_lfz,
            handoffPositionSwitch_lfx, handoffPositionSwitch_lfy, notHandoffPositionSwitch_lfd, notHandoffPositionSwitch_lfs, storagePositionSwitch_lfz,};
        diamondList = new DiamondSwitch[]{hooksClampedStatusSwitch_lfc, hooksUnclampedStatusSwitch_lfc,
            hooksUnclampedStatusSwitch_lfy,
            notUnderClampedStatusSwitch_lfu, notOverClampedStatusSwitch_lfc, notOverClampedStatusSwitch_lfu,
            notOverClampedStatusSwitch_lfx, notOverClampedStatusSwitch_lfy, notOverClampedStatusSwitch_lfz,
            hooksClosedSwitch_lfc, hooksClosedSwitch_lfx, notClosedSwitch_lfd, notClosedSwitch_lfs, notClosedSwitch_lfu,
            openedSwitch_lfu, openedSwitch_lfz, notOpenedSwitch_lfd,
            defaultStatusDiamond1, defaultStatusDiamond2, noLfsStatusDiamond, filterGoodPositionSwitch_lfc, filterGoodPositionSwitch_lfs,
            safetyBeltPresenceSwitch1
        };
        initComponents();
    }
    
    public void updateCarrier(StatusDataPublishedByLoaderCarrier status) {
        SwingUtilities.invokeLater(new UpdateCarrier(status));
    }
    
    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateLoader(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new UpdateLoader(status));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     */
    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        /**
         *******************************************************************************
         * Whole panel
         ********************************************************************************
         */
        setBorder(javax.swing.BorderFactory.createTitledBorder("LOADER PROTECTION SYSTEM"));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.WEST;
        gbc.gridx = 0;
        gbc.gridy = 0;
        System.out.println("CARRIER RELAY first line gbc.gridy=" + gbc.gridy);
        JLabel jlabel1 = new JLabel(LABEL1);
        jlabel1.setFont(BIG_FONT);
        add(jlabel1, gbc);
        
        gbc.gridx++;
        add(create_acStatusPanel(ap2Switch1, af0Switch1, "AF0"), gbc);
        
        gbc.gridx++;
        add(create_lfcPanel(), gbc);
        
        gbc.gridx++;
        add(new HorizontalLine(), gbc);

        gbc.gridx++;
        gbc.gridheight = 2;
        int vl1_gridx = gbc.gridx;
        add(new VerticalLine(300, 100), gbc);

        gbc.gridx++;
        add(createPanelWithComponent(notDefault, defaultStatusDiamond1, true, false), gbc);

        gbc.gridx++;
        add(createPanelWithComponent(notLFS, noLfsStatusDiamond, true, true), gbc);
        
        gbc.gridx++;
        gbc.gridheight = 3;
        int vl2_gridx = gbc.gridx;
        add(new VerticalLine(400, 150), gbc);
        
        gbc.gridx++;
        add(createPanelWithComponent(lockout, lockoutSwitch1, true, false), gbc);
        gbc.gridx++;
        add(createPanelWithComponent(safetyBelt, safetyBeltPresenceSwitch1, true, false), gbc);
        gbc.gridx++;
        add(createPanelWithComponent(carrierRelay, carrierRelayRectangle, true, false), gbc);        
        
        /**
         * End of First Horizontal line for CARRIER RELAY
         */

        /**
         * Second line
         */
        gbc.gridy = gbc.gridy + 1;
        System.out.println("CARRIER RELAY second line gbc.gridy=" + gbc.gridy);
        gbc.gridx = 0;
        JLabel jlabel2 = new JLabel(LABEL2);
        jlabel2.setFont(BIG_FONT);
        add(jlabel2, gbc);
        gbc.gridx++;
        JPanel ap2Panel = createPanelWithComponent("<BR>AP2</BR>", ap2Switch3, false, true, 20);
        ap2Panel.setBorder(BorderFactory.createTitledBorder("AC Status"));
        add(ap2Panel, gbc);
        gbc.gridx++;
        add(createPanelWithComponent("", create_lfuPanel(), false, true, 200), gbc);
        gbc.gridx++;
        add(new HorizontalLine(30), gbc);
        /**
         * End of second line for CARRIER RELAY
         */
        /**
         * Third line for CARRIER RELAY
         */
        gbc.gridy = gbc.gridy + 4;
        gbc.gridx = 0;
        System.out.println("CARRIER RELAY third line gbc.gridy=" + gbc.gridy);
        JLabel jlabel3 = new JLabel(LABEL3);
        jlabel3.setFont(BIG_FONT);
        add(jlabel3, gbc);
        gbc.gridx++;
        add(createPanelWithComponent(engineering, engineeringSwitch, false, true), gbc);
        gbc.anchor = GridBagConstraints.SOUTH;
        gbc.gridx++;
        add(new HorizontalLine(760), gbc);
        gbc.gridx++;
        add(new HorizontalLine(), gbc);
        gbc.gridx++;
        add(new HorizontalLine(15), gbc);
        gbc.gridx++;
        add(new HorizontalLine(150), gbc);
        gbc.gridx++;
        add(new HorizontalLine(150), gbc);

        //Hooks Relay first line
        gbc.anchor = GridBagConstraints.WEST;
        gbc.gridy = gbc.gridy + 4;
        System.out.println("Hooks RELAY first line gbc.gridy=" + gbc.gridy);
        int hooks_l1_gridy = gbc.gridy;
        gbc.gridx = 0;
        JLabel jlabel1_2 = new JLabel(LABEL1);
        jlabel1_2.setFont(BIG_FONT);
        add(jlabel1_2, gbc);
        gbc.gridx++;
        add(create_acStatusPanel(ap2Switch2, af0Switch2, "AF0"), gbc);
        gbc.gridx++;
        add(create_lfxPanel(), gbc);
        gbc.gridx++;
        add(new HorizontalLine(), gbc);
        System.out.println("Hooks RELAY end first line gbc.gridx=" + gbc.gridx);

        //Hooks Relay second line
        gbc.gridy = gbc.gridy + 4;
        System.out.println("Hooks RELAY second line gbc.gridy=" + gbc.gridy);
        gbc.gridx = 0;
        JLabel jlabel2_2 = new JLabel(LABEL2);
        jlabel2_2.setFont(BIG_FONT);
        add(jlabel2_2, gbc);
        gbc.gridx++;
        add(create_acStatusPanel(ap2Switch4, af3Switch, "AF3"), gbc);
        gbc.gridx++;
        add(create_lfyPanel(), gbc);
        gbc.gridx++;
        add(new HorizontalLine(), gbc);
        System.out.println("Hooks RELAY end second line gbc.gridx=" + gbc.gridx);

        
        //Hooks Relay third line
        gbc.gridy = gbc.gridy + 4;
        gbc.gridx = 0;
        System.out.println("Hooks RELAY third line gbc.gridy=" + gbc.gridy);
        JLabel jlabel4 = new JLabel(LABEL4);
        jlabel4.setFont(BIG_FONT);
        add(jlabel4, gbc);
        gbc.gridx = gbc.gridx + 2;
        add(create_lfzPanel(), gbc);
        gbc.gridx++;
        add(new HorizontalLine(), gbc);
        int hooks_l3_gridy = gbc.gridy;
        System.out.println("Hooks RELAY end third line gbc.gridx=" + gbc.gridx);

        //Hooks Relay No default Status
        gbc.gridy = hooks_l1_gridy;
        gbc.gridx = vl1_gridx;
        gbc.gridheight = 10;
        add(new VerticalLine(300, 100), gbc);
        gbc.gridx++;
        add(createPanelWithComponent(notDefault, defaultStatusDiamond2, true, true), gbc);

        //Hooks Relay 2nd Vertical Line
        gbc.gridx = vl2_gridx;
        gbc.gridheight = 10;
        add(new VerticalLine(400, 50), gbc);

        //Hooks Relay
        gbc.gridx++;
        add(createPanelWithComponent(lockout, lockoutSwitch2, true, false), gbc);
        gbc.gridx++;
        add(createPanelWithComponent(safetyBelt, safetyBeltPresenceSwitch2, true, false), gbc);
        gbc.gridx++;
        add(createPanelWithComponent(hooksRelay, hooksRelayRectangle, true, false), gbc);

        /**
         * LFS Panel
         */
        gbc.gridheight = 10;
        gbc.gridy = hooks_l3_gridy + 4;
        gbc.gridx = 2;
        add(create_lfsPanel(), gbc);
        
        /**
         * LFD Panel
         */
        gbc.gridheight = 10;
        gbc.gridy = gbc.gridy + 14;
        gbc.gridx = 2;
        add(create_lfdPanel(), gbc);

        /* set default values for whole panel*/
        setDefaultValues();
        
    }
    
        
    private JPanel create_lfcPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("LFC"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent(loaderDocked, loaderDockedDigitalSwitch_lfc, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(closed, hooksClosedSwitch_lfc, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(filterPresence, filterPresenceSwitch_lfc, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(notOverClamped, notOverClampedStatusSwitch_lfc, true, true), gbcp);
        gbcp.gridx++;
        panel.add(create_lfcSubpanel(), gbcp);
        gbcp.gridx++;
        panel.add(new HorizontalLine(), gbcp);
        return panel;
    }
    
    private JPanel create_lfcSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;


        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);

        /* upper line */
        gbcp.gridx++;
        gbcp.gridheight = 1;
        panel.add(createPanelWithComponent(filterPosition, filterGoodPositionSwitch_lfc, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(clamped, hooksClampedStatusSwitch_lfc, true, false), gbcp);

        /* lower line */
        gbcp.gridy++;
        gbcp.gridx = 1;
        panel.add(createPanelWithComponent(engaged, engagedPositionSwitch_lfc, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(unclamped, hooksUnclampedStatusSwitch_lfc, true, false), gbcp);
        gbcp.gridx++;

        /* last vertical line*/
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);
        return panel;
    }
    
   private JPanel create_lfdPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("LFD"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent(notHandoff, notHandoffPositionSwitch_lfd, false, true), gbcp);
        gbcp.gridx++;
        panel.add(create_lfdSubpanel(), gbcp);
        return panel;
    }
   
    private JPanel create_lfdSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;

        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);
        
        /* upper line */
        gbcp.gridx++;
        gbcp.gridheight = 1;
        panel.add(createPanelWithComponent(notClosed, notClosedSwitch_lfd, true, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(filterPresence, filterPresenceSwitch_lfd, false, true), gbcp); 

        /* lower line */
        gbcp.gridy++;
        gbcp.gridx = 1;
        panel.add(createPanelWithComponent(notOpened, notOpenedSwitch_lfd, true, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(noFilterPresence, notFilterPresenceSwitch_lfd, false, true), gbcp);
        gbcp.gridx++;
        
        /* last vertical line*/
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);
        return panel;
    }


    private JPanel create_lfsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("LFS"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent(loaderDocked, loaderDockedDigitalSwitch_lfs, false, true), gbcp);
        gbcp.gridx++;
        panel.add(create_lfsSubpanel(), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(notHandoff, notHandoffPositionSwitch_lfs, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(notClosed, notClosedSwitch_lfs, true, false), gbcp);
        return panel;
    }
    


    private JPanel create_lfsSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.NORTH;
        gbcp.gridx = 0;
        gbcp.gridy = 0;

        /* upper line */
        addToHorizontalLine(panel, gbcp, filterPosition, filterGoodPositionSwitch_lfs, true);

        /* lower line */
        gbcp.gridx = 0;
        gbcp.gridy = 2;
        addToHorizontalLine(panel, gbcp, filterPresence, filterPresenceSwitch_lfs, true);
        return panel;
    }

    private JPanel create_lfuPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("LFU"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent(loaderDocked, loaderDockedDigitalSwitch_lfu, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(opened, openedSwitch_lfu, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(notUnderClamped, notUnderClampedStatusSwitch_lfu, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(notOverClamped, notOverClampedStatusSwitch_lfu, true, true), gbcp);
        return panel;
    }

    private JPanel create_lfxPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent(loaderDocked, loaderDockedDigitalSwitch_lfx, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(notOverClamped, notOverClampedStatusSwitch_lfx, true, true), gbcp);
        gbcp.gridx++;
        panel.add(create_lfxSubpanel(), gbcp);
        return panel;
    }

    private JPanel create_lfxSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;

        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);

        /* upper line */
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        panel.add(createPanelWithComponent(handoff, handoffPositionSwitch_lfx, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(filterPresence, filterPresenceSwitch_lfx, true, false), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(closed, hooksClosedSwitch_lfx, true, true), gbcp);

        /* lower line */
        gbcp.gridy++;
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        panel.add(createPanelWithComponent(engaged, engagedPositionSwitch_lfx, true, true), gbcp);
        gbcp.gridx++;

        /* last vertical line*/
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        gbcp.gridx = gbcp.gridx + 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);
        return panel;
    }
    
    public JPanel create_lfyPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent(loaderDocked, loaderDockedDigitalSwitch_lfy, true, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(notOverClamped, notOverClampedStatusSwitch_lfy, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(handoff, handoffPositionSwitch_lfy, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(filterPresence, filterPresenceSwitch_lfy, false, true), gbcp);      
        gbcp.gridx++;
        panel.add(createPanelWithComponent(unclamped, hooksUnclampedStatusSwitch_lfy, false, true), gbcp); 
        return panel;
    }
    
    public JPanel create_lfzPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent(engaged, notOverClampedStatusSwitch_lfz, false, true), gbcp);
        gbcp.gridx++;
        panel.add(create_lfzSubpanel(), gbcp);
        return panel;
    }
    
    public JPanel create_lfzSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);

        /* upper line */
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        panel.add(createPanelWithComponent(loaderDocked, loaderDockedDigitalSwitch_lfz, true, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(engaged, engagedPositionSwitch_lfz, false, true), gbcp);
        gbcp.gridx++;
        
        panel.add(createPanelWithComponent(noFilterPresence, notFilterPresenceSwitch_lfz, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent(opened, openedSwitch_lfz, false, true), gbcp);
        gbcp.gridx++;

        /* lower line */
        gbcp.gridy++;
        gbcp.gridx = 1;
        panel.add(createPanelWithComponent(storage, storagePositionSwitch_lfz, true, true), gbcp);
        gbcp.gridx++;
        panel.add(new HorizontalLine(), gbcp);

        /* last vertical line*/
        gbcp.gridy = 0;
        gbcp.gridx = 5;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);
        return panel;
    }
    
    /*
     * 
     * AC Status Panels
     */
    
    private static JPanel create_acStatusPanel(DigitalSwitch ap2s, DigitalSwitch af0s, String afName) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("AC Status"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.NORTH;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent("<BR>AP2</BR>", ap2s, false, true, 20), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("<BR>" + afName + "</BR>", af0s, false, true, 20), gbcp);
        return panel;
    }
    
    /**
     * Initialization to be done when Loader subsystem is not yet booted or is shutdown.
     */
    private void setDefaultValues() {
        for (DigitalSwitch c : digitalList) {
            c.setColor(Color.gray);
        }
        for (DiamondSwitch c : diamondList) {
            c.setColor(Color.gray);
        }
        filterGoodPositionSwitch_lfc.setColor(Color.gray);
        filterGoodPositionSwitch_lfs.setColor(Color.gray);
        defaultStatusDiamond1.setColor(Color.gray);
        defaultStatusDiamond2.setColor(Color.gray);
        safetyBeltPresenceSwitch1.setColor(Color.gray);
        safetyBeltPresenceSwitch2.setColor(Color.gray);
        carrierRelayRectangle.setColor(Color.gray);
        hooksRelayRectangle.setColor(Color.gray);
    }

    /**
     * Reset components to default values.
     */
    public void resetPanel() {
        setDefaultValues();
    }

    
    @Override
    public String toString() {
        return "PLC Loader Panel";
    }

    /**
     * Create a Panel with a component name to display above the component and a
     * component.
     *
     * @param componentName
     * @param component
     * @param drawHLineBefore if true an horizontal line is drawn before the
     * component
     * @param drawHLineAfter if false an horizontal line is drawn after the
     * component
     * @return
     */
    public static JPanel createPanelWithComponent(String componentName, JComponent component, boolean drawHLineBefore, boolean drawHLineAfter) {
        int length = 30;
        return createPanelWithComponent(componentName, component, drawHLineBefore, drawHLineAfter, length);
    }
    
    /**
     * Create a Panel with a component name to display above the component and a
     * component.
     *
     * @param componentName
     * @param component
     * @param drawHLineBefore if true an horizontal line is drawn before the
     * component
     * @param drawHLineAfter if false an horizontal line is drawn after the
     * component
     * @param length of the lines
     * @return
     */
    public static JPanel createPanelWithComponent(String componentName, JComponent component, boolean drawHLineBefore, boolean drawHLineAfter,
            int length) {
        int hlStartingY;
        if (component instanceof DigitalSwitch) {
            hlStartingY = 10;
        } else if (component instanceof DiamondSwitch) {
            hlStartingY = 25;
        } else {
            hlStartingY = 5;
        }
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        if (drawHLineBefore) {
            gbcp.gridy++;
            panel.add(new HorizontalLine(length, hlStartingY), gbcp);
            gbcp.gridx++;
        }
        /* label line*/
        gbcp.gridy = 0;
        panel.add(new JLabel("<HTML><CENTER>" + componentName + "</CENTER></HTML>"), gbcp);
        /* component line */
        gbcp.gridy++;
        panel.add(component, gbcp);
        if (drawHLineAfter) {
            gbcp.gridx++;
            panel.add(new HorizontalLine(length, hlStartingY), gbcp);
        }
        return panel;
    }

    /**
     * to add a component to the right on a horizontal line
     *
     * @param panel
     * @param gbcl
     * @param componentName
     * @param component
     * @param drawLine if true draw an HorizontalLine after the component
     */
    public static void addToHorizontalLine(JPanel panel, GridBagConstraints gbcl, String componentName, JComponent component, boolean drawLine) {
        int hlStartingY = 15;
        /* label line */
        panel.add(new JLabel("<HTML><CENTER>" + componentName + "</CENTER></HTML>"), gbcl);
        /* component line */
        gbcl.gridy++;
        panel.add(component, gbcl);
        if (drawLine) {
            gbcl.gridx++;
            panel.add(new HorizontalLine(hlStartingY), gbcl);
        }
        gbcl.gridy--;
        if (drawLine) {
            gbcl.gridx++;
        }
    }
    
}
