
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import static javax.swing.JTable.AUTO_RESIZE_ALL_COLUMNS;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.NICE_PINK;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.resetTable;

/**
 * A penel to display carousel brakes information.
 * @author virieux
 */
public class BrakesPanel extends JPanel {
    
    private JTable brakesTable;
    private JScrollPane jScrollPane;
    private final DecimalFormat formatter = new DecimalFormat("#####0.0");


    public BrakesPanel() {
        initComponents();
    }
    
    /**
     * A Runnable class to update this panel from an object StatusDataPublishedByCarousel.
     */
    public class Update implements Runnable {
        private final StatusDataPublishedByCarousel s;

        public Update(StatusDataPublishedByCarousel s) {
            this.s = s;
        }

        @Override
        public void run() {
            DefaultTableModel filterTableModel = (DefaultTableModel) brakesTable.getModel();
            /* bay D first line (0)*/
            brakesTable.setValueAt(s.getCurrent(), 0, 3);
            brakesTable.setValueAt(formatter.format(s.getTemperature1()), 0, 4);
            
            /* bay I second line (1)*/
            brakesTable.setValueAt(s.getBrakeState1().toString(), 1, 2);
            brakesTable.setValueAt(s.getSensor1(), 1, 3);
            brakesTable.setValueAt(formatter.format(s.getTemperature2()), 1, 4);
            
            /* bay N third line (2)*/
            brakesTable.setValueAt(s.getBrakeState2().toString(), 2, 2);
            brakesTable.setValueAt(s.getSensor2(), 2, 3);
            brakesTable.setValueAt(formatter.format(s.getTemperature3()), 2, 4);
            
            /* bay X fourth line (3)*/
            brakesTable.setValueAt(s.getBrakeState3().toString(), 3, 2);
            brakesTable.setValueAt(s.getSensor3(), 3, 3);
            brakesTable.setValueAt(formatter.format(s.getTemperature4()), 3, 4);
            
            filterTableModel.fireTableDataChanged();
        }
    }
    
    /**
     * A Runnable class to update this panel from an object StatusDataPublishedByEPOSController.
     */
    public class UpdateController implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        public UpdateController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            DefaultTableModel filterTableModel = (DefaultTableModel) brakesTable.getModel();
            /* bay D first line */
            brakesTable.setValueAt(s.getState().toString(), 0, 2);
            filterTableModel.fireTableDataChanged();
        }
    }
    
    protected void update(StatusDataPublishedByCarousel s) {
        SwingUtilities.invokeLater(new Update(s));
    }
    
    protected void updateController(StatusDataPublishedByEPOSController s) {
        SwingUtilities.invokeLater(new UpdateController(s));
    }

    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description">
    private void initComponents() {
        
        /**
         ******************************************************************************
         ** Brakes Table
         * *****************************************************************************
         */
        jScrollPane = new JScrollPane();
        brakesTable = new JTable();
        brakesTable.setModel(new DefaultTableModel(
                new Object[][]{},
                new String[]{
                    "TYPE", "BAY", "STATE", "SENSOR VALUE", "TEMPERATURE"
                }
        ) {
            private static final long serialVersionUID = -6158042587124966771L;
            private final Class[] types = new Class[]{
                String.class, String.class, String.class, Integer.class, Integer.class
            };
            private final boolean[] canEdit = new boolean[]{
                false, false, false, false, false};

            @Override
            public Class getColumnClass(int columnIndex) {
                return types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit[columnIndex];
            }
        });
        brakesTable.setName("brakesTable");
        /* first column initialization */
        DefaultTableModel brakesTableModel = (DefaultTableModel) brakesTable.getModel();
        Object[] row1 = {"Motor", "D", "UNKNOWN", 0, 0};
        brakesTableModel.addRow(row1);
        Object[] row2 = {"Brake", "I", "UNKNOWN", 0, 0};
        brakesTableModel.addRow(row2);
        Object[] row3 = {"Brake", "N", "UNKNOWN", 0, 0};
        brakesTableModel.addRow(row3); 
        Object[] row4 = {"Brake", "X", "UNKNOWN", 0, 0};
        brakesTableModel.addRow(row4);        
        brakesTableModel.fireTableDataChanged();
        
        /* size */
        TableColumn column;
        int rowNB = brakesTable.getModel().getRowCount();
        for (int i = 0; i < rowNB; i++) {
            column = brakesTable.getColumnModel().getColumn(i);
            if (i == 2) {
                column.setPreferredWidth(130); //second column is bigger to display controller state
            } else if (i == 3 || i == 4) {
                column.setPreferredWidth(60);
            }
        }
        brakesTable.setAutoResizeMode(AUTO_RESIZE_ALL_COLUMNS);
        jScrollPane.setPreferredSize(new java.awt.Dimension(500, 100));

        jScrollPane.setViewportView(brakesTable);
        /**
         ******************************************************************************
         ** end of Brakes Table
         * *****************************************************************************
         */
        
        //Whole Panel
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(NICE_PINK),"Carousel Brakes"));

        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();

        gbc.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(jScrollPane, gbc);
    }
    
    /**
     * Remove data on panel.
     * To be used when subsystem is disconnecting.
     */
    public void resetPanel() {
        resetTable(brakesTable);
    }
    
    
    /**
     * Just for tests.
     *
     * @param argv
     */
    public static void main(String[] argv) {

        BrakesPanel p = new BrakesPanel();

        JFrame frame = new JFrame("Brakes Panel");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
    
    
}
