
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import static org.lsst.ccs.subsystems.fcs.loader.ui.PLCLoaderPanel.SP_V_LINE_HEIGHT;
import static org.lsst.ccs.subsystems.fcs.loader.ui.PLCLoaderPanel.SP_V_LINE_STARTINGY;
import static org.lsst.ccs.subsystems.fcs.loader.ui.PLCLoaderPanel.createPanelWithComponent;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.HorizontalLine;
import org.lsst.ccs.subsystems.fcs.ui.commons.RectangleSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalLine;

/**
 *
 * @author virieux
 */
public class PLCAutochangerPanel extends JPanel {

    private final String engineering = "Autochanger<BR>Engineering<BR>Mode";
    private final String lockout = "Lock Out Bay M";
    private final String lockoutShunt = "Lock Out Shunt Bay M";

    private final DigitalSwitch ap3Switch = new DigitalSwitch();
    private final DigitalSwitch af3Switch = new DigitalSwitch();
    private final DigitalSwitch ainSwitch = new DigitalSwitch();
    private final DigitalSwitch lockoutSwitch = new DigitalSwitch();
    private final DigitalSwitch lockoutShuntSwitch = new DigitalSwitch();
    private final DigitalSwitch engineeringSwitch = new DigitalSwitch();

    /* Relays*/
    private final RectangleSwitch clampsRelayRectangle = new RectangleSwitch();
    private final RectangleSwitch latchesRelayRectangle = new RectangleSwitch();

    public PLCAutochangerPanel() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     */
    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        /**
         *******************************************************************************
         * Whole panel
         * *******************************************************************************
         */
        setBorder(javax.swing.BorderFactory.createTitledBorder("AUTOCHANGER PROTECTION SYSTEM"));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.WEST;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(new JLabel("COUCOU"), gbc);
        gbc.gridy++;
        add(create_clampsPanel(), gbc);
        gbc.gridy++;
        add(create_latchesPanel(), gbc);
        gbc.gridy++;
        add(create_linearRailsPanel(), gbc);

    }

    private JPanel create_clampsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Clamps"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add(createPanelWithComponent("AP3", ap3Switch, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AF3", af3Switch, false, true), gbcp);
        gbcp.gridx++;
        panel.add(createPanelWithComponent("AIN", ainSwitch, false, true), gbcp);
        gbcp.gridx++;

        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);
        gbcp.gridx++;
        panel.add(new HorizontalLine(), gbcp);
        int lock_gridx = gbcp.gridx;
        panel.add(create_lockoutSubPanel(lockoutSwitch, lockoutShuntSwitch), gbcp);

        gbcp.gridheight = 1;
        gbcp.gridx = 0;
        gbcp.gridy++;
        panel.add(createPanelWithComponent(engineering, engineeringSwitch, false, true), gbcp);

        gbcp.gridx = lock_gridx;
        gbcp.gridy = 0;


        return panel;
    }

    private JPanel create_latchesPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Latches"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        return panel;
    }

    private JPanel create_linearRailsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Enable Linear Rails"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        return panel;
    }

    private JPanel create_lockoutSubPanel(DigitalSwitch lockSwitch, DigitalSwitch lockShuntSwitch) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = GridBagConstraints.CENTER;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);

        /* upper line */
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        panel.add(createPanelWithComponent(lockout, lockSwitch, true, true), gbcp);
        gbcp.gridx++;

        /* lower line */
        gbcp.gridy++;
        gbcp.gridx = 1;
        panel.add(createPanelWithComponent(lockoutShunt, lockShuntSwitch, true, true), gbcp);
        gbcp.gridx++;
        panel.add(new HorizontalLine(), gbcp);

        /* last vertical line*/
        gbcp.gridy = 0;
        gbcp.gridx = 5;
        gbcp.gridheight = 2;
        panel.add(new VerticalLine(SP_V_LINE_HEIGHT, SP_V_LINE_STARTINGY), gbcp);
        return panel;
    }

    @Override
    public String toString() {
        return "PLC Autochanger Panel";
    }
}
