package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import static org.lsst.ccs.subsystems.fcs.FCSCst.CHANGER_TCPPROXY_NAME;

import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;

/**
 *
 * @author virieux
 */
public class AutochangerGUI extends GeneralGUI implements InterfaceAutochangerGUI {
    private static final long serialVersionUID = 1528028505886594591L;

    
    private long timeoutForTrucksMotion;
    private long timeoutForOnlineClampMotion;
    //TODO retrieve timeoutForLatchesMotion from configuration system
    private long timeoutForLatchesMotion = 10000;

    public AutochangerGUI(String name, String role, AgentMessagingLayer aml) {
        super(name, role, aml);
        AutochangerGatherPanel autochangerGatherPanel;
        autochangerGatherPanel = new AutochangerGatherPanel(this, CHANGER_TCPPROXY_NAME);
        AutochangerBottomPanel autochangerBottomPanel = new AutochangerBottomPanel(autochangerGatherPanel,
                "AUTOCHANGER");
        this.generalPanel = new GeneralPanel(this, autochangerBottomPanel);
        pane = new JScrollPane(generalPanel);
    }

    @Override
    public long getTimeoutForTrucksMotion() {
        return timeoutForTrucksMotion;
    }

    @Override
    public long getTimeoutForOnlineClampMotion() {
        return timeoutForOnlineClampMotion;
    }

    @Override
    public long getTimeoutForLatchesMotion() {
        return timeoutForLatchesMotion;
    }

    @Override
    public void setTimeoutForTrucksMotion(long timeoutForTrucksMotion) {
        this.timeoutForTrucksMotion = timeoutForTrucksMotion;
    }

    @Override
    public void setTimeoutForOnlineClampMotion(long timeoutForOnlineClampMotion) {
        this.timeoutForOnlineClampMotion = timeoutForOnlineClampMotion;
    }

    @Override
    public void setTimeoutForLatchesMotion(long timeoutForLatchesMotion) {
        this.timeoutForLatchesMotion = timeoutForLatchesMotion;
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        Agent agent = new Agent("AutochangerGUI", AgentInfo.AgentType.CONSOLE);
        AutochangerGUI t = new AutochangerGUI(agent.getName(), "Autochanger", agent.getMessagingAccess());
        agent.startAgent();

        JFrame frame = new JFrame("Autochanger View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

}
