/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;

public class Tools {
    public static final Color greenColor = new Color(0, 165, 0);
    public static final Color NICE_PINK = new Color(255, 0, 255);
    public static final String fcsFontInString = "Lucida Grande";
    public static final Font BIG_FONT = new Font("Lucida Grande", 1, 14);
    public static final Font HUGE_FONT = new Font("Lucida Grande", 1, 20);
    public static final Font VERY_BIG_FONT = new Font("Tahoma", 1, 18);
    public static final Insets insets_std = new Insets(4, 4, 4, 4);
    public static final Insets insets_big = new Insets(14, 4, 6, 4);
    public static final Insets insets_small = new Insets(1, 1, 1, 1);
    public static final String ZERO_VALUE = "0.0";
    public static final String UNKNOWN_VALUE = "999.99";
    public static final String UNKNOWN_STATE = "UNKNOWN STATE";
    public static final String UNKNOWN_ERROR = "UNKNOWN ERROR";
    public static final String NONE = "None";
    public static final String TIRETS = "--";
    public static final Dimension preferedPanelSize = new Dimension(1200, 600);

    public static Color getFilterPresenceColor(String filterPresenceStatus) {
        if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.ERROR.toString())) {
            return Color.red;
        }
        if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.LOCKABLE.toString())) {
            return greenColor;
        }
        if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE.toString())) {
            return Color.orange;
        }
        if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.NOFILTER.toString())) {
            return Color.gray;
        }
        FCSCst.FCSLOG.error((Object)("Unknown Filter Presence Status " + filterPresenceStatus));
        return Color.gray;
    }

    public static int toInt(Map<String, String> config, String parameterName) {
        if (config.containsKey(parameterName)) {
            return Integer.parseInt(config.get(parameterName));
        }
        FCSCst.FCSLOG.error((Object)("no such parameter in ConfigurationInfo:" + parameterName));
        return 0;
    }

    public static void resetTable(JTable table) {
        FCSCst.FCSLOG.fine((Object)(" resetting table " + table.getName()));
        DefaultTableModel tableModel = (DefaultTableModel)table.getModel();
        tableModel.getDataVector().removeAllElements();
        tableModel.fireTableDataChanged();
    }

    public static String getShortComponentName(String fullPathName) {
        int ind = fullPathName.lastIndexOf("/");
        return ind >= 0 ? fullPathName.substring(ind + 1) : fullPathName;
    }
}

