/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.ui.commons.DiamondSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.HorizontalLine;
import org.lsst.ccs.subsystems.fcs.ui.commons.RectangleSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalLine;

public class PLCLoaderPanel
extends JPanel {
    public static final int SP_V_LINE_HEIGHT = 75;
    public static final int SP_V_LINE_STARTINGY = 22;
    private static final String LABEL1 = "<HTML>On camera<BR>Filter hold</BR><BR>by Loader</BR></HTML>";
    private static final String LABEL2 = "<HTML>On camera<BR>Filter hold</BR><BR>by AC</BR></HTML>";
    private static final String LABEL3 = "<HTML><BR>Engineering</BR><BR>mode</BR></HTML>";
    private static final String LABEL4 = "<HTML>On camera<BR>Without Filter</BR></HTML>";
    private final String loaderDocked = "Loader<BR>Docked";
    private final String notDefault = "NO<BR>Default Status";
    private final String notLFS = "NO<BR>LFS Status";
    private final String lockout = "Loader<BR>Lock Out<BR>Bay M";
    private final String engineering = "Loader<BR>Engineering<BR>Mode";
    private final String safetyBelt = "Safety<BR>Belt<BR>Presence";
    private final String closed = "Hooks<BR>Closed</BR>";
    private final String clamped = "Hooks<BR>Clamped</BR>";
    private final String unclamped = "Hooks<BR>Unclamped</BR>";
    private final String notClosed = "Hooks NOT<BR>Closed</BR>";
    private final String opened = "Hooks<BR>Opened</BR>";
    private final String notOpened = "Hooks NOT<BR>Opened</BR>";
    private final String notUnderClamped = "Hooks NOT<BR>Under Clamped</BR>";
    private final String notOverClamped = "Hooks NOT<BR>Over Clamped</BR>";
    private final String filterPresence = "Filter<BR>Presence</BR>";
    private final String noFilterPresence = "Filter<BR>Not Present</BR>";
    private final String filterPosition = "Filter<BR>Position</BR>";
    private final String engaged = "Carrier<BR>at ENGAGED</BR>";
    private final String handoff = "Carrier<BR>at HANDOFF</BR>";
    private final String storage = "Carrier<BR>at STORAGE</BR>";
    private final String notHandoff = "Carrier<BR>NOT at HANDOFF</BR>";
    private final String carrierRelay = "<BR>Carrier<BR>Relay</BR>";
    private final String hooksRelay = "Hooks<BR>Relay</BR>";
    private final DigitalSwitch loaderDockedDigitalSwitch_lfc = new DigitalSwitch();
    private final DigitalSwitch loaderDockedDigitalSwitch_lfs = new DigitalSwitch();
    private final DigitalSwitch loaderDockedDigitalSwitch_lfu = new DigitalSwitch();
    private final DigitalSwitch loaderDockedDigitalSwitch_lfx = new DigitalSwitch();
    private final DigitalSwitch loaderDockedDigitalSwitch_lfy = new DigitalSwitch();
    private final DigitalSwitch loaderDockedDigitalSwitch_lfz = new DigitalSwitch();
    private final DigitalSwitch ap2Switch1 = new DigitalSwitch();
    private final DigitalSwitch ap2Switch2 = new DigitalSwitch();
    private final DigitalSwitch ap2Switch3 = new DigitalSwitch();
    private final DigitalSwitch ap2Switch4 = new DigitalSwitch();
    private final DigitalSwitch af0Switch1 = new DigitalSwitch();
    private final DigitalSwitch af0Switch2 = new DigitalSwitch();
    private final DigitalSwitch af3Switch = new DigitalSwitch();
    private final DigitalSwitch lockoutSwitch1 = new DigitalSwitch();
    private final DigitalSwitch lockoutSwitch2 = new DigitalSwitch();
    private final DigitalSwitch engineeringSwitch = new DigitalSwitch();
    private final DigitalSwitch filterPresenceSwitch_lfc = new DigitalSwitch();
    private final DigitalSwitch filterPresenceSwitch_lfd = new DigitalSwitch();
    private final DigitalSwitch filterPresenceSwitch_lfs = new DigitalSwitch();
    private final DigitalSwitch filterPresenceSwitch_lfx = new DigitalSwitch();
    private final DigitalSwitch filterPresenceSwitch_lfy = new DigitalSwitch();
    private final DigitalSwitch notFilterPresenceSwitch_lfd = new DigitalSwitch();
    private final DigitalSwitch notFilterPresenceSwitch_lfz = new DigitalSwitch();
    private final DigitalSwitch engagedPositionSwitch_lfc = new DigitalSwitch();
    private final DigitalSwitch engagedPositionSwitch_lfx = new DigitalSwitch();
    private final DigitalSwitch engagedPositionSwitch_lfz = new DigitalSwitch();
    private final DigitalSwitch handoffPositionSwitch_lfx = new DigitalSwitch();
    private final DigitalSwitch handoffPositionSwitch_lfy = new DigitalSwitch();
    private final DigitalSwitch notHandoffPositionSwitch_lfs = new DigitalSwitch();
    private final DigitalSwitch notHandoffPositionSwitch_lfd = new DigitalSwitch();
    private final DigitalSwitch storagePositionSwitch_lfz = new DigitalSwitch();
    private final DigitalSwitch[] digitalList;
    private final DiamondSwitch[] diamondList;
    private final DiamondSwitch hooksClampedStatusSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch hooksUnclampedStatusSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch hooksUnclampedStatusSwitch_lfy = new DiamondSwitch();
    private final DiamondSwitch notUnderClampedStatusSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfx = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfy = new DiamondSwitch();
    private final DiamondSwitch notOverClampedStatusSwitch_lfz = new DiamondSwitch();
    private final DiamondSwitch hooksClosedSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch hooksClosedSwitch_lfx = new DiamondSwitch();
    private final DiamondSwitch notClosedSwitch_lfd = new DiamondSwitch();
    private final DiamondSwitch notClosedSwitch_lfs = new DiamondSwitch();
    private final DiamondSwitch notClosedSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch notOpenedSwitch_lfd = new DiamondSwitch();
    private final DiamondSwitch openedSwitch_lfu = new DiamondSwitch();
    private final DiamondSwitch openedSwitch_lfz = new DiamondSwitch();
    private final DiamondSwitch defaultStatusDiamond1 = new DiamondSwitch();
    private final DiamondSwitch defaultStatusDiamond2 = new DiamondSwitch();
    private final DiamondSwitch noLfsStatusDiamond = new DiamondSwitch();
    private final DiamondSwitch filterGoodPositionSwitch_lfc = new DiamondSwitch();
    private final DiamondSwitch filterGoodPositionSwitch_lfs = new DiamondSwitch();
    private final DiamondSwitch safetyBeltPresenceSwitch1 = new DiamondSwitch();
    private final DiamondSwitch safetyBeltPresenceSwitch2 = new DiamondSwitch();
    private final RectangleSwitch carrierRelayRectangle = new RectangleSwitch();
    private final RectangleSwitch hooksRelayRectangle = new RectangleSwitch();

    public PLCLoaderPanel() {
        this.digitalList = new DigitalSwitch[]{this.loaderDockedDigitalSwitch_lfc, this.loaderDockedDigitalSwitch_lfs, this.loaderDockedDigitalSwitch_lfu, this.loaderDockedDigitalSwitch_lfx, this.loaderDockedDigitalSwitch_lfy, this.loaderDockedDigitalSwitch_lfz, this.ap2Switch1, this.ap2Switch2, this.ap2Switch3, this.ap2Switch4, this.af0Switch1, this.af0Switch2, this.af3Switch, this.lockoutSwitch1, this.lockoutSwitch2, this.engineeringSwitch, this.filterPresenceSwitch_lfc, this.filterPresenceSwitch_lfd, this.filterPresenceSwitch_lfs, this.filterPresenceSwitch_lfx, this.filterPresenceSwitch_lfy, this.notFilterPresenceSwitch_lfz, this.engagedPositionSwitch_lfc, this.engagedPositionSwitch_lfx, this.engagedPositionSwitch_lfz, this.handoffPositionSwitch_lfx, this.handoffPositionSwitch_lfy, this.notHandoffPositionSwitch_lfd, this.notHandoffPositionSwitch_lfs, this.storagePositionSwitch_lfz};
        this.diamondList = new DiamondSwitch[]{this.hooksClampedStatusSwitch_lfc, this.hooksUnclampedStatusSwitch_lfc, this.hooksUnclampedStatusSwitch_lfy, this.notUnderClampedStatusSwitch_lfu, this.notOverClampedStatusSwitch_lfc, this.notOverClampedStatusSwitch_lfu, this.notOverClampedStatusSwitch_lfx, this.notOverClampedStatusSwitch_lfy, this.notOverClampedStatusSwitch_lfz, this.hooksClosedSwitch_lfc, this.hooksClosedSwitch_lfx, this.notClosedSwitch_lfd, this.notClosedSwitch_lfs, this.notClosedSwitch_lfu, this.openedSwitch_lfu, this.openedSwitch_lfz, this.notOpenedSwitch_lfd, this.defaultStatusDiamond1, this.defaultStatusDiamond2, this.noLfsStatusDiamond, this.filterGoodPositionSwitch_lfc, this.filterGoodPositionSwitch_lfs, this.safetyBeltPresenceSwitch1};
        this.initComponents();
    }

    public void updateCarrier(StatusDataPublishedByLoaderCarrier status) {
        SwingUtilities.invokeLater(new UpdateCarrier(status));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateLoader(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new UpdateLoader(status));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder("LOADER PROTECTION SYSTEM"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        System.out.println("CARRIER RELAY first line gbc.gridy=" + gbc.gridy);
        JLabel jlabel1 = new JLabel(LABEL1);
        jlabel1.setFont(Tools.BIG_FONT);
        this.add((Component)jlabel1, gbc);
        ++gbc.gridx;
        this.add((Component)PLCLoaderPanel.create_acStatusPanel(this.ap2Switch1, this.af0Switch1, "AF0"), gbc);
        ++gbc.gridx;
        this.add((Component)this.create_lfcPanel(), gbc);
        ++gbc.gridx;
        this.add((Component)new HorizontalLine(), gbc);
        ++gbc.gridx;
        gbc.gridheight = 2;
        int vl1_gridx = gbc.gridx++;
        this.add((Component)new VerticalLine(300, 100), gbc);
        this.add((Component)PLCLoaderPanel.createPanelWithComponent("NO<BR>Default Status", this.defaultStatusDiamond1, true, false), gbc);
        ++gbc.gridx;
        this.add((Component)PLCLoaderPanel.createPanelWithComponent("NO<BR>LFS Status", this.noLfsStatusDiamond, true, true), gbc);
        ++gbc.gridx;
        gbc.gridheight = 3;
        int vl2_gridx = gbc.gridx++;
        this.add((Component)new VerticalLine(400, 150), gbc);
        this.add((Component)PLCLoaderPanel.createPanelWithComponent("Loader<BR>Lock Out<BR>Bay M", this.lockoutSwitch1, true, false), gbc);
        ++gbc.gridx;
        this.add((Component)PLCLoaderPanel.createPanelWithComponent("Safety<BR>Belt<BR>Presence", this.safetyBeltPresenceSwitch1, true, false), gbc);
        ++gbc.gridx;
        this.add((Component)PLCLoaderPanel.createPanelWithComponent("<BR>Carrier<BR>Relay</BR>", this.carrierRelayRectangle, true, false), gbc);
        ++gbc.gridy;
        System.out.println("CARRIER RELAY second line gbc.gridy=" + gbc.gridy);
        gbc.gridx = 0;
        JLabel jlabel2 = new JLabel(LABEL2);
        jlabel2.setFont(Tools.BIG_FONT);
        this.add((Component)jlabel2, gbc);
        ++gbc.gridx;
        JPanel ap2Panel = PLCLoaderPanel.createPanelWithComponent("<BR>AP2</BR>", this.ap2Switch3, false, true, 20);
        ap2Panel.setBorder(BorderFactory.createTitledBorder("AC Status"));
        this.add((Component)ap2Panel, gbc);
        ++gbc.gridx;
        this.add((Component)PLCLoaderPanel.createPanelWithComponent("", this.create_lfuPanel(), false, true, 200), gbc);
        ++gbc.gridx;
        this.add((Component)new HorizontalLine(30), gbc);
        gbc.gridy += 4;
        gbc.gridx = 0;
        System.out.println("CARRIER RELAY third line gbc.gridy=" + gbc.gridy);
        JLabel jlabel3 = new JLabel(LABEL3);
        jlabel3.setFont(Tools.BIG_FONT);
        this.add((Component)jlabel3, gbc);
        ++gbc.gridx;
        this.add((Component)PLCLoaderPanel.createPanelWithComponent("Loader<BR>Engineering<BR>Mode", this.engineeringSwitch, false, true), gbc);
        gbc.anchor = 15;
        ++gbc.gridx;
        this.add((Component)new HorizontalLine(760), gbc);
        ++gbc.gridx;
        this.add((Component)new HorizontalLine(), gbc);
        ++gbc.gridx;
        this.add((Component)new HorizontalLine(15), gbc);
        ++gbc.gridx;
        this.add((Component)new HorizontalLine(150), gbc);
        ++gbc.gridx;
        this.add((Component)new HorizontalLine(150), gbc);
        gbc.anchor = 17;
        gbc.gridy += 4;
        System.out.println("Hooks RELAY first line gbc.gridy=" + gbc.gridy);
        int hooks_l1_gridy = gbc.gridy;
        gbc.gridx = 0;
        JLabel jlabel1_2 = new JLabel(LABEL1);
        jlabel1_2.setFont(Tools.BIG_FONT);
        this.add((Component)jlabel1_2, gbc);
        ++gbc.gridx;
        this.add((Component)PLCLoaderPanel.create_acStatusPanel(this.ap2Switch2, this.af0Switch2, "AF0"), gbc);
        ++gbc.gridx;
        this.add((Component)this.create_lfxPanel(), gbc);
        ++gbc.gridx;
        this.add((Component)new HorizontalLine(), gbc);
        System.out.println("Hooks RELAY end first line gbc.gridx=" + gbc.gridx);
        gbc.gridy += 4;
        System.out.println("Hooks RELAY second line gbc.gridy=" + gbc.gridy);
        gbc.gridx = 0;
        JLabel jlabel2_2 = new JLabel(LABEL2);
        jlabel2_2.setFont(Tools.BIG_FONT);
        this.add((Component)jlabel2_2, gbc);
        ++gbc.gridx;
        this.add((Component)PLCLoaderPanel.create_acStatusPanel(this.ap2Switch4, this.af3Switch, "AF3"), gbc);
        ++gbc.gridx;
        this.add((Component)this.create_lfyPanel(), gbc);
        ++gbc.gridx;
        this.add((Component)new HorizontalLine(), gbc);
        System.out.println("Hooks RELAY end second line gbc.gridx=" + gbc.gridx);
        gbc.gridy += 4;
        gbc.gridx = 0;
        System.out.println("Hooks RELAY third line gbc.gridy=" + gbc.gridy);
        JLabel jlabel4 = new JLabel(LABEL4);
        jlabel4.setFont(Tools.BIG_FONT);
        this.add((Component)jlabel4, gbc);
        gbc.gridx += 2;
        this.add((Component)this.create_lfzPanel(), gbc);
        ++gbc.gridx;
        this.add((Component)new HorizontalLine(), gbc);
        int hooks_l3_gridy = gbc.gridy;
        System.out.println("Hooks RELAY end third line gbc.gridx=" + gbc.gridx);
        gbc.gridy = hooks_l1_gridy;
        gbc.gridx = vl1_gridx;
        gbc.gridheight = 10;
        this.add((Component)new VerticalLine(300, 100), gbc);
        ++gbc.gridx;
        this.add((Component)PLCLoaderPanel.createPanelWithComponent("NO<BR>Default Status", this.defaultStatusDiamond2, true, true), gbc);
        gbc.gridx = vl2_gridx;
        gbc.gridheight = 10;
        this.add((Component)new VerticalLine(400, 50), gbc);
        ++gbc.gridx;
        this.add((Component)PLCLoaderPanel.createPanelWithComponent("Loader<BR>Lock Out<BR>Bay M", this.lockoutSwitch2, true, false), gbc);
        ++gbc.gridx;
        this.add((Component)PLCLoaderPanel.createPanelWithComponent("Safety<BR>Belt<BR>Presence", this.safetyBeltPresenceSwitch2, true, false), gbc);
        ++gbc.gridx;
        this.add((Component)PLCLoaderPanel.createPanelWithComponent("Hooks<BR>Relay</BR>", this.hooksRelayRectangle, true, false), gbc);
        gbc.gridheight = 10;
        gbc.gridy = hooks_l3_gridy + 4;
        gbc.gridx = 2;
        this.add((Component)this.create_lfsPanel(), gbc);
        gbc.gridheight = 10;
        gbc.gridy += 14;
        gbc.gridx = 2;
        this.add((Component)this.create_lfdPanel(), gbc);
        this.setDefaultValues();
    }

    private JPanel create_lfcPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("LFC"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Loader<BR>Docked", this.loaderDockedDigitalSwitch_lfc, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Hooks<BR>Closed</BR>", this.hooksClosedSwitch_lfc, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Filter<BR>Presence</BR>", this.filterPresenceSwitch_lfc, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Hooks NOT<BR>Over Clamped</BR>", this.notOverClampedStatusSwitch_lfc, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)this.create_lfcSubpanel(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)new HorizontalLine(), gbcp);
        return panel;
    }

    private JPanel create_lfcSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 1;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Filter<BR>Position</BR>", this.filterGoodPositionSwitch_lfc, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Hooks<BR>Clamped</BR>", this.hooksClampedStatusSwitch_lfc, true, false), gbcp);
        ++gbcp.gridy;
        gbcp.gridx = 1;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Carrier<BR>at ENGAGED</BR>", this.engagedPositionSwitch_lfc, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Hooks<BR>Unclamped</BR>", this.hooksUnclampedStatusSwitch_lfc, true, false), gbcp);
        ++gbcp.gridx;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        return panel;
    }

    private JPanel create_lfdPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("LFD"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Carrier<BR>NOT at HANDOFF</BR>", this.notHandoffPositionSwitch_lfd, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)this.create_lfdSubpanel(), gbcp);
        return panel;
    }

    private JPanel create_lfdSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        ++gbcp.gridx;
        gbcp.gridheight = 1;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Hooks NOT<BR>Closed</BR>", this.notClosedSwitch_lfd, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Filter<BR>Presence</BR>", this.filterPresenceSwitch_lfd, false, true), gbcp);
        ++gbcp.gridy;
        gbcp.gridx = 1;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Hooks NOT<BR>Opened</BR>", this.notOpenedSwitch_lfd, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Filter<BR>Not Present</BR>", this.notFilterPresenceSwitch_lfd, false, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        return panel;
    }

    private JPanel create_lfsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("LFS"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Loader<BR>Docked", this.loaderDockedDigitalSwitch_lfs, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)this.create_lfsSubpanel(), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Carrier<BR>NOT at HANDOFF</BR>", this.notHandoffPositionSwitch_lfs, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Hooks NOT<BR>Closed</BR>", this.notClosedSwitch_lfs, true, false), gbcp);
        return panel;
    }

    private JPanel create_lfsSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 11;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        PLCLoaderPanel.addToHorizontalLine(panel, gbcp, "Filter<BR>Position</BR>", this.filterGoodPositionSwitch_lfs, true);
        gbcp.gridx = 0;
        gbcp.gridy = 2;
        PLCLoaderPanel.addToHorizontalLine(panel, gbcp, "Filter<BR>Presence</BR>", this.filterPresenceSwitch_lfs, true);
        return panel;
    }

    private JPanel create_lfuPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("LFU"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Loader<BR>Docked", this.loaderDockedDigitalSwitch_lfu, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Hooks<BR>Opened</BR>", this.openedSwitch_lfu, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Hooks NOT<BR>Under Clamped</BR>", this.notUnderClampedStatusSwitch_lfu, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Hooks NOT<BR>Over Clamped</BR>", this.notOverClampedStatusSwitch_lfu, true, true), gbcp);
        return panel;
    }

    private JPanel create_lfxPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Loader<BR>Docked", this.loaderDockedDigitalSwitch_lfx, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Hooks NOT<BR>Over Clamped</BR>", this.notOverClampedStatusSwitch_lfx, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)this.create_lfxSubpanel(), gbcp);
        return panel;
    }

    private JPanel create_lfxSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Carrier<BR>at HANDOFF</BR>", this.handoffPositionSwitch_lfx, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Filter<BR>Presence</BR>", this.filterPresenceSwitch_lfx, true, false), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Hooks<BR>Closed</BR>", this.hooksClosedSwitch_lfx, true, true), gbcp);
        ++gbcp.gridy;
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Carrier<BR>at ENGAGED</BR>", this.engagedPositionSwitch_lfx, true, true), gbcp);
        ++gbcp.gridx;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        gbcp.gridx += 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        return panel;
    }

    public JPanel create_lfyPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Loader<BR>Docked", this.loaderDockedDigitalSwitch_lfy, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Hooks NOT<BR>Over Clamped</BR>", this.notOverClampedStatusSwitch_lfy, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Carrier<BR>at HANDOFF</BR>", this.handoffPositionSwitch_lfy, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Filter<BR>Presence</BR>", this.filterPresenceSwitch_lfy, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Hooks<BR>Unclamped</BR>", this.hooksUnclampedStatusSwitch_lfy, false, true), gbcp);
        return panel;
    }

    public JPanel create_lfzPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Carrier<BR>at ENGAGED</BR>", this.notOverClampedStatusSwitch_lfz, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)this.create_lfzSubpanel(), gbcp);
        return panel;
    }

    public JPanel create_lfzSubpanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Loader<BR>Docked", this.loaderDockedDigitalSwitch_lfz, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Carrier<BR>at ENGAGED</BR>", this.engagedPositionSwitch_lfz, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Filter<BR>Not Present</BR>", this.notFilterPresenceSwitch_lfz, false, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Hooks<BR>Opened</BR>", this.openedSwitch_lfz, false, true), gbcp);
        ++gbcp.gridx;
        ++gbcp.gridy;
        gbcp.gridx = 1;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("Carrier<BR>at STORAGE</BR>", this.storagePositionSwitch_lfz, true, true), gbcp);
        ++gbcp.gridx;
        panel.add((Component)new HorizontalLine(), gbcp);
        gbcp.gridy = 0;
        gbcp.gridx = 5;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        return panel;
    }

    private static JPanel create_acStatusPanel(DigitalSwitch ap2s, DigitalSwitch af0s, String afName) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("AC Status"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 11;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("<BR>AP2</BR>", ap2s, false, true, 20), gbcp);
        ++gbcp.gridx;
        panel.add((Component)PLCLoaderPanel.createPanelWithComponent("<BR>" + afName + "</BR>", af0s, false, true, 20), gbcp);
        return panel;
    }

    private void setDefaultValues() {
        for (DigitalSwitch digitalSwitch : this.digitalList) {
            digitalSwitch.setColor(Color.gray);
        }
        for (JComponent jComponent : this.diamondList) {
            ((DiamondSwitch)jComponent).setColor(Color.gray);
        }
        this.filterGoodPositionSwitch_lfc.setColor(Color.gray);
        this.filterGoodPositionSwitch_lfs.setColor(Color.gray);
        this.defaultStatusDiamond1.setColor(Color.gray);
        this.defaultStatusDiamond2.setColor(Color.gray);
        this.safetyBeltPresenceSwitch1.setColor(Color.gray);
        this.safetyBeltPresenceSwitch2.setColor(Color.gray);
        this.carrierRelayRectangle.setColor(Color.gray);
        this.hooksRelayRectangle.setColor(Color.gray);
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    @Override
    public String toString() {
        return "PLC Loader Panel";
    }

    public static JPanel createPanelWithComponent(String componentName, JComponent component, boolean drawHLineBefore, boolean drawHLineAfter) {
        int length = 30;
        return PLCLoaderPanel.createPanelWithComponent(componentName, component, drawHLineBefore, drawHLineAfter, length);
    }

    public static JPanel createPanelWithComponent(String componentName, JComponent component, boolean drawHLineBefore, boolean drawHLineAfter, int length) {
        int hlStartingY = component instanceof DigitalSwitch ? 10 : (component instanceof DiamondSwitch ? 25 : 5);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        if (drawHLineBefore) {
            ++gbcp.gridy;
            panel.add((Component)new HorizontalLine(length, hlStartingY), gbcp);
            ++gbcp.gridx;
        }
        gbcp.gridy = 0;
        panel.add((Component)new JLabel("<HTML><CENTER>" + componentName + "</CENTER></HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)component, gbcp);
        if (drawHLineAfter) {
            ++gbcp.gridx;
            panel.add((Component)new HorizontalLine(length, hlStartingY), gbcp);
        }
        return panel;
    }

    public static void addToHorizontalLine(JPanel panel, GridBagConstraints gbcl, String componentName, JComponent component, boolean drawLine) {
        int hlStartingY = 15;
        panel.add((Component)new JLabel("<HTML><CENTER>" + componentName + "</CENTER></HTML>"), gbcl);
        ++gbcl.gridy;
        panel.add((Component)component, gbcl);
        if (drawLine) {
            ++gbcl.gridx;
            panel.add((Component)new HorizontalLine(hlStartingY), gbcl);
        }
        --gbcl.gridy;
        if (drawLine) {
            ++gbcl.gridx;
        }
    }

    private class UpdateLoader
    implements Runnable {
        private final StatusDataPublishedByLoader s;

        public UpdateLoader(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {
            for (DigitalSwitch ds : new DigitalSwitch[]{PLCLoaderPanel.this.filterPresenceSwitch_lfc, PLCLoaderPanel.this.filterPresenceSwitch_lfd, PLCLoaderPanel.this.filterPresenceSwitch_lfs, PLCLoaderPanel.this.filterPresenceSwitch_lfx, PLCLoaderPanel.this.filterPresenceSwitch_lfy}) {
                ds.updateColor(this.s.isFilterPresenceSensorsInError(), this.s.getFilterPresenceSensorValue());
            }
            PLCLoaderPanel.this.notFilterPresenceSwitch_lfz.updateColor(this.s.isFilterPresenceSensorsInError(), !this.s.getFilterPresenceSensorValue());
            for (DigitalSwitch ds : new DigitalSwitch[]{PLCLoaderPanel.this.loaderDockedDigitalSwitch_lfc, PLCLoaderPanel.this.loaderDockedDigitalSwitch_lfs, PLCLoaderPanel.this.loaderDockedDigitalSwitch_lfu, PLCLoaderPanel.this.loaderDockedDigitalSwitch_lfx, PLCLoaderPanel.this.loaderDockedDigitalSwitch_lfy, PLCLoaderPanel.this.loaderDockedDigitalSwitch_lfz}) {
                ds.updateColor(this.s.isLoaderOnCameraSensorsInError(), this.s.isLoaderOnCameraSensorValue());
            }
            PLCLoaderPanel.this.af0Switch1.updateColor(this.s.isAf0InError(), this.s.isAf0());
            PLCLoaderPanel.this.af0Switch2.updateColor(this.s.isAf0InError(), this.s.isAf0());
            PLCLoaderPanel.this.af3Switch.updateColor(this.s.isAf3InError(), this.s.isAf3());
            PLCLoaderPanel.this.ap2Switch1.updateColor(this.s.isAp2InError(), this.s.isAp2());
            PLCLoaderPanel.this.ap2Switch2.updateColor(this.s.isAp2InError(), this.s.isAp2());
            PLCLoaderPanel.this.ap2Switch3.updateColor(this.s.isAp2InError(), this.s.isAp2());
            PLCLoaderPanel.this.ap2Switch4.updateColor(this.s.isAp2InError(), this.s.isAp2());
            PLCLoaderPanel.this.engineeringSwitch.updateColor(this.s.isKeyEngInError(), this.s.isKeyEng());
            PLCLoaderPanel.this.lockoutSwitch1.updateColor(this.s.isKeyLockInError(), this.s.isKeyLock());
            PLCLoaderPanel.this.lockoutSwitch2.updateColor(this.s.isKeyLockInError(), this.s.isKeyLock());
            PLCLoaderPanel.this.filterGoodPositionSwitch_lfc.setColor(this.s.isFilterPositionStatus() ? Tools.greenColor : Color.gray);
            PLCLoaderPanel.this.filterGoodPositionSwitch_lfs.setColor(this.s.isFilterPositionStatus() ? Tools.greenColor : Color.gray);
            PLCLoaderPanel.this.defaultStatusDiamond1.setColor(this.s.isLoaderDefaultStatus() ? Tools.greenColor : Color.gray);
            PLCLoaderPanel.this.defaultStatusDiamond2.setColor(this.s.isLoaderDefaultStatus() ? Tools.greenColor : Color.gray);
            PLCLoaderPanel.this.safetyBeltPresenceSwitch1.setColor(this.s.isSafetyBeltPresence() ? Tools.greenColor : Color.gray);
            PLCLoaderPanel.this.safetyBeltPresenceSwitch2.setColor(this.s.isSafetyBeltPresence() ? Tools.greenColor : Color.gray);
            PLCLoaderPanel.this.carrierRelayRectangle.setColor(this.s.isCarrierRelayStatus() ? Tools.greenColor : Color.gray);
            PLCLoaderPanel.this.hooksRelayRectangle.setColor(this.s.isHooksRelayStatus() ? Tools.greenColor : Color.gray);
        }
    }

    private class UpdateClamp
    implements Runnable {
        private final StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        @Override
        public void run() {
            PLCLoaderPanel.this.hooksClosedSwitch_lfc.setColor(this.s.getClampState().equals(FcsEnumerations.LockStatus.CLOSED) ? Tools.greenColor : Color.GRAY);
            PLCLoaderPanel.this.hooksClosedSwitch_lfx.setColor(this.s.getClampState().equals(FcsEnumerations.LockStatus.CLOSED) ? Tools.greenColor : Color.GRAY);
            PLCLoaderPanel.this.openedSwitch_lfu.setColor(this.s.getClampState().equals(FcsEnumerations.LockStatus.OPENED) ? Tools.greenColor : Color.GRAY);
            PLCLoaderPanel.this.notOpenedSwitch_lfd.setColor(this.s.getClampState().equals(FcsEnumerations.LockStatus.OPENED) ? Color.GRAY : Tools.greenColor);
            PLCLoaderPanel.this.notClosedSwitch_lfd.setColor(this.s.getClampState().equals(FcsEnumerations.LockStatus.CLOSED) ? Color.GRAY : Tools.greenColor);
            PLCLoaderPanel.this.notClosedSwitch_lfs.setColor(this.s.getClampState().equals(FcsEnumerations.LockStatus.CLOSED) ? Color.GRAY : Tools.greenColor);
            PLCLoaderPanel.this.notClosedSwitch_lfu.setColor(this.s.getClampState().equals(FcsEnumerations.LockStatus.CLOSED) ? Color.GRAY : Tools.greenColor);
            PLCLoaderPanel.this.hooksClampedStatusSwitch_lfc.setColor(this.s.isForceClampedStatus() ? Tools.greenColor : Color.GRAY);
            PLCLoaderPanel.this.hooksUnclampedStatusSwitch_lfc.setColor(this.s.isForceUnclampedStatus() ? Tools.greenColor : Color.GRAY);
            PLCLoaderPanel.this.hooksUnclampedStatusSwitch_lfy.setColor(this.s.isForceUnclampedStatus() ? Tools.greenColor : Color.GRAY);
            PLCLoaderPanel.this.notOverClampedStatusSwitch_lfc.setColor(this.s.isForceOverClampedStatus() ? Color.GRAY : Tools.greenColor);
            PLCLoaderPanel.this.notOverClampedStatusSwitch_lfu.setColor(this.s.isForceOverClampedStatus() ? Color.GRAY : Tools.greenColor);
            PLCLoaderPanel.this.notOverClampedStatusSwitch_lfx.setColor(this.s.isForceOverClampedStatus() ? Color.GRAY : Tools.greenColor);
            PLCLoaderPanel.this.notOverClampedStatusSwitch_lfy.setColor(this.s.isForceOverClampedStatus() ? Color.GRAY : Tools.greenColor);
            PLCLoaderPanel.this.notOverClampedStatusSwitch_lfz.setColor(this.s.isForceOverClampedStatus() ? Color.GRAY : Tools.greenColor);
            PLCLoaderPanel.this.notUnderClampedStatusSwitch_lfu.setColor(this.s.isForceUnderClampedStatus() ? Color.GRAY : Tools.greenColor);
        }
    }

    private class UpdateCarrier
    implements Runnable {
        private final StatusDataPublishedByLoaderCarrier s;

        public UpdateCarrier(StatusDataPublishedByLoaderCarrier status) {
            this.s = status;
        }

        @Override
        public void run() {
            PLCLoaderPanel.this.storagePositionSwitch_lfz.setColor(this.s.isAtStorage() ? Tools.greenColor : Color.gray);
            PLCLoaderPanel.this.handoffPositionSwitch_lfy.setColor(this.s.isAtHandoff() ? Tools.greenColor : Color.gray);
            PLCLoaderPanel.this.notHandoffPositionSwitch_lfs.setColor(this.s.isAtHandoff() ? Color.gray : Tools.greenColor);
            PLCLoaderPanel.this.notHandoffPositionSwitch_lfd.setColor(this.s.isAtHandoff() ? Color.gray : Tools.greenColor);
            PLCLoaderPanel.this.engagedPositionSwitch_lfc.setColor(this.s.isAtEngaged() ? Tools.greenColor : Color.gray);
            PLCLoaderPanel.this.engagedPositionSwitch_lfx.setColor(this.s.isAtEngaged() ? Tools.greenColor : Color.gray);
            PLCLoaderPanel.this.engagedPositionSwitch_lfz.setColor(this.s.isAtEngaged() ? Tools.greenColor : Color.gray);
        }
    }
}

