
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.BorderLayout;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeSelectionModel;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;

/**
 * A Panel to display on the bottom of all FCS GUIs.
 *
 * @author virieux
 */
public class BottomPanel extends JPanel implements TreeSelectionListener {
    private static final long serialVersionUID = -447188631236670592L;

    public GatherPanel gatherPanel;
    protected final String title;
    protected JTree tree;
    protected JPanel rightPanel;
    protected final JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
    protected JPanel helpPanel;

    /**
     * Creation of a BottomPanel with a title. This initializes all components.
     *
     * @param title
     */
    public BottomPanel(String title) {
        this.title = title;
        initComponents();
    }

    /**
     * Creation of a BottomPanel with a title and a GatherPanel. This initializes
     * all components.
     *
     * @param gatherPanel
     * @param title
     */
    public BottomPanel(GatherPanel gatherPanel, String title) {
        this.gatherPanel = gatherPanel;
        this.title = title;
        initComponents();
    }

    /**
     * Initialize gatherPanel with configuration data : hardwareList.
     *
     * @param configInfo
     * @param hardwareList
     * @throws InterruptedException
     * @throws InvocationTargetException
     */
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareList)
            throws InterruptedException, InvocationTargetException {
        this.gatherPanel.initializeGUIWithConfigInfo(configInfo, hardwareList);
        this.gatherPanel.setHardwareNames(hardwareList);
    }

    /**
     * Initialize gatherPanel with configuration data and Loader hardwareList.
     *
     * @param configInfo
     * @param hardwareList
     * @throws InterruptedException
     * @throws InvocationTargetException
     */
    public void initializeGUIWithLoaderConfigInfo(ConfigurationInfo configInfo, List<String> hardwareList)
            throws InterruptedException, InvocationTargetException {
        this.gatherPanel.initializeGUIWithLoaderConfigInfo(configInfo, hardwareList);
        this.gatherPanel.setHardwareNames(hardwareList);
    }

    /**
     * Initialize gatherPanel with configuration data : filter names list.
     *
     * @param configInfo
     * @param filterNamesList
     * @throws InterruptedException
     * @throws InvocationTargetException
     */
    public void initializeGUIWithFiltersInfo(ConfigurationInfo configInfo, List<String> filterNamesList)
            throws InterruptedException, InvocationTargetException {
        this.gatherPanel.initializeGUIWithFiltersInfo(configInfo, filterNamesList);
    }

    /**
     * Initialize gatherPanel with controllers map : keys are mobil item names,
     * values are controller names.
     *
     * @param controllersMap
     */
    void initializeGUIWithControllersMap(Map<String, String> controllersMap) {
        this.gatherPanel.initializeGUIWithControllersMap(controllersMap);
    }

    /**
     * This reset the gatherPanel.
     */
    void resetPanel() {
        this.gatherPanel.resetPanel();
    }

    /**
     * Creates the nodes of the TreePanel.
     *
     * @param top
     */
    public void createNodes(DefaultMutableTreeNode top) {
        /** CANopen devices panels */
        DefaultMutableTreeNode devicesNode = new DefaultMutableTreeNode("CANopen devices");
        devicesNode.add(new DefaultMutableTreeNode(gatherPanel.getCanOpenHardwareListPanel()));
        top.add(devicesNode);
        /** CANopen devices panels */

    }

    private void initComponents() {
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), title));
        setForeground(new Color(204, 204, 255));
        // setLayout(new GridBagLayout());
        setLayout(new BorderLayout());
        // Create the nodes.
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(title);
        createNodes(top);

        // Create a tree that allows one selection at a time.
        tree = new JTree(top);
        tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);

        // Listen for when the selection changes.
        tree.addTreeSelectionListener((TreeSelectionListener) this);

        // Create the viewing rightPanel.
        rightPanel = new JPanel();
        rightPanel.setBackground(new Color(238, 238, 238));

        // Add the split rightPanel to this Panel.
        add(tree, BorderLayout.WEST);
        add(rightPanel, BorderLayout.CENTER);

        // TODO fill helpPanel
        helpPanel = new JPanel();
        JLabel helpLabel = new JLabel("Nothing to display");
        helpPanel.add(helpLabel);
    }

    /**
     * Delegates to gatherPanel the managing of status message.
     *
     * @param msg
     */
    public void onStatusMessage(StatusMessage msg) {
        this.gatherPanel.onStatusMessage(msg);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode) tree.getLastSelectedPathComponent();

        if (node == null) {
            return;
        }

        Object nodeInfo = node.getUserObject();

        if (nodeInfo == null) {
            return;
        }

        if (node.isLeaf()) {
            JPanel panel = (JPanel) nodeInfo;
            displayPanel(panel);
        } else {
            // TODO find something clever to be done here
        }

    }

    protected void displayPanel(JPanel panel) {
        if (panel != null) {
            rightPanel.removeAll();
            rightPanel.add(panel, BorderLayout.CENTER);
        } else {
            rightPanel.removeAll();
            rightPanel.add(helpPanel, BorderLayout.CENTER);
        }
        revalidate();
        repaint();
    }


}
