package org.lsst.ccs.subsystems.fcs.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.InterfaceAutochangerGUI;
import org.lsst.ccs.subsystems.fcs.carousel.ui.InterfaceCarouselGUI;
import org.lsst.ccs.subsystems.fcs.loader.ui.InterfaceLoaderGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;

/**
 * A GUI for the whole Filter Changer Subsystem.
 *
 * @author virieux
 */
public class FcsGUI extends GeneralGUI implements InterfaceCarouselGUI, InterfaceAutochangerGUI,
        InterfaceLoaderGUI, InterfaceFcsGUI {
    private static final long serialVersionUID = -6702752740750789411L;

    /* actions timeout for autochanger */
    private long timeoutForTrucksMotion;
    private long timeoutForOnlineClampMotion;
    //TODO retrieve timeoutForLatchesMotion from configuration system
    private long timeoutForLatchesMotion = 3000;

    // actions timeout for Loader
    protected long updateCarrierPositionTimeout;
    protected long openHooksTimeout;
    protected long closeHooksTimeout;
    protected long clampHooksTimeout;
    protected long homingHooksTimeout;
    protected long goToHandoffTimeout;
    protected long goToStorageTimeout;
    protected long goToEngagedTimeout;
    protected long quickStopTimeout;


    /**
     * A constructor with a name, a destination (subsystem name) and an
     * AgentMessagingLayer.
     * 
     * @param name
     * @param role
     * @param aml
     */
    public FcsGUI(String name, String role, AgentMessagingLayer aml) {
        super(name, role, aml);
        FcsGatherPanel fcsGatherPanel;
        fcsGatherPanel = new FcsGatherPanel(this);
        FcsBottomPanel fcsBottomPanel = new FcsBottomPanel(fcsGatherPanel, "FCS");
        this.generalPanel = new GeneralPanel(this, fcsBottomPanel);
        pane = new JScrollPane(generalPanel);

        /* Initialization of loader timeout */
        openHooksTimeout = 0;
        closeHooksTimeout = 0;
        clampHooksTimeout = 0;
        homingHooksTimeout = 0;
        goToHandoffTimeout = 0;
        goToStorageTimeout = 0;
        abortTimeout = 1000;
        quickStopTimeout = 1000;
        updateStateWithSensorsTimeout = 1000;
        updateCarrierPositionTimeout = 1000;
    }

    /**
     ******************************************************************************
     ** Loader commands
     * *****************************************************************************
     *
     */

    @Override
    public void setLoGoToHandoffTimeout(int aInt) {
        this.goToHandoffTimeout = aInt;
    }

    @Override
    public void setLoGoToStorageTimeout(int aInt) {
        this.goToStorageTimeout = aInt;
    }

    @Override
    public void setLoGoToEngagedTimeout(int goToEngagedTimeout) {
        this.goToEngagedTimeout = goToEngagedTimeout;
    }

    @Override
    public void setOpenHooksTimeout(long openHooksTimeout) {
        this.openHooksTimeout = openHooksTimeout;
    }

    @Override
    public void setCloseHooksTimeout(long closeHooksTimeout) {
        this.closeHooksTimeout = closeHooksTimeout;
    }

    @Override
    public void setClampHooksTimeout(long clampHooksTimeout) {
        this.clampHooksTimeout = clampHooksTimeout;
    }

    @Override
    public long getLoGoToHandoffTimeout() {
        return goToHandoffTimeout;
    }

    @Override
    public long getLoGoToStorageTimeout() {
        return goToStorageTimeout;
    }

    @Override
    public long getLoGoToEngagedTimeout() {
        return goToEngagedTimeout;
    }


    @Override
    public long getOpenHooksTimeout() {
        return openHooksTimeout;
    }

    @Override
    public long getCloseHooksTimeout() {
        return closeHooksTimeout;
    }

    @Override
    public long getClampHooksTimeout() {
        return clampHooksTimeout;
    }

    /**
     ******************************************************************************
     ** Autochanger commands
     ******************************************************************************
     *
     */

    /**
     *
     * @param timeoutForTrucksMotion
     */
    @Override
    public void setTimeoutForTrucksMotion(long timeoutForTrucksMotion) {
        this.timeoutForTrucksMotion = timeoutForTrucksMotion;
    }

    @Override
    public void setTimeoutForOnlineClampMotion(long timeoutForOnlineClampMotion) {
        this.timeoutForOnlineClampMotion = timeoutForOnlineClampMotion;
    }

    @Override
    public void setTimeoutForLatchesMotion(long timeoutForLatchesMotion) {
        this.timeoutForLatchesMotion = timeoutForLatchesMotion;
    }

    @Override
    public long getTimeoutForTrucksMotion() {
        return timeoutForTrucksMotion;
    }

    @Override
    public long getTimeoutForOnlineClampMotion() {
        return timeoutForOnlineClampMotion;
    }

    @Override
    public long getTimeoutForLatchesMotion() {
        return timeoutForLatchesMotion;
    }

    /**
     * This main launches an GUI for the whole subsystem "fcs". It's used only for
     * tests.
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        Agent agent = new Agent("FcsGUI", AgentInfo.AgentType.CONSOLE);
        FcsGUI t = new FcsGUI(agent.getName(), "fcs", agent.getMessagingAccess());
        agent.startAgent();

        JFrame frame = new JFrame("Fcs View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

}
