/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class LoaderStatusPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String title = "loader status";
    private final DigitalSwitch loaderPresenceSwitch = new DigitalSwitch();
    private final DigitalSwitch loader_LPS_Switch = new DigitalSwitch();
    private final DigitalSwitch loader_LRH_Switch = new DigitalSwitch();

    public LoaderStatusPanel() {
        this.initComponents();
    }

    void updateLoader(StatusDataPublishedByLoader s) {
        SwingUtilities.invokeLater(new UpdateLoader(s));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.MAGENTA, 6), "Read on loaderPlutoGateway"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = Tools.insets_std;
        this.add((Component)new JLabel("Loader on camera"), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel("Loader_LPS (loader at Storage)"), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel("Loader_LRH (loader holds filter)"), gbc);
        gbc.gridy = 0;
        gbc.gridx = 1;
        gbc.anchor = 13;
        this.add((Component)this.loaderPresenceSwitch, gbc);
        ++gbc.gridy;
        this.add((Component)this.loader_LPS_Switch, gbc);
        ++gbc.gridy;
        this.add((Component)this.loader_LRH_Switch, gbc);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.loader_LPS_Switch.setColor(Color.GRAY);
        this.loader_LRH_Switch.setColor(Color.GRAY);
        this.loaderPresenceSwitch.setColor(Color.GRAY);
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    @Override
    public String toString() {
        return title;
    }

    public static void main(String[] args) {
        LoaderStatusPanel d = new LoaderStatusPanel();
        JFrame frame = new JFrame("LoaderStatus Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateLoader
    implements Runnable {
        private StatusDataPublishedByLoader s;

        public UpdateLoader(StatusDataPublishedByLoader status) {
            this.s = status;
        }

        @Override
        public void run() {
            LoaderStatusPanel.this.loader_LPS_Switch.updateColor(this.s.isLpsInError(), this.s.isLps());
            LoaderStatusPanel.this.loader_LRH_Switch.updateColor(this.s.isLrhInError(), this.s.isLrh());
            LoaderStatusPanel.this.loaderPresenceSwitch.updateColor(this.s.isLoaderOnCameraSensorsInError(), this.s.isLoaderOnCameraSensorValue());
        }
    }
}

